/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.os.Bundle;
import android.support.v4.view.MenuItem;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseViewActivity;
import com.ushahidi.android.app.models.ListReportNewsModel;
import com.ushahidi.android.app.views.ReportNewsView;
import java.util.List;

public class ViewReportNewsActivity
extends BaseViewActivity<ReportNewsView, ListReportNewsModel> {
    private ListReportNewsModel news;
    private List<ListReportNewsModel> listNews;
    private int position;
    private int reportId;

    public ViewReportNewsActivity() {
        super(ReportNewsView.class, R.layout.news, R.menu.view_media);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.news = new ListReportNewsModel();
        this.view = new ReportNewsView(this);
        this.reportId = this.getIntent().getExtras().getInt("reportid", 0);
        this.position = this.getIntent().getExtras().getInt("position", 0);
        this.initReport(this.position);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_forward) {
            this.goNext();
            return true;
        }
        if (item.getItemId() == R.id.menu_backward) {
            this.goPrevious();
            return true;
        }
        if (item.getItemId() == R.id.menu_share) {
            this.share();
        }
        return super.onOptionsItemSelected(item);
    }

    private void goNext() {
        if (this.listNews != null) {
            ++this.position;
            if (this.position <= this.listNews.size() - 1) {
                ((ReportNewsView)this.view).goNext(this.listNews.get(this.position).getUrl());
                int page = this.position;
                this.setTitle(page + 1);
            } else {
                this.position = this.listNews.size() - 1;
            }
        }
    }

    private void goPrevious() {
        if (this.listNews != null) {
            --this.position;
            if (this.position < this.listNews.size() - 1 && this.position != -1) {
                ((ReportNewsView)this.view).goPrevious(this.listNews.get(this.position).getUrl());
                int page = this.position;
                this.setTitle(page + 1);
            } else {
                this.position = 0;
            }
        }
    }

    private void initReport(int position) {
        this.listNews = this.news.getNewsByReportId(this.reportId);
        if (((ReportNewsView)this.view).webView != null && this.listNews != null) {
            ((ReportNewsView)this.view).url = this.listNews.get(position).getUrl();
            ((ReportNewsView)this.view).setWebView();
            int page = position;
            this.setTitle(page + 1);
        }
    }

    @Override
    public void setTitle(int page) {
        StringBuilder title = new StringBuilder(String.valueOf(page));
        title.append("/");
        if (this.listNews != null) {
            title.append(this.listNews.size());
        }
        this.setActionBarTitle(title.toString());
    }

    private void share() {
        String shareString = this.getString(R.string.share_template, new Object[]{" ", " \n" + ((ReportNewsView)this.view).url});
        this.shareText(shareString);
    }
}

