/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.support.v4.view.MenuItem;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageSwitcher;
import android.widget.ViewSwitcher;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseViewActivity;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.ListPhotoModel;
import com.ushahidi.android.app.util.ImageSwitchWorker;
import com.ushahidi.android.app.views.ReportPhotoView;
import java.util.List;

public class ViewReportPhotoActivity
extends BaseViewActivity<ReportPhotoView, ListPhotoModel>
implements AdapterView.OnItemSelectedListener,
ViewSwitcher.ViewFactory,
View.OnTouchListener {
    private ListPhotoModel photo;
    private List<Photo> photos;
    private int position;
    private int reportId;
    private String fileName;
    private GestureDetector gestureDetector;
    private static final int SWIPE_MIN_DISTANCE = 120;
    private static final int SWIPE_MAX_OFF_PATH = 250;
    private static final int SWIPE_THRESHOLD_VELOCITY = 200;

    public ViewReportPhotoActivity() {
        super(ReportPhotoView.class, R.layout.photo, R.menu.view_media);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.photo = new ListPhotoModel();
        this.view = new ReportPhotoView(this);
        this.reportId = this.getIntent().getExtras().getInt("reportid", 0);
        this.position = this.getIntent().getExtras().getInt("position", 0);
        this.initReport(this.position);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_forward) {
            this.goNext();
            return true;
        }
        if (item.getItemId() == R.id.menu_backward) {
            this.goPrevious();
            return true;
        }
        if (item.getItemId() == R.id.menu_share) {
            this.sharePhoto(ImageManager.getPhotoPath((Context)this) + this.fileName);
        }
        return super.onOptionsItemSelected(item);
    }

    private void goNext() {
        if (this.photos != null) {
            ++this.position;
            if (this.position <= this.photos.size() - 1) {
                this.setImage(((ReportPhotoView)this.view).imageSwitcher);
                ((ReportPhotoView)this.view).goNext();
                int page = this.position;
                this.setTitle(page + 1);
            } else {
                this.position = this.photos.size() - 1;
            }
        }
    }

    private void goPrevious() {
        if (this.photos != null) {
            --this.position;
            if (this.position < this.photos.size() - 1 && this.position != -1) {
                this.setImage(((ReportPhotoView)this.view).imageSwitcher);
                ((ReportPhotoView)this.view).goPrevious();
                int page = this.position;
                this.setTitle(page + 1);
            } else {
                this.position = 0;
            }
        }
    }

    private void initReport(int position) {
        this.photos = this.photo.getPhotosByReportId(this.reportId);
        if (this.photos.size() == 0) {
            this.photos = this.photo.getPhotosByCheckinId(this.reportId);
        }
        if (((ReportPhotoView)this.view).imageSwitcher != null) {
            ((ReportPhotoView)this.view).imageSwitcher.setFactory((ViewSwitcher.ViewFactory)this);
            ((ReportPhotoView)this.view).imageSwitcher.setOnTouchListener((View.OnTouchListener)this);
        }
        this.gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetectorListener());
        if (this.photos != null && this.photos.size() > 0) {
            this.fileName = this.photos.get(position).getPhoto();
            this.setImage(((ReportPhotoView)this.view).imageSwitcher);
            int page = position;
            this.setTitle(page + 1);
        }
    }

    @Override
    public void setTitle(int page) {
        StringBuilder title = new StringBuilder(String.valueOf(page));
        title.append("/");
        if (this.photos != null) {
            title.append(this.photos.size());
        }
        this.setActionBarTitle(title.toString());
    }

    public void onLocationChanged(Location location) {
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public View makeView() {
        return ((ReportPhotoView)this.view).imageView();
    }

    public void onItemSelected(AdapterView<?> parent, View v, int position, long id2) {
    }

    public void onNothingSelected(AdapterView<?> arg0) {
    }

    public boolean onTouch(View v, MotionEvent event) {
        return this.gestureDetector.onTouchEvent(event);
    }

    private void setImage(ImageSwitcher imageSwitcher) {
        ImageSwitchWorker imageWorker = new ImageSwitchWorker((Context)this);
        imageWorker.setImageFadeIn(true);
        imageWorker.loadImage(this.fileName, imageSwitcher, true, 0);
    }

    class GestureDetectorListener
    extends GestureDetector.SimpleOnGestureListener {
        GestureDetectorListener() {
        }

        public boolean onFling(MotionEvent eventA, MotionEvent eventB, float velocityX, float velocityY) {
            try {
                ViewReportPhotoActivity.this.log("Swipe Max Off Path");
                if (Math.abs(eventA.getY() - eventB.getY()) > 250.0f) {
                    return false;
                }
                if (eventA.getX() - eventB.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                    ViewReportPhotoActivity.this.goPrevious();
                }
            }
            catch (Exception e) {
                ViewReportPhotoActivity.this.log("GestureDetectorListener", e);
            }
            return false;
        }
    }
}

