/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.phone;

import android.os.Bundle;
import android.support.v4.view.MenuItem;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.activities.BaseViewActivity;
import com.ushahidi.android.app.models.ListReportVideoModel;
import com.ushahidi.android.app.views.ReportVideoView;
import java.util.List;

public class ViewReportVideoActivity
extends BaseViewActivity<ReportVideoView, ListReportVideoModel> {
    private ListReportVideoModel video;
    private List<ListReportVideoModel> listVideos;
    private int position;
    private int reportId;

    public ViewReportVideoActivity() {
        super(ReportVideoView.class, R.layout.video, R.menu.view_media);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.video = new ListReportVideoModel();
        this.view = new ReportVideoView(this);
        this.reportId = this.getIntent().getExtras().getInt("reportid", 0);
        this.position = this.getIntent().getExtras().getInt("position", 0);
        this.initReport(this.position);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_forward) {
            this.goNext();
            return true;
        }
        if (item.getItemId() == R.id.menu_backward) {
            this.goPrevious();
            return true;
        }
        if (item.getItemId() == R.id.menu_share) {
            this.share();
        }
        return super.onOptionsItemSelected(item);
    }

    private void goNext() {
        if (this.listVideos != null) {
            ++this.position;
            if (this.position <= this.listVideos.size() - 1) {
                ((ReportVideoView)this.view).goNext(this.listVideos.get(this.position).getVideo());
                int page = this.position;
                this.setTitle(page + 1);
            } else {
                this.position = this.listVideos.size() - 1;
            }
        }
    }

    private void goPrevious() {
        if (this.listVideos != null) {
            --this.position;
            if (this.position < this.listVideos.size() - 1 && this.position != -1) {
                ((ReportVideoView)this.view).goPrevious(this.listVideos.get(this.position).getVideo());
                int page = this.position;
                this.setTitle(page + 1);
            } else {
                this.position = 0;
            }
        }
    }

    private void initReport(int position) {
        this.listVideos = this.video.getVideosByReportId(this.reportId);
        if (((ReportVideoView)this.view).webView != null && this.listVideos != null) {
            ((ReportVideoView)this.view).url = this.listVideos.get(position).getVideo();
            ((ReportVideoView)this.view).setWebView();
            int page = position;
            this.setTitle(page + 1);
        }
    }

    @Override
    public void setTitle(int page) {
        StringBuilder title = new StringBuilder(String.valueOf(page));
        title.append("/");
        if (this.listVideos != null) {
            title.append(this.listVideos.size());
        }
        this.setActionBarTitle(title.toString());
    }

    private void share() {
        String shareString = this.getString(R.string.share_template, new Object[]{" ", " \n" + ((ReportVideoView)this.view).url});
        this.shareText(shareString);
    }
}

