/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.tablet;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.ActionBar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentMapActivity;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.Menu;
import android.support.v4.view.MenuItem;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import com.ushahidi.android.app.MainApplication;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.Settings;
import com.ushahidi.android.app.ui.phone.CheckinTabActivity;
import com.ushahidi.android.app.ui.phone.ReportTabActivity;
import com.ushahidi.android.app.ui.tablet.AboutFragment;
import com.ushahidi.android.app.ui.tablet.CheckinTabFragment;
import com.ushahidi.android.app.ui.tablet.ListMapFragment;
import com.ushahidi.android.app.ui.tablet.ListMapFragmentListener;
import com.ushahidi.android.app.ui.tablet.ReportTabFragment;

public class DashboardActivity
extends FragmentMapActivity
implements ListMapFragmentListener,
ActionBar.OnNavigationListener {
    private boolean detailsInline = false;
    private SpinnerAdapter mSpinnerAdapter;
    private ListMapFragment maps;
    private ReportTabFragment reportTabFragment;
    private CheckinTabFragment checkinTabFragment;
    private static final int DIALOG_DISTANCE = 0;
    private static final int DIALOG_CLEAR_DEPLOYMENT = 1;
    private static final int DIALOG_ADD_DEPLOYMENT = 2;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dashboard_items);
        this.getSupportActionBar().setNavigationMode(1);
        Preferences.loadSettings((Context)this);
        this.mSpinnerAdapter = ArrayAdapter.createFromResource((Context)this, (int)R.array.nav_list, (int)0x1090009);
        this.getSupportActionBar().setListNavigationCallbacks(this.mSpinnerAdapter, this);
        this.getSupportActionBar().setDisplayShowTitleEnabled(false);
        this.maps = (ListMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.list_map_fragment);
        this.maps.setListMapListener(this);
        View f = this.findViewById(R.id.show_fragment);
        boolean bl = this.detailsInline = f != null && this.getResources().getConfiguration().orientation == 2 && f.getVisibility() == 0;
        if (this.detailsInline) {
            this.maps.enablePersistentSelection();
            FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
            if (Preferences.isCheckinEnabled == 1) {
                this.checkinTabFragment = new CheckinTabFragment();
                ft.add(R.id.show_fragment, this.checkinTabFragment);
            } else {
                this.reportTabFragment = new ReportTabFragment();
                ft.add(R.id.show_fragment, this.reportTabFragment);
            }
            ft.setTransition(4096);
            ft.commit();
        } else if (f != null) {
            f.setVisibility(8);
        }
    }

    @Override
    public void onMapSelected() {
        if (this.detailsInline) {
            FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
            if (Preferences.isCheckinEnabled == 1) {
                this.checkinTabFragment = new CheckinTabFragment();
                ft.replace(R.id.show_fragment, this.checkinTabFragment);
            } else {
                this.reportTabFragment = new ReportTabFragment();
                ft.replace(R.id.show_fragment, this.reportTabFragment);
            }
            ft.setTransition(4096);
            ft.commit();
        } else if (Preferences.isCheckinEnabled == 1) {
            Intent i = new Intent((Context)this, CheckinTabActivity.class);
            this.startActivity(i);
            this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        } else {
            Intent i = new Intent((Context)this, ReportTabActivity.class);
            this.startActivity(i);
            this.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.dashboard, (android.view.Menu)menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.app_about) {
            this.showDialog();
            return true;
        }
        if (item.getItemId() == R.id.app_settings) {
            this.startActivity(new Intent((Context)this, Settings.class));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void showDialog() {
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        Fragment prev = this.getSupportFragmentManager().findFragmentByTag("dialog");
        if (prev != null) {
            ft.remove(prev);
        }
        ft.setCustomAnimations(R.anim.slide_left_in, R.anim.slide_left_out, R.anim.slide_right_in, R.anim.slide_right_out);
        ft.addToBackStack(null);
        AboutFragment newFragment = AboutFragment.newInstance();
        newFragment.show(ft, "dialog");
    }

    protected void log(String message) {
        if (MainApplication.LOGGING_MODE) {
            Log.i((String)this.getClass().getName(), (String)message);
        }
    }

    protected void log(String format, Object ... args) {
        if (MainApplication.LOGGING_MODE) {
            Log.i((String)this.getClass().getName(), (String)String.format(format, args));
        }
    }

    protected void log(String message, Exception ex) {
        if (MainApplication.LOGGING_MODE) {
            Log.e((String)this.getClass().getName(), (String)message, (Throwable)ex);
        }
    }

    protected boolean isRouteDisplayed() {
        return false;
    }

    @Override
    public boolean onNavigationItemSelected(int itemPosition, long itemId) {
        if (itemPosition == 1) {
            this.maps.edit = false;
            this.maps.createDialog(2);
            return true;
        }
        if (itemPosition == 2) {
            this.maps.createDialog(0);
            return true;
        }
        if (itemPosition == 3) {
            this.maps.createDialog(1);
            return true;
        }
        return false;
    }
}

