/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.tablet;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.view.MenuItem;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.Settings;
import com.ushahidi.android.app.adapters.ListCheckinAdapter;
import com.ushahidi.android.app.adapters.ListFetchedCheckinAdapter;
import com.ushahidi.android.app.adapters.ListPendingCheckinAdapter;
import com.ushahidi.android.app.adapters.UserSpinnerAdater;
import com.ushahidi.android.app.entities.User;
import com.ushahidi.android.app.fragments.BaseSectionListFragment;
import com.ushahidi.android.app.models.ListCheckinModel;
import com.ushahidi.android.app.services.FetchCheckins;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.ui.phone.AboutActivity;
import com.ushahidi.android.app.ui.phone.AddCheckinActivity;
import com.ushahidi.android.app.ui.phone.ViewCheckinActivity;
import com.ushahidi.android.app.views.ListCheckinView;

public class ListCheckinFragment
extends BaseSectionListFragment<ListCheckinView, ListCheckinModel, ListCheckinAdapter> {
    private ListFetchedCheckinAdapter fetchedAdapter;
    private ListPendingCheckinAdapter pendingAdapter;
    private Handler mHandler;
    private MenuItem refresh;
    private UserSpinnerAdater spinnerArrayAdapter;
    private int filterUserId = 0;
    private CharSequence filterTitle = null;
    private boolean refreshState = false;
    public ProgressDialog dialog;
    private Intent fetchCheckins;
    private ViewGroup mRootView;
    private ImageButton addCheckin = null;
    private ImageButton refreshCheckin = null;
    private ImageButton filterCheckin = null;
    final Runnable fetchCheckinListByUser = new Runnable(){

        @Override
        public void run() {
            try {
                ListCheckinFragment.this.refreshCheckinByUserList();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable fetchCheckinList = new Runnable(){

        @Override
        public void run() {
            try {
                ListCheckinFragment.this.refreshCheckinList();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable filterCheckinList = new Runnable(){

        @Override
        public void run() {
            try {
                ListCheckinFragment.this.filterChecinList();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    private BroadcastReceiver fetchBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 4);
                ListCheckinFragment.this.getActivity().stopService(ListCheckinFragment.this.fetchCheckins);
                ListCheckinFragment.this.refreshState = false;
                ListCheckinFragment.this.updateRefreshStatus();
                if (status == 4) {
                    ListCheckinFragment.this.toastLong(R.string.internet_connection);
                } else if (status == 110) {
                    ListCheckinFragment.this.toastLong(R.string.connection_timeout);
                } else if (status == 100) {
                    ListCheckinFragment.this.toastLong(R.string.could_not_fetch_checkin);
                } else if (status == 0) {
                    ListCheckinFragment.this.log("successfully fetched checkins");
                    ListCheckinFragment.this.refreshCheckinList();
                    ListCheckinFragment.this.showUsers();
                }
            }
            try {
                ListCheckinFragment.this.getActivity().unregisterReceiver(ListCheckinFragment.this.fetchBroadcastReceiver);
            }
            catch (IllegalArgumentException e) {
                ListCheckinFragment.this.log("IllegalArgumentException", e);
            }
        }
    };

    public ListCheckinFragment() {
        super(ListCheckinView.class, ListCheckinAdapter.class, R.layout.list_checkin, R.menu.list_checkin, 16908298);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.setHasOptionsMenu(true);
        this.mHandler = new Handler();
        this.listView.setEmptyView(null);
        this.fetchedAdapter = new ListFetchedCheckinAdapter((Context)this.getActivity());
        this.pendingAdapter = new ListPendingCheckinAdapter((Context)this.getActivity());
    }

    private View pendingHeader() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        ViewGroup viewGroup = (ViewGroup)inflater.inflate(R.layout.list_pending_header, (ViewGroup)this.getListView(), false);
        return viewGroup;
    }

    private View fetchedHeader() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        ViewGroup viewGroup = (ViewGroup)inflater.inflate(R.layout.list_fetched_header, (ViewGroup)this.getListView(), false);
        return viewGroup;
    }

    @Override
    protected View headerView() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        ViewGroup viewGroup = (ViewGroup)inflater.inflate(R.layout.list_checkin_header, (ViewGroup)this.getListView(), false);
        TextView textView = (TextView)viewGroup.findViewById(R.id.filter_checkins);
        textView.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable arg0) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (!TextUtils.isEmpty((CharSequence)s.toString())) {
                    ListCheckinFragment.this.filterTitle = s;
                    ListCheckinFragment.this.mHandler.post(ListCheckinFragment.this.filterCheckinList);
                } else {
                    ListCheckinFragment.this.mHandler.post(ListCheckinFragment.this.fetchCheckinList);
                }
            }
        });
        return viewGroup;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = (ViewGroup)inflater.inflate(R.layout.list_checkin, null);
        this.addCheckin = (ImageButton)this.mRootView.findViewById(R.id.add_checkin_btn);
        this.refreshCheckin = (ImageButton)this.mRootView.findViewById(R.id.refresh_checkin_btn);
        this.filterCheckin = (ImageButton)this.mRootView.findViewById(R.id.filter_by_users);
        if (this.addCheckin != null) {
            this.addCheckin.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListCheckinFragment.this.launchAddCheckin(0);
                }
            });
        }
        if (this.refreshCheckin != null) {
            this.refreshCheckin.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListCheckinFragment.this.fetchCheckins();
                }
            });
        }
        if (this.filterCheckin != null) {
            this.filterCheckin.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListCheckinFragment.this.showDropDownNav();
                }
            });
        }
        return this.mRootView;
    }

    private void fetchCheckins() {
        this.getActivity().registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_CHECKIN_SERVICES_ACTION));
        this.refreshState = true;
        this.updateRefreshStatus();
        this.fetchCheckins = new Intent((Context)this.getActivity(), FetchCheckins.class);
        this.getActivity().startService(this.fetchCheckins);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.getActivity().registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_CHECKIN_SERVICES_ACTION));
        this.refreshCheckinList();
        if (this.filterUserId == 0) {
            this.refreshCheckinList();
            this.showUsers();
        } else {
            this.refreshCheckinByUserList();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            this.getActivity().unregisterReceiver(this.fetchBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_refresh_checkin) {
            this.refresh = item;
            this.fetchCheckins();
            return true;
        }
        if (item.getItemId() == R.id.menu_add_checkin) {
            this.launchAddCheckin(0);
            return true;
        }
        if (item.getItemId() == R.id.menu_filter_by_users) {
            this.showDropDownNav();
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.getActivity().finish();
            return true;
        }
        if (item.getItemId() == R.id.app_settings) {
            this.startActivity(new Intent((Context)this.getActivity(), Settings.class));
            return true;
        }
        if (item.getItemId() == R.id.app_about) {
            this.startActivity(new Intent((Context)this.getActivity(), AboutActivity.class));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void showUsers() {
        this.spinnerArrayAdapter = new UserSpinnerAdater((Context)this.getActivity());
        this.spinnerArrayAdapter.refresh();
    }

    private void refreshCheckinList() {
        this.fetchedAdapter.refresh();
        this.pendingAdapter.refresh();
        this.adapter = new ListCheckinAdapter((Context)this.getActivity());
        if (!this.pendingAdapter.isEmpty()) {
            ((ListCheckinAdapter)this.adapter).addView(this.pendingHeader());
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.pendingAdapter);
            ((ListCheckinAdapter)this.adapter).addView(this.fetchedHeader());
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedAdapter);
        } else {
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedAdapter);
        }
        this.listView.setAdapter((ListAdapter)this.adapter);
    }

    private void refreshCheckinByUserList() {
        this.fetchedAdapter.refresh(this.filterUserId);
        this.pendingAdapter.refresh(this.filterUserId);
        this.adapter = new ListCheckinAdapter((Context)this.getActivity());
        if (!this.pendingAdapter.isEmpty()) {
            ((ListCheckinAdapter)this.adapter).addView(this.pendingHeader());
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.pendingAdapter);
            ((ListCheckinAdapter)this.adapter).addView(this.fetchedHeader());
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedAdapter);
        } else {
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedAdapter);
        }
        this.listView.setAdapter((ListAdapter)this.adapter);
    }

    private void filterChecinList() {
        this.fetchedAdapter.getFilter().filter(this.filterTitle);
        this.pendingAdapter.getFilter().filter(this.filterTitle);
        this.adapter = new ListCheckinAdapter((Context)this.getActivity());
        if (!this.pendingAdapter.isEmpty()) {
            ((ListCheckinAdapter)this.adapter).addView(this.pendingHeader());
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.pendingAdapter);
            ((ListCheckinAdapter)this.adapter).addView(this.fetchedHeader());
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedAdapter);
        } else {
            ((ListCheckinAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedAdapter);
        }
        this.listView.setAdapter((ListAdapter)this.adapter);
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id2) {
        l.setItemChecked(position, true);
        if (this.fetchedAdapter == ((ListCheckinAdapter)this.adapter).getAdapter(position - 1)) {
            int itemAt = ((ListCheckinAdapter)this.adapter).getCount() - position;
            this.launchViewCheckin(this.fetchedAdapter.getCount() - itemAt - 1);
        } else if (this.pendingAdapter == ((ListCheckinAdapter)this.adapter).getAdapter(position - 1)) {
            int itemPosition = this.pendingAdapter.getCount() - position;
            int itemAt = this.pendingAdapter.getCount() - itemPosition - 1;
            this.launchAddCheckin(((ListCheckinModel)this.pendingAdapter.getItem(itemAt - 1)).getDbId());
        }
    }

    private void showDropDownNav() {
        this.showUsers();
        new AlertDialog.Builder((Context)this.getActivity()).setTitle((CharSequence)this.getActivity().getString(R.string.prompt_mesg)).setAdapter((ListAdapter)this.spinnerArrayAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ListCheckinFragment.this.filterUserId = ((User)ListCheckinFragment.this.spinnerArrayAdapter.getTag(which)).getUserId();
                String all = ((User)ListCheckinFragment.this.spinnerArrayAdapter.getTag(which)).getUsername();
                ((ListCheckinView)((ListCheckinFragment)ListCheckinFragment.this).view).footerText.setText((CharSequence)all);
                if (all != null && !TextUtils.isEmpty((CharSequence)all) && all != ListCheckinFragment.this.getActivity().getString(R.string.all_users)) {
                    ListCheckinFragment.this.mHandler.post(ListCheckinFragment.this.fetchCheckinListByUser);
                } else {
                    ListCheckinFragment.this.mHandler.post(ListCheckinFragment.this.fetchCheckinList);
                }
                dialog.dismiss();
            }
        }).create().show();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    private void updateRefreshStatus() {
        if (this.refresh != null) {
            if (this.refreshState) {
                this.refresh.setActionView(R.layout.indeterminate_progress_action);
            } else {
                this.refresh.setActionView(null);
            }
        }
    }

    @Override
    protected void onLoaded(boolean success) {
    }

    private void launchViewCheckin(int id2) {
        Intent i = new Intent((Context)this.getActivity(), ViewCheckinActivity.class);
        i.putExtra("id", id2);
        if (this.filterUserId > 0) {
            i.putExtra("userid", this.filterUserId);
        } else {
            i.putExtra("userid", 0);
        }
        this.startActivityForResult(i, 1);
        this.getActivity().overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
    }

    private void launchAddCheckin(int id2) {
        Intent i = new Intent((Context)this.getActivity(), AddCheckinActivity.class);
        i.putExtra("id", id2);
        this.startActivityForResult(i, 2);
        this.getActivity().overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
    }
}

