/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.tablet;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.view.MenuItem;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.Settings;
import com.ushahidi.android.app.adapters.ListMapAdapter;
import com.ushahidi.android.app.fragments.BaseListFragment;
import com.ushahidi.android.app.helpers.ActionModeHelper;
import com.ushahidi.android.app.models.ListMapModel;
import com.ushahidi.android.app.net.MapsHttpClient;
import com.ushahidi.android.app.services.FetchReports;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.tasks.ProgressTask;
import com.ushahidi.android.app.ui.phone.AboutActivity;
import com.ushahidi.android.app.ui.tablet.ListMapFragmentListener;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.AddMapView;
import com.ushahidi.android.app.views.ListMapView;
import java.util.Date;
import java.util.List;

public class ListMapFragment
extends BaseListFragment<ListMapView, ListMapModel, ListMapAdapter>
implements LocationListener {
    private final String[] items = new String[]{"50", "100", "250", "500", "750", "1000", "1500"};
    private static final int DIALOG_DISTANCE = 0;
    private static final int DIALOG_CLEAR_DEPLOYMENT = 1;
    private static final int DIALOG_ADD_DEPLOYMENT = 2;
    private static final int DIALOG_SHOW_MESSAGE = 3;
    private LocationManager mLocationMgr = null;
    private static Location location;
    private String distance = "";
    private Handler mHandler;
    private int mId = 0;
    private int mapId = 0;
    private int sId = 0;
    private ListMapModel mListMapModel;
    public boolean edit = true;
    private String filter;
    private ListMapFragmentListener listener = null;
    private String errorMessage = "";
    private static final String STATE_CHECKED = "com.ushahidi.android.app.activity.STATE_CHECKED";
    private Intent fetchReports;
    public ProgressDialog dialog;
    final Runnable mDeleteMapById = new Runnable(){

        @Override
        public void run() {
            boolean status = false;
            status = ListMapFragment.this.mListMapModel.deleteMapById(ListMapFragment.this.mId);
            try {
                if (status) {
                    ListMapFragment.this.toastShort(R.string.map_deleted);
                    ListMapFragment.this.refreshMapLists();
                } else {
                    ListMapFragment.this.toastShort(R.string.map_deleted_failed);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable fetchMapList = new Runnable(){

        @Override
        public void run() {
            try {
                ((ListMapAdapter)ListMapFragment.this.adapter).refresh();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable filterMapList = new Runnable(){

        @Override
        public void run() {
            try {
                ((ListMapAdapter)ListMapFragment.this.adapter).getFilter().filter((CharSequence)ListMapFragment.this.filter);
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable deleteAllMaps = new Runnable(){

        @Override
        public void run() {
            boolean status = false;
            status = ListMapFragment.this.mListMapModel.deleteAllMap((Context)ListMapFragment.this.getActivity());
            try {
                if (status) {
                    ListMapFragment.this.toastShort(R.string.map_deleted);
                    ListMapFragment.this.refreshMapLists();
                } else {
                    ListMapFragment.this.toastShort(R.string.map_deleted_failed);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable refreshMapList = new Runnable(){

        @Override
        public void run() {
            try {
                ListMapFragment.this.refreshMapLists();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 113);
                ListMapFragment.this.getActivity().stopService(ListMapFragment.this.fetchReports);
                ListMapFragment.this.dialog.cancel();
                if (status == 0) {
                    ListMapFragment.this.onLoaded(true);
                } else if (status == 100) {
                    ListMapFragment.this.errorMessage = ListMapFragment.this.getString(R.string.internet_connection);
                    ListMapFragment.this.createDialog(3);
                } else if (status == 99) {
                    ListMapFragment.this.errorMessage = ListMapFragment.this.getString(R.string.failed);
                    ListMapFragment.this.createDialog(3);
                } else if (status == 112) {
                    ListMapFragment.this.errorMessage = ListMapFragment.this.getString(R.string.network_error);
                    ListMapFragment.this.createDialog(3);
                } else {
                    ListMapFragment.this.errorMessage = ListMapFragment.this.getString(R.string.error_occured);
                    ListMapFragment.this.createDialog(3);
                }
            } else {
                ListMapFragment.this.toastLong(R.string.failed);
            }
        }
    };

    public ListMapFragment() {
        super(ListMapView.class, ListMapAdapter.class, R.layout.list_map, 0, 16908298);
        this.mHandler = new Handler();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        int position;
        super.onActivityCreated(savedInstanceState);
        this.setHasOptionsMenu(true);
        this.mListMapModel = new ListMapModel();
        this.dialog = new ProgressDialog((Context)this.getActivity());
        this.dialog.setCancelable(true);
        this.dialog.setIndeterminate(true);
        this.dialog.setMessage((CharSequence)this.getString(R.string.please_wait));
        if (Util.isHoneycomb()) {
            this.listView.setLongClickable(true);
            this.listView.setChoiceMode(1);
            this.listView.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)new ActionModeHelper(this, this.listView));
        } else {
            this.registerForContextMenu((View)this.listView);
        }
        this.log("Adapter count " + ((ListMapAdapter)this.adapter).getCount());
        this.mHandler.post(this.fetchMapList);
        if (savedInstanceState != null && (position = savedInstanceState.getInt(STATE_CHECKED, -1)) > -1) {
            this.listView.setItemChecked(position, true);
        }
    }

    private void fetchReports(int id2) {
        if (id2 != 0) {
            this.mListMapModel.activateDeployment((Context)this.getActivity(), id2);
            this.dialog.show();
            this.fetchReports = new Intent((Context)this.getActivity(), FetchReports.class);
            this.getActivity().startService(this.fetchReports);
        }
    }

    @Override
    public void onSaveInstanceState(Bundle state) {
        super.onSaveInstanceState(state);
        state.putInt(STATE_CHECKED, this.listView.getCheckedItemPosition());
    }

    @Override
    public void onResume() {
        super.onResume();
        this.getActivity().registerReceiver(this.broadcastReceiver, new IntentFilter(SyncServices.SYNC_SERVICES_ACTION));
        this.mHandler.post(this.fetchMapList);
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.stopLocating();
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            this.getActivity().unregisterReceiver(this.broadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setListMapListener(ListMapFragmentListener listener) {
        this.listener = listener;
    }

    public void enablePersistentSelection() {
        this.getListView().setChoiceMode(1);
    }

    public void refreshMapLists() {
        ((ListMapAdapter)this.adapter).refresh();
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        new MenuInflater((Context)this.getActivity()).inflate(R.menu.list_map_context, (Menu)menu2);
    }

    @Override
    public boolean onContextItemSelected(MenuItem item) {
        AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        boolean result = this.performAction(item, info.position);
        if (!result) {
            result = super.onContextItemSelected(item);
        }
        return result;
    }

    public boolean performAction(android.view.MenuItem item, int position) {
        this.mId = ((ListMapModel)((ListMapAdapter)this.adapter).getItem(position)).getId();
        this.mapId = ((ListMapModel)((ListMapAdapter)this.adapter).getItem(position)).getMapId();
        if (item.getItemId() == R.id.map_delete) {
            this.edit = false;
            this.mHandler.post(this.mDeleteMapById);
            return true;
        }
        if (item.getItemId() == R.id.map_edit) {
            this.edit = true;
            this.createDialog(2);
            return true;
        }
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear_map) {
            this.createDialog(1);
            return true;
        }
        if (item.getItemId() == R.id.menu_find) {
            this.createDialog(0);
            return true;
        }
        if (item.getItemId() == R.id.menu_add) {
            this.edit = false;
            this.createDialog(2);
            return true;
        }
        if (item.getItemId() == R.id.app_settings) {
            this.startActivity(new Intent((Context)this.getActivity(), Settings.class));
            return true;
        }
        if (item.getItemId() == R.id.app_about) {
            this.startActivity(new Intent((Context)this.getActivity(), AboutActivity.class));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        this.log("on map itemClicked");
        int sId = ((ListMapModel)((ListMapAdapter)this.adapter).getItem(position)).getId();
        if (this.isMapActive(sId)) {
            if (this.listener != null) {
                this.listener.onMapSelected();
            }
        } else {
            this.fetchReports(sId);
        }
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id2) {
        l.setItemChecked(position, true);
        this.sId = ((ListMapModel)((ListMapAdapter)this.adapter).getItem(position)).getId();
        if (this.isMapActive(this.sId)) {
            if (this.listener != null) {
                this.listener.onMapSelected();
            }
        } else {
            this.fetchReports(this.sId);
        }
    }

    public boolean isMapActive(int id2) {
        Preferences.loadSettings((Context)this.getActivity());
        return Preferences.activeDeployment == id2;
    }

    public void createDialog(int d) {
        switch (d) {
            case 3: {
                AlertDialog.Builder messageBuilder = new AlertDialog.Builder((Context)this.getActivity());
                messageBuilder.setMessage((CharSequence)this.errorMessage).setPositiveButton((CharSequence)this.getString(R.string.ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog showDialog = messageBuilder.create();
                showDialog.show();
                break;
            }
            case 0: {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                builder.setTitle(R.string.select_distance);
                builder.setSingleChoiceItems((CharSequence[])this.items, Preferences.selectedDistance, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int item) {
                        ListMapFragment.this.distance = ListMapFragment.this.items[item];
                        ListMapFragment.this.setDeviceLocation();
                        Preferences.selectedDistance = item;
                        Preferences.saveSettings((Context)ListMapFragment.this.getActivity());
                        dialog.cancel();
                        ListMapFragment.this.toastLong(R.string.finding_map);
                    }
                });
                AlertDialog alert = builder.create();
                alert.show();
                break;
            }
            case 1: {
                AlertDialog.Builder clearBuilder = new AlertDialog.Builder((Context)this.getActivity());
                clearBuilder.setMessage((CharSequence)this.getString(R.string.confirm_clear)).setCancelable(false).setPositiveButton((CharSequence)this.getString(R.string.yes), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        ListMapFragment.this.mHandler.post(ListMapFragment.this.deleteAllMaps);
                    }
                }).setNegativeButton((CharSequence)this.getString(R.string.no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog clearDialog = clearBuilder.create();
                clearDialog.show();
                break;
            }
            case 2: {
                List<ListMapModel> listMap;
                LayoutInflater factory = LayoutInflater.from((Context)this.getActivity());
                View textEntryView = factory.inflate(R.layout.add_map, null);
                final AddMapView addMapView = new AddMapView(textEntryView);
                if (this.edit && (listMap = this.mListMapModel.loadMapById(this.mId, this.mapId)).size() > 0) {
                    addMapView.setMapName(listMap.get(0).getName());
                    addMapView.setMapDescription(listMap.get(0).getDesc());
                    addMapView.setMapUrl(listMap.get(0).getUrl());
                    addMapView.setMapId(listMap.get(0).getId());
                }
                AlertDialog.Builder addBuilder = new AlertDialog.Builder((Context)this.getActivity());
                addBuilder.setTitle(R.string.enter_map_details).setView(textEntryView).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (ListMapFragment.this.edit) {
                            if (!addMapView.updateMapDetails()) {
                                ListMapFragment.this.toastLong(R.string.fix_error);
                            } else {
                                ListMapFragment.this.mHandler.post(ListMapFragment.this.refreshMapList);
                            }
                        } else if (!addMapView.addMapDetails()) {
                            ListMapFragment.this.toastLong(R.string.fix_error);
                        } else {
                            ListMapFragment.this.mHandler.post(ListMapFragment.this.fetchMapList);
                        }
                    }
                }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        dialog.cancel();
                    }
                });
                AlertDialog deploymentDialog = addBuilder.create();
                deploymentDialog.show();
            }
        }
    }

    @Override
    protected void onLoaded(boolean success) {
        try {
            if (success) {
                if (Preferences.isCheckinEnabled == 1) {
                    this.toastLong(R.string.checkin_is_enabled);
                }
                if (this.listener != null) {
                    this.listener.onMapSelected();
                }
            } else {
                this.toastLong(R.string.failed);
            }
        }
        catch (IllegalArgumentException e) {
            this.log(e.toString());
        }
    }

    protected void setDeviceLocation() {
        boolean gpsAvail;
        this.mLocationMgr = (LocationManager)this.getActivity().getSystemService("location");
        Location loc = null;
        boolean netAvail = this.mLocationMgr.getProvider("network") != null;
        boolean bl = gpsAvail = this.mLocationMgr.getProvider("gps") != null;
        if (gpsAvail) {
            loc = this.mLocationMgr.getLastKnownLocation("gps");
        } else if (netAvail) {
            loc = this.mLocationMgr.getLastKnownLocation("network");
        }
        if (loc != null && new Date().getTime() - loc.getTime() < 600000L) {
            this.onLocationChanged(loc);
        } else {
            if (gpsAvail) {
                this.mLocationMgr.requestLocationUpdates("gps", 0L, 0.0f, (LocationListener)this);
            }
            if (netAvail) {
                this.mLocationMgr.requestLocationUpdates("network", 0L, 0.0f, (LocationListener)this);
            }
        }
    }

    public void stopLocating() {
        if (this.mLocationMgr != null) {
            try {
                this.mLocationMgr.removeUpdates((LocationListener)this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.mLocationMgr = null;
        }
    }

    public void onLocationChanged(Location loc) {
        if (loc != null) {
            location = loc;
            LoadMapTask deploymentTask = new LoadMapTask(this.getActivity());
            deploymentTask.location = location;
            deploymentTask.distance = this.distance;
            deploymentTask.execute(new String[0]);
            this.stopLocating();
        }
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    protected View headerView() {
        return null;
    }

    class LoadMapTask
    extends ProgressTask {
        protected Boolean status;
        private MapsHttpClient maps;
        protected String distance;
        protected Location location;

        public LoadMapTask(Activity activity) {
            super(activity, R.string.loading_);
            this.maps = new MapsHttpClient((Context)activity);
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            this.dialog.cancel();
        }

        protected Boolean doInBackground(String ... strings) {
            try {
                this.status = this.maps.fetchMaps(this.distance, this.location);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.status;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            if (!result.booleanValue()) {
                ListMapFragment.this.toastShort(R.string.could_not_fetch_data);
            } else {
                ListMapFragment.this.toastShort(R.string.maps_fetched_successful);
            }
            ((ListMapAdapter)ListMapFragment.this.adapter).refresh();
        }
    }
}

