/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.tablet;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.view.MenuItem;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.Settings;
import com.ushahidi.android.app.adapters.CategorySpinnerAdater;
import com.ushahidi.android.app.adapters.ListFetchedReportAdapter;
import com.ushahidi.android.app.adapters.ListPendingReportAdapter;
import com.ushahidi.android.app.adapters.ListReportAdapter;
import com.ushahidi.android.app.adapters.UploadPhotoAdapter;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.database.OpenGeoSmsDao;
import com.ushahidi.android.app.entities.Category;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.fragments.BaseSectionListFragment;
import com.ushahidi.android.app.models.AddReportModel;
import com.ushahidi.android.app.models.ListPhotoModel;
import com.ushahidi.android.app.models.ListReportModel;
import com.ushahidi.android.app.net.CategoriesHttpClient;
import com.ushahidi.android.app.net.ReportsHttpClient;
import com.ushahidi.android.app.opengeosms.OpenGeoSMSSender;
import com.ushahidi.android.app.tasks.ProgressTask;
import com.ushahidi.android.app.ui.phone.AboutActivity;
import com.ushahidi.android.app.ui.phone.AddReportActivity;
import com.ushahidi.android.app.ui.phone.ViewReportActivity;
import com.ushahidi.android.app.ui.tablet.ListMapFragmentListener;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.Util;
import com.ushahidi.android.app.views.ListReportView;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ListReportFragment
extends BaseSectionListFragment<ListReportView, ListReportModel, ListReportAdapter> {
    private int mPositionChecked = 0;
    private int mPositionShown = 1;
    private Handler mHandler;
    private MenuItem refresh;
    private CategorySpinnerAdater spinnerArrayAdapter;
    private int filterCategory = 0;
    private CharSequence filterTitle = null;
    private ViewGroup mRootView;
    private ImageButton addReport = null;
    private ImageButton refreshReport = null;
    private ImageButton filterReport = null;
    private boolean refreshState = false;
    private ApiUtils apiUtils;
    private ListFetchedReportAdapter fetchedReportAdapter;
    private ListPendingReportAdapter pendingReportAdapter;
    final Runnable fetchReportList = new Runnable(){

        @Override
        public void run() {
            try {
                ListReportFragment.this.refreshReportLists();
                ListReportFragment.this.showCategories();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable fetchReportListByCategory = new Runnable(){

        @Override
        public void run() {
            try {
                ListReportFragment.this.reportByCategoryList();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable filterReportList = new Runnable(){

        @Override
        public void run() {
            try {
                ListReportFragment.this.filterReportList();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    private List<ListReportModel> mPendingReports;

    public ListReportFragment() {
        super(ListReportView.class, ListReportAdapter.class, R.layout.list_report, R.menu.list_report, 16908298);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.setHasOptionsMenu(true);
        this.mHandler = new Handler();
        this.apiUtils = new ApiUtils((Context)this.getActivity());
        this.listView.setEmptyView(null);
        this.fetchedReportAdapter = new ListFetchedReportAdapter((Context)this.getActivity());
        this.pendingReportAdapter = new ListPendingReportAdapter((Context)this.getActivity());
        if (savedInstanceState != null) {
            this.mPositionChecked = savedInstanceState.getInt("curChoice", 0);
            this.mPositionShown = savedInstanceState.getInt("shownChoice", -1);
        }
    }

    private View pendingHeader() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        ViewGroup viewGroup = (ViewGroup)inflater.inflate(R.layout.list_pending_header, (ViewGroup)this.getListView(), false);
        return viewGroup;
    }

    private View fetchedHeader() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        ViewGroup viewGroup = (ViewGroup)inflater.inflate(R.layout.list_fetched_header, (ViewGroup)this.getListView(), false);
        return viewGroup;
    }

    @Override
    protected View headerView() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        ViewGroup viewGroup = (ViewGroup)inflater.inflate(R.layout.list_report_header, (ViewGroup)this.getListView(), false);
        TextView textView = (TextView)viewGroup.findViewById(R.id.filter_report);
        textView.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable arg0) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (!TextUtils.isEmpty((CharSequence)s.toString())) {
                    ListReportFragment.this.filterTitle = s;
                    ListReportFragment.this.mHandler.post(ListReportFragment.this.filterReportList);
                }
            }
        });
        return viewGroup;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("curChoice", this.mPositionChecked);
        outState.putInt("shownChoice", this.mPositionShown);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.filterCategory == 0) {
            this.refreshReportLists();
            this.showCategories();
        } else {
            this.reportByCategoryList();
        }
        this.executeUploadTask();
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (new RefreshReports(this.getActivity()).cancel(true)) {
            this.refreshState = false;
            this.updateRefreshStatus();
        }
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id2) {
        l.setItemChecked(position, true);
        if (this.fetchedReportAdapter == ((ListReportAdapter)this.adapter).getAdapter(position - 1)) {
            int itemAt = ((ListReportAdapter)this.adapter).getCount() - position;
            this.launchViewReport(this.fetchedReportAdapter.getCount() - itemAt - 1);
        } else if (this.pendingReportAdapter == ((ListReportAdapter)this.adapter).getAdapter(position - 1)) {
            int itemPosition = this.pendingReportAdapter.getCount() - position;
            int itemAt = this.pendingReportAdapter.getCount() - itemPosition - 1;
            this.launchAddReport((int)((ListReportModel)this.pendingReportAdapter.getItem(itemAt - 1)).getId());
        }
    }

    public void setListMapListener(ListMapFragmentListener listener) {
    }

    public void enablePersistentSelection() {
        this.getListView().setChoiceMode(1);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_refresh) {
            this.refresh = item;
            new RefreshReports(this.getActivity()).execute(new String[]{null});
            return true;
        }
        if (item.getItemId() == R.id.menu_add) {
            this.launchAddReport(0);
            return true;
        }
        if (item.getItemId() == R.id.filter_by) {
            this.showDropDownNav();
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.getActivity().finish();
            return true;
        }
        if (item.getItemId() == R.id.app_settings) {
            this.startActivity(new Intent((Context)this.getActivity(), Settings.class));
            return true;
        }
        if (item.getItemId() == R.id.app_about) {
            this.startActivity(new Intent((Context)this.getActivity(), AboutActivity.class));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void refreshReportLists() {
        this.pendingReportAdapter.refresh();
        this.fetchedReportAdapter.refresh();
        this.adapter = new ListReportAdapter((Context)this.getActivity());
        if (!this.pendingReportAdapter.isEmpty()) {
            ((ListReportAdapter)this.adapter).addView(this.pendingHeader());
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.pendingReportAdapter);
            ((ListReportAdapter)this.adapter).addView(this.fetchedHeader());
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedReportAdapter);
        } else {
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedReportAdapter);
        }
        this.listView.setAdapter((ListAdapter)this.adapter);
    }

    private void filterReportList() {
        this.fetchedReportAdapter.getFilter().filter(this.filterTitle);
        this.pendingReportAdapter.getFilter().filter(this.filterTitle);
        this.adapter = new ListReportAdapter((Context)this.getActivity());
        if (!this.pendingReportAdapter.isEmpty()) {
            ((ListReportAdapter)this.adapter).addView(this.pendingHeader());
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.pendingReportAdapter);
            ((ListReportAdapter)this.adapter).addView(this.fetchedHeader());
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedReportAdapter);
        } else {
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedReportAdapter);
        }
        this.listView.setAdapter((ListAdapter)this.adapter);
    }

    private void executeUploadTask() {
        if (!this.pendingReportAdapter.isEmpty()) {
            new UploadTask(this.getActivity()).execute(new String[]{null});
        }
    }

    private void reportByCategoryList() {
        this.fetchedReportAdapter.refresh(this.filterCategory);
        this.pendingReportAdapter.refresh(this.filterCategory);
        this.adapter = new ListReportAdapter((Context)this.getActivity());
        if (!this.pendingReportAdapter.isEmpty()) {
            ((ListReportAdapter)this.adapter).addView(this.pendingHeader());
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.pendingReportAdapter);
            ((ListReportAdapter)this.adapter).addView(this.fetchedHeader());
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedReportAdapter);
        } else {
            ((ListReportAdapter)this.adapter).addAdapter((ListAdapter)this.fetchedReportAdapter);
        }
        this.listView.setAdapter((ListAdapter)this.adapter);
    }

    public void showDropDownNav() {
        this.showCategories();
        new AlertDialog.Builder((Context)this.getActivity()).setTitle((CharSequence)this.getActivity().getString(R.string.prompt_mesg)).setAdapter((ListAdapter)this.spinnerArrayAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ListReportFragment.this.filterCategory = ((Category)ListReportFragment.this.spinnerArrayAdapter.getTag(which)).getCategoryId();
                String all = ((Category)ListReportFragment.this.spinnerArrayAdapter.getTag(which)).getCategoryTitle();
                ((ListReportView)((ListReportFragment)ListReportFragment.this).view).footerText.setText((CharSequence)all);
                if (all != null && !TextUtils.isEmpty((CharSequence)all) && all != ListReportFragment.this.getActivity().getString(R.string.all_categories)) {
                    ListReportFragment.this.mHandler.post(ListReportFragment.this.fetchReportListByCategory);
                } else {
                    ListReportFragment.this.mHandler.post(ListReportFragment.this.fetchReportList);
                }
                dialog.dismiss();
            }
        }).create().show();
    }

    public void showCategories() {
        this.spinnerArrayAdapter = new CategorySpinnerAdater((Context)this.getActivity());
        this.spinnerArrayAdapter.refresh();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = (ViewGroup)inflater.inflate(R.layout.list_report, null);
        this.addReport = (ImageButton)this.mRootView.findViewById(R.id.add_report_btn);
        this.refreshReport = (ImageButton)this.mRootView.findViewById(R.id.refresh_report_btn);
        this.filterReport = (ImageButton)this.mRootView.findViewById(R.id.filter_by_category);
        if (this.addReport != null) {
            this.addReport.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListReportFragment.this.launchAddReport(0);
                }
            });
        }
        if (this.refreshReport != null) {
            this.refreshReport.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new RefreshReports(ListReportFragment.this.getActivity()).execute(new String[]{null});
                }
            });
        }
        if (this.filterReport != null) {
            this.filterReport.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListReportFragment.this.showDropDownNav();
                }
            });
        }
        return this.mRootView;
    }

    private void updateRefreshStatus() {
        if (this.mRootView != null && this.addReport != null) {
            this.mRootView.findViewById(R.id.refresh_report_btn).setVisibility(this.refreshState ? 8 : 0);
            this.mRootView.findViewById(R.id.title_refresh_progress).setVisibility(this.refreshState ? 0 : 8);
        }
        if (this.refresh != null) {
            if (this.refreshState) {
                this.refresh.setActionView(R.layout.indeterminate_progress_action);
            } else {
                this.refresh.setActionView(null);
            }
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
    }

    private boolean sendOpenGeoSms(ListReportModel r) {
        return new OpenGeoSMSSender((Context)this.getActivity()).sendReport(Preferences.phonenumber, Preferences.openGeoSmsUrl, r);
    }

    private boolean sendOpenGeoSmsReport(ListReportModel r, int state) {
        long id2 = r.getId();
        OpenGeoSmsDao dao = Database.mOpenGeoSmsDao;
        switch (state) {
            case 0: {
                if (this.sendOpenGeoSms(r)) {
                    String photos = new UploadPhotoAdapter((Context)this.getActivity()).pendingPhotos((int)id2);
                    if (photos != null && !"".equals(photos)) {
                        dao.setReportState(id2, 1);
                    } else {
                        this.deletePendingReport((int)id2);
                        dao.deleteReport(id2);
                    }
                    return true;
                }
                return false;
            }
            case 1: {
                String photos = new UploadPhotoAdapter((Context)this.getActivity()).pendingPhotos((int)id2);
                if (photos != null && !"".equals(photos)) {
                    String url = Preferences.domain + "opengeosms/attach";
                    String m = OpenGeoSMSSender.createReport(Preferences.openGeoSmsUrl, r);
                    String filename = new UploadPhotoAdapter((Context)this.getActivity()).pendingPhotos((int)id2);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("m", m);
                    params.put("filename", filename);
                    ReportsHttpClient c = new ReportsHttpClient((Context)this.getActivity());
                    try {
                        if (!c.PostFileUpload(url, params)) {
                            return false;
                        }
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                this.deletePendingReport((int)id2);
                dao.deleteReport(id2);
                return true;
            }
        }
        return false;
    }

    private void preparePendingReports() {
        this.mPendingReports = this.pendingReportAdapter.pendingReports();
        if (this.mPendingReports != null) {
            for (ListReportModel report : this.mPendingReports) {
                long rid = report.getId();
                String categories = this.pendingReportAdapter.fetchCategoriesId((int)rid);
                report.setCategories(categories);
            }
        }
    }

    private boolean uploadPendingReports() {
        boolean retVal = true;
        StringBuilder urlBuilder = new StringBuilder(Preferences.domain);
        urlBuilder.append("/api");
        if (this.mPendingReports != null) {
            for (ListReportModel report : this.mPendingReports) {
                long rid = report.getId();
                int state = Database.mOpenGeoSmsDao.getReportState(rid);
                if (state != -1) {
                    if (this.sendOpenGeoSmsReport(report, state)) continue;
                    retVal = false;
                    continue;
                }
                HashMap<String, String> mParams = new HashMap<String, String>();
                mParams.put("task", "report");
                mParams.put("incident_title", report.getTitle());
                mParams.put("incident_description", report.getDesc());
                String[] dates = Util.formatDate("MMMM dd, yyyy 'at' hh:mm:ss aaa", report.getDate(), "MM/dd/yyyy hh:mm a", null, Locale.US).split(" ");
                String[] time = dates[1].split(":");
                mParams.put("incident_date", dates[0]);
                mParams.put("incident_hour", time[0]);
                mParams.put("incident_minute", time[1]);
                mParams.put("incident_ampm", dates[2].toLowerCase());
                mParams.put("incident_category", report.getCategories());
                mParams.put("latitude", report.getLatitude());
                mParams.put("longitude", report.getLongitude());
                mParams.put("location_name", report.getLocation());
                mParams.put("person_first", Preferences.firstname);
                mParams.put("person_last", Preferences.lastname);
                mParams.put("person_email", Preferences.email);
                mParams.put("filename", new UploadPhotoAdapter((Context)this.getActivity()).pendingPhotos((int)report.getId()));
                try {
                    if (new ReportsHttpClient((Context)this.getActivity()).PostFileUpload(urlBuilder.toString(), mParams)) continue;
                    this.deletePendingReport((int)report.getId());
                    retVal = false;
                }
                catch (IOException e) {
                    retVal = false;
                }
            }
        }
        return retVal;
    }

    private void deletePendingReport(int reportId) {
        AddReportModel model = new AddReportModel();
        UploadPhotoAdapter pendingPhoto = new UploadPhotoAdapter((Context)this.getActivity());
        if (reportId > 0 && model.deleteReport(reportId)) {
            for (int i = 0; i < pendingPhoto.getCount(); ++i) {
                ImageManager.deletePendingPhoto((Context)this.getActivity(), "/" + ((Photo)pendingPhoto.getItem(i)).getPhoto());
            }
        }
    }

    private void deleteFetchedReport() {
        List<ListReportModel> items = this.fetchedReportAdapter.fetchedReports();
        for (ListReportModel report : items) {
            if (!new ListReportModel().deleteAllFetchedReport(report.getReportId())) continue;
            List<Photo> photos = new ListPhotoModel().getPhotosByReportId(report.getReportId());
            for (Photo photo : photos) {
                ImageManager.deletePendingPhoto((Context)this.getActivity(), "/" + photo.getPhoto());
            }
        }
    }

    @Override
    protected void onLoaded(boolean success) {
    }

    private void launchViewReport(int id2) {
        Intent i = new Intent((Context)this.getActivity(), ViewReportActivity.class);
        i.putExtra("id", id2);
        if (this.filterCategory > 0) {
            i.putExtra("category", this.filterCategory);
        } else {
            i.putExtra("category", 0);
        }
        this.startActivityForResult(i, 1);
        this.getActivity().overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
    }

    private void launchAddReport(int id2) {
        Intent i = new Intent((Context)this.getActivity(), AddReportActivity.class);
        i.putExtra("id", id2);
        this.startActivityForResult(i, 2);
        this.getActivity().overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
    }

    class RefreshReports
    extends ProgressTask {
        protected Integer status;

        public RefreshReports(Activity activity) {
            super(activity, R.string.loading_);
            this.status = 4;
            ListReportFragment.this.refreshState = true;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            this.dialog.cancel();
            ListReportFragment.this.refreshState = true;
            ListReportFragment.this.updateRefreshStatus();
        }

        protected Boolean doInBackground(String ... strings) {
            try {
                if (ListReportFragment.this.apiUtils.isConnected()) {
                    if (!ListReportFragment.this.pendingReportAdapter.isEmpty()) {
                        ListReportFragment.this.uploadPendingReports();
                    }
                    ListReportFragment.this.deleteFetchedReport();
                    new CategoriesHttpClient((Context)ListReportFragment.this.getActivity()).getCategoriesFromWeb();
                    this.status = new ReportsHttpClient((Context)ListReportFragment.this.getActivity()).getAllReportFromWeb();
                    return true;
                }
                Thread.sleep(1000L);
                return false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        protected void onPostExecute(Boolean result) {
            if (result.booleanValue()) {
                if (this.status == 4) {
                    ListReportFragment.this.toastLong(R.string.internet_connection);
                } else if (this.status == 110) {
                    ListReportFragment.this.toastLong(R.string.connection_timeout);
                } else if (this.status == 100) {
                    ListReportFragment.this.toastLong(R.string.could_not_fetch_reports);
                } else if (this.status == 0) {
                    ListReportFragment.this.refreshReportLists();
                    ListReportFragment.this.showCategories();
                }
                ListReportFragment.this.refreshState = false;
                ListReportFragment.this.updateRefreshStatus();
            }
        }
    }

    protected class UploadTask
    extends ProgressTask {
        public UploadTask(Activity activity) {
            super(activity, R.string.uploading);
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            ListReportFragment.this.preparePendingReports();
        }

        protected Boolean doInBackground(String ... args) {
            return ListReportFragment.this.uploadPendingReports();
        }

        @Override
        protected void onPostExecute(Boolean success) {
            super.onPostExecute(success);
            if (success.booleanValue()) {
                ListReportFragment.this.toastLong(R.string.uploaded);
            } else {
                ListReportFragment.this.toastLong(R.string.failed);
            }
            ListReportFragment.this.refreshReportLists();
            ListReportFragment.this.showCategories();
        }
    }
}

