/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.tablet;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.view.MenuItem;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.ushahidi.android.app.CheckinMapItemizedOverlay;
import com.ushahidi.android.app.CheckinMapOverlayItem;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.UserSpinnerAdater;
import com.ushahidi.android.app.entities.User;
import com.ushahidi.android.app.fragments.BaseFragment;
import com.ushahidi.android.app.models.ListCheckinModel;
import com.ushahidi.android.app.services.FetchCheckins;
import com.ushahidi.android.app.services.SyncServices;
import com.ushahidi.android.app.ui.phone.AddCheckinActivity;
import com.ushahidi.android.app.util.Util;
import java.util.List;

public class MapCheckinFragment<CheckinMapItemOverlay>
extends BaseFragment {
    private MapView map = null;
    private ListCheckinModel mListCheckinModel;
    List<ListCheckinModel> mCheckinModel;
    private CheckinMapItemizedOverlay<CheckinMapOverlayItem> itemOverlay;
    private Handler mHandler;
    private int filterUserId = 0;
    private MenuItem refresh;
    private UserSpinnerAdater spinnerArrayAdapter;
    private ViewGroup mRootView;
    private ImageButton addCheckin = null;
    private ImageButton refreshCheckin = null;
    private ImageButton filterCheckin = null;
    private boolean refreshState = false;
    private Intent fetchCheckins;
    final Runnable fetchReportListByCategory = new Runnable(){

        @Override
        public void run() {
            try {
                boolean loaded = MapCheckinFragment.this.mListCheckinModel.loadCheckinByUser(MapCheckinFragment.this.filterUserId);
                if (loaded) {
                    MapCheckinFragment.this.mCheckinModel = MapCheckinFragment.this.mListCheckinModel.getCheckins((Context)MapCheckinFragment.this.getActivity());
                    MapCheckinFragment.this.populateMap();
                }
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable fetchReportList = new Runnable(){

        @Override
        public void run() {
            try {
                MapCheckinFragment.this.mListCheckinModel.load();
                MapCheckinFragment.this.mCheckinModel = MapCheckinFragment.this.mListCheckinModel.getCheckins((Context)MapCheckinFragment.this.getActivity());
                MapCheckinFragment.this.populateMap();
                MapCheckinFragment.this.showUsers();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable mMarkersOnMap = new Runnable(){

        @Override
        public void run() {
            MapCheckinFragment.this.populateMap();
        }
    };
    private BroadcastReceiver fetchBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                int status = intent.getIntExtra("status", 4);
                MapCheckinFragment.this.refreshState = false;
                MapCheckinFragment.this.updateRefreshStatus();
                if (status == 4) {
                    MapCheckinFragment.this.toastLong(R.string.internet_connection);
                } else if (status == 110) {
                    MapCheckinFragment.this.toastLong(R.string.connection_timeout);
                } else if (status == 100) {
                    MapCheckinFragment.this.toastLong(R.string.could_not_fetch_checkin);
                } else if (status == 0) {
                    MapCheckinFragment.this.log("successfully fetched checkins");
                    MapCheckinFragment.this.log("successfully fetched");
                    MapCheckinFragment.this.mCheckinModel = MapCheckinFragment.this.mListCheckinModel.getCheckins((Context)MapCheckinFragment.this.getActivity());
                    MapCheckinFragment.this.populateMap();
                    MapCheckinFragment.this.showUsers();
                }
            }
            try {
                MapCheckinFragment.this.getActivity().unregisterReceiver(MapCheckinFragment.this.fetchBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };

    public MapCheckinFragment() {
        super(R.menu.map_report);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mListCheckinModel = new ListCheckinModel();
        this.mListCheckinModel.load();
        this.mCheckinModel = this.mListCheckinModel.getCheckins((Context)this.getActivity());
        this.showUsers();
        this.mHandler = new Handler();
        this.map = new MapView((Context)this.getActivity(), this.getActivity().getString(R.string.google_map_api_key));
        Preferences.loadSettings((Context)this.getActivity());
        if (this.mCheckinModel.size() > 0) {
            this.map.setClickable(true);
            this.map.setBuiltInZoomControls(true);
            this.mHandler.post(this.mMarkersOnMap);
        } else {
            this.toastLong(R.string.no_checkin);
        }
        ((ViewGroup)this.getView()).addView((View)this.map);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_refresh) {
            this.refresh = item;
            this.fetchCheckins();
            return true;
        }
        if (item.getItemId() == R.id.menu_add) {
            this.launchAddCheckin(0);
            return true;
        }
        if (item.getItemId() == R.id.menu_normal) {
            this.map.setSatellite(false);
            this.map.setTraffic(false);
            return true;
        }
        if (item.getItemId() == R.id.menu_satellite) {
            this.map.setSatellite(true);
            return true;
        }
        if (item.getItemId() == R.id.filter_by) {
            this.showDropDownNav();
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.getActivity().finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected View headerView() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        ViewGroup viewGroup = (ViewGroup)inflater.inflate(R.layout.map_view_header, null, false);
        TextView textView = (TextView)viewGroup.findViewById(R.id.map_header);
        textView.setText(R.string.all_users);
        return viewGroup;
    }

    private void showDropDownNav() {
        this.showUsers();
        new AlertDialog.Builder((Context)this.getActivity()).setTitle((CharSequence)this.getActivity().getString(R.string.prompt_mesg)).setAdapter((ListAdapter)this.spinnerArrayAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MapCheckinFragment.this.filterUserId = ((User)MapCheckinFragment.this.spinnerArrayAdapter.getTag(which)).getUserId();
                String all = ((User)MapCheckinFragment.this.spinnerArrayAdapter.getTag(which)).getUsername();
                if (all != null && !TextUtils.isEmpty((CharSequence)all) && all != MapCheckinFragment.this.getActivity().getString(R.string.all_users)) {
                    MapCheckinFragment.this.mHandler.post(MapCheckinFragment.this.fetchReportListByCategory);
                } else {
                    MapCheckinFragment.this.mHandler.post(MapCheckinFragment.this.fetchReportList);
                }
                dialog.dismiss();
            }
        }).create().show();
    }

    public void showUsers() {
        this.spinnerArrayAdapter = new UserSpinnerAdater((Context)this.getActivity());
        this.spinnerArrayAdapter.refresh();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = (ViewGroup)inflater.inflate(R.layout.list_checkin, null);
        this.addCheckin = (ImageButton)this.mRootView.findViewById(R.id.add_checkin_btn);
        this.refreshCheckin = (ImageButton)this.mRootView.findViewById(R.id.refresh_checkin_btn);
        this.filterCheckin = (ImageButton)this.mRootView.findViewById(R.id.filter_by_users);
        if (this.addCheckin != null) {
            this.addCheckin.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MapCheckinFragment.this.launchAddCheckin(0);
                }
            });
        }
        if (this.refreshCheckin != null) {
            this.refreshCheckin.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MapCheckinFragment.this.fetchCheckins();
                }
            });
        }
        if (this.filterCheckin != null) {
            this.filterCheckin.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MapCheckinFragment.this.showDropDownNav();
                }
            });
        }
        return this.mRootView;
    }

    private void updateRefreshStatus() {
        if (this.mRootView != null && this.addCheckin != null) {
            this.mRootView.findViewById(R.id.refresh_report_btn).setVisibility(this.refreshState ? 8 : 0);
            this.mRootView.findViewById(R.id.title_refresh_progress).setVisibility(this.refreshState ? 0 : 8);
        }
        if (this.refresh != null) {
            if (this.refreshState) {
                this.refresh.setActionView(R.layout.indeterminate_progress_action);
            } else {
                this.refresh.setActionView(null);
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mCheckinModel.size() == 0) {
            this.mHandler.post(this.mMarkersOnMap);
        }
        this.getActivity().registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_CHECKIN_SERVICES_ACTION));
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            this.getActivity().unregisterReceiver(this.fetchBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public GeoPoint getPoint(double lat, double lon) {
        return new GeoPoint((int)(lat * 1000000.0), (int)(lon * 1000000.0));
    }

    private void fetchCheckins() {
        this.getActivity().registerReceiver(this.fetchBroadcastReceiver, new IntentFilter(SyncServices.FETCH_CHECKIN_SERVICES_ACTION));
        this.refreshState = true;
        this.updateRefreshStatus();
        this.fetchCheckins = new Intent((Context)this.getActivity(), FetchCheckins.class);
        this.getActivity().startService(this.fetchCheckins);
    }

    public void populateMap() {
        Drawable marker = this.getResources().getDrawable(R.drawable.map_marker_red);
        marker.setBounds(0, 0, marker.getIntrinsicWidth(), marker.getIntrinsicHeight());
        this.itemOverlay = new CheckinMapItemizedOverlay(marker, this.map, this.getActivity());
        if (this.mCheckinModel != null) {
            for (ListCheckinModel checkinModel : this.mCheckinModel) {
                this.itemOverlay.addOverlay(new CheckinMapOverlayItem(this.getPoint(Double.valueOf(checkinModel.getLocationLatitude()), Double.valueOf(checkinModel.getLocationLongitude())), checkinModel.getUsername(), Util.limitString(checkinModel.getMessage(), 30), checkinModel.getThumbnail(), checkinModel.getCheckinId(), this.filterUserId));
            }
        }
        this.map.getOverlays().clear();
        if (this.itemOverlay.size() > 0) {
            this.map.getController().animateTo(this.itemOverlay.getCenter());
            this.map.getController().zoomToSpan(this.itemOverlay.getLatSpanE6(), this.itemOverlay.getLonSpanE6());
            this.map.getOverlays().add(this.itemOverlay);
        }
    }

    private void launchAddCheckin(int id2) {
        Intent i = new Intent((Context)this.getActivity(), AddCheckinActivity.class);
        i.putExtra("id", id2);
        this.startActivityForResult(i, 2);
        this.getActivity().overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
    }
}

