/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.tablet;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.view.MenuItem;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.ReportMapItemizedOverlay;
import com.ushahidi.android.app.ReportMapOverlayItem;
import com.ushahidi.android.app.adapters.CategorySpinnerAdater;
import com.ushahidi.android.app.adapters.ListFetchedReportAdapter;
import com.ushahidi.android.app.entities.Category;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.fragments.BaseFragment;
import com.ushahidi.android.app.models.ListPhotoModel;
import com.ushahidi.android.app.models.ListReportModel;
import com.ushahidi.android.app.net.CategoriesHttpClient;
import com.ushahidi.android.app.net.ReportsHttpClient;
import com.ushahidi.android.app.tasks.ProgressTask;
import com.ushahidi.android.app.ui.phone.AddReportActivity;
import com.ushahidi.android.app.util.ApiUtils;
import com.ushahidi.android.app.util.Util;
import java.util.List;

public class MapFragment<ReportMapItemOverlay>
extends BaseFragment {
    private MapView map = null;
    private ListReportModel mListReportModel;
    List<ListReportModel> mReportModel;
    private ReportMapItemizedOverlay<ReportMapOverlayItem> itemOverlay;
    private Handler mHandler;
    private int filterCategory = 0;
    private MenuItem refresh;
    private CategorySpinnerAdater spinnerArrayAdapter;
    private ViewGroup mRootView;
    private ImageButton addReport = null;
    private ImageButton refreshReport = null;
    private ImageButton filterReport = null;
    private boolean refreshState = false;
    private ApiUtils apiUtils;
    final Runnable fetchReportListByCategory = new Runnable(){

        @Override
        public void run() {
            try {
                boolean loaded = MapFragment.this.mListReportModel.loadReportByCategory(MapFragment.this.filterCategory);
                if (loaded) {
                    MapFragment.this.mReportModel = MapFragment.this.mListReportModel.getReports((Context)MapFragment.this.getActivity());
                    MapFragment.this.populateMap();
                }
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable fetchReportList = new Runnable(){

        @Override
        public void run() {
            try {
                MapFragment.this.mListReportModel.load();
                MapFragment.this.mReportModel = MapFragment.this.mListReportModel.getReports((Context)MapFragment.this.getActivity());
                MapFragment.this.populateMap();
                MapFragment.this.showCategories();
            }
            catch (Exception e) {
                return;
            }
        }
    };
    final Runnable mMarkersOnMap = new Runnable(){

        @Override
        public void run() {
            MapFragment.this.populateMap();
        }
    };

    public MapFragment() {
        super(R.menu.map_report);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mListReportModel = new ListReportModel();
        this.mListReportModel.load();
        this.mReportModel = this.mListReportModel.getReports((Context)this.getActivity());
        this.showCategories();
        this.mHandler = new Handler();
        this.apiUtils = new ApiUtils((Context)this.getActivity());
        this.map = new MapView((Context)this.getActivity(), this.getActivity().getString(R.string.google_map_api_key));
        Preferences.loadSettings((Context)this.getActivity());
        if (this.mReportModel.size() > 0) {
            this.map.setClickable(true);
            this.map.setBuiltInZoomControls(true);
            this.mHandler.post(this.mMarkersOnMap);
        } else {
            this.toastLong(R.string.no_reports);
        }
        ((ViewGroup)this.getView()).addView((View)this.map);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_refresh) {
            this.refresh = item;
            new RefreshReports(this.getActivity()).execute(new String[]{null});
            return true;
        }
        if (item.getItemId() == R.id.menu_add) {
            this.launchAddReport();
            return true;
        }
        if (item.getItemId() == R.id.menu_normal) {
            this.map.setSatellite(false);
            this.map.setTraffic(false);
            return true;
        }
        if (item.getItemId() == R.id.menu_satellite) {
            this.map.setSatellite(true);
            return true;
        }
        if (item.getItemId() == R.id.filter_by) {
            this.showDropDownNav();
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.getActivity().finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected View headerView() {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        ViewGroup viewGroup = (ViewGroup)inflater.inflate(R.layout.map_view_header, null, false);
        TextView textView = (TextView)viewGroup.findViewById(R.id.map_header);
        textView.setText(R.string.all_categories);
        return viewGroup;
    }

    private void showDropDownNav() {
        this.showCategories();
        new AlertDialog.Builder((Context)this.getActivity()).setTitle((CharSequence)this.getActivity().getString(R.string.prompt_mesg)).setAdapter((ListAdapter)this.spinnerArrayAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MapFragment.this.filterCategory = ((Category)MapFragment.this.spinnerArrayAdapter.getTag(which)).getCategoryId();
                String all = ((Category)MapFragment.this.spinnerArrayAdapter.getTag(which)).getCategoryTitle();
                if (all != null && !TextUtils.isEmpty((CharSequence)all) && all != MapFragment.this.getActivity().getString(R.string.all_categories)) {
                    MapFragment.this.mHandler.post(MapFragment.this.fetchReportListByCategory);
                } else {
                    MapFragment.this.mHandler.post(MapFragment.this.fetchReportList);
                }
                dialog.dismiss();
            }
        }).create().show();
    }

    public void showCategories() {
        this.spinnerArrayAdapter = new CategorySpinnerAdater((Context)this.getActivity());
        this.spinnerArrayAdapter.refresh();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = (ViewGroup)inflater.inflate(R.layout.list_report, null);
        this.addReport = (ImageButton)this.mRootView.findViewById(R.id.add_report_btn);
        this.refreshReport = (ImageButton)this.mRootView.findViewById(R.id.refresh_report_btn);
        this.filterReport = (ImageButton)this.mRootView.findViewById(R.id.filter_by_category);
        if (this.addReport != null) {
            this.addReport.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MapFragment.this.launchAddReport();
                }
            });
        }
        if (this.refreshReport != null) {
            this.refreshReport.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new RefreshReports(MapFragment.this.getActivity()).execute(new String[]{null});
                }
            });
        }
        if (this.filterReport != null) {
            this.filterReport.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MapFragment.this.showDropDownNav();
                }
            });
        }
        return this.mRootView;
    }

    private void updateRefreshStatus() {
        if (this.mRootView != null && this.addReport != null) {
            this.mRootView.findViewById(R.id.refresh_report_btn).setVisibility(this.refreshState ? 8 : 0);
            this.mRootView.findViewById(R.id.title_refresh_progress).setVisibility(this.refreshState ? 0 : 8);
        }
        if (this.refresh != null) {
            if (this.refreshState) {
                this.refresh.setActionView(R.layout.indeterminate_progress_action);
            } else {
                this.refresh.setActionView(null);
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mReportModel.size() == 0) {
            this.mHandler.post(this.mMarkersOnMap);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (new RefreshReports(this.getActivity()).cancel(true)) {
            this.refreshState = false;
            this.updateRefreshStatus();
        }
    }

    public GeoPoint getPoint(double lat, double lon) {
        return new GeoPoint((int)(lat * 1000000.0), (int)(lon * 1000000.0));
    }

    public void populateMap() {
        Drawable marker = this.getResources().getDrawable(R.drawable.map_marker_red);
        marker.setBounds(0, 0, marker.getIntrinsicWidth(), marker.getIntrinsicHeight());
        this.itemOverlay = new ReportMapItemizedOverlay(marker, this.map, this.getActivity());
        if (this.mReportModel != null) {
            for (ListReportModel reportModel : this.mReportModel) {
                this.itemOverlay.addOverlay(new ReportMapOverlayItem(this.getPoint(Double.valueOf(reportModel.getLatitude()), Double.valueOf(reportModel.getLongitude())), reportModel.getTitle(), Util.limitString(reportModel.getDesc(), 30), reportModel.getThumbnail(), reportModel.getId(), ""));
            }
        }
        this.map.getOverlays().clear();
        if (this.itemOverlay.size() > 0) {
            this.map.getController().animateTo(this.itemOverlay.getCenter());
            this.map.getController().zoomToSpan(this.itemOverlay.getLatSpanE6() + 50, this.itemOverlay.getLonSpanE6() + 50);
            this.map.getOverlays().add(this.itemOverlay);
        }
    }

    public void launchAddReport() {
        Intent i = new Intent((Context)this.getActivity(), AddReportActivity.class);
        i.putExtra("id", 0);
        this.startActivityForResult(i, 2);
        this.getActivity().overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
    }

    private void deleteFetchedReport() {
        List<ListReportModel> items = new ListFetchedReportAdapter((Context)this.getActivity()).fetchedReports();
        for (ListReportModel report : items) {
            if (!new ListReportModel().deleteAllFetchedReport(report.getReportId())) continue;
            List<Photo> photos = new ListPhotoModel().getPhotosByReportId(report.getReportId());
            for (Photo photo : photos) {
                ImageManager.deletePendingPhoto((Context)this.getActivity(), "/" + photo.getPhoto());
            }
        }
    }

    class RefreshReports
    extends ProgressTask {
        protected Integer status;

        public RefreshReports(Activity activity) {
            super(activity, R.string.loading_);
            this.status = 4;
            MapFragment.this.refreshState = true;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            this.dialog.cancel();
            MapFragment.this.refreshState = true;
            MapFragment.this.updateRefreshStatus();
        }

        protected Boolean doInBackground(String ... strings) {
            try {
                if (MapFragment.this.apiUtils.isConnected()) {
                    MapFragment.this.deleteFetchedReport();
                    new CategoriesHttpClient((Context)MapFragment.this.getActivity()).getCategoriesFromWeb();
                    this.status = new ReportsHttpClient((Context)MapFragment.this.getActivity()).getAllReportFromWeb();
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            if (result.booleanValue()) {
                this.log("fetching ");
                if (this.status == 4) {
                    MapFragment.this.toastLong(R.string.internet_connection);
                } else if (this.status == 110) {
                    MapFragment.this.toastLong(R.string.connection_timeout);
                } else if (this.status == 100) {
                    MapFragment.this.toastLong(R.string.could_not_fetch_reports);
                } else if (this.status == 0) {
                    this.log("successfully fetched");
                    MapFragment.this.mReportModel = MapFragment.this.mListReportModel.getReports((Context)MapFragment.this.getActivity());
                    MapFragment.this.populateMap();
                    MapFragment.this.showCategories();
                }
            }
            MapFragment.this.refreshState = false;
            MapFragment.this.updateRefreshStatus();
        }
    }
}

