/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.ui.tablet;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TabHost;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.helpers.LocalActivityManagerFragment;
import com.ushahidi.android.app.ui.phone.ReportMapActivity;
import com.ushahidi.android.app.ui.tablet.ListReportFragmentActivity;

public class ReportTabFragment
extends LocalActivityManagerFragment {
    private TabHost mTabHost;
    private static final String TAG_LIST_REPORT = "list";
    private static final String TAG_MAP_REPORT = "map";

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.tabs_report, container, false);
        this.mTabHost = (TabHost)view.findViewById(0x1020012);
        this.mTabHost.setup(this.getLocalActivityManager());
        this.listListTab();
        this.listMapTab();
        return view;
    }

    private void listListTab() {
        if (this.mTabHost != null) {
            this.addTab(TAG_LIST_REPORT, R.drawable.list, ListReportFragmentActivity.class);
        }
    }

    private void listMapTab() {
        if (this.mTabHost != null) {
            this.addTab(TAG_MAP_REPORT, R.drawable.map, ReportMapActivity.class);
        }
    }

    private void addTab(String indicator, int drawableId, Class<?> c) {
        TabHost tabHost = this.mTabHost;
        TabHost.TabSpec spec = tabHost.newTabSpec(indicator);
        Intent intent = new Intent((Context)this.getActivity(), c);
        View tabIndicator = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.tab_indicator, (ViewGroup)tabHost.getTabWidget(), false);
        ImageView icon = (ImageView)tabIndicator.findViewById(R.id.icon);
        icon.setImageResource(drawableId);
        spec.setIndicator(tabIndicator);
        spec.setContent(intent);
        tabHost.addTab(spec);
    }

    static ReportTabFragment newInstance() {
        ReportTabFragment f = new ReportTabFragment();
        return f;
    }
}

