/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.net.MainHttpClient;
import com.ushahidi.android.app.util.Util;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiUtils
extends MainHttpClient {
    Context context;
    private static final String CLASS_TAG = Util.class.getSimpleName();
    private static final String VALID_URL_PATTERN = "^(https?|ftp)://[a-z0-9-]+(\\.[a-z0-9-]+)+([/?].+)?$";
    private static Pattern pattern;
    private static Matcher matcher;
    private static JSONObject jsonObject;
    private static HttpResponse response;
    private static String jsonString;

    public ApiUtils(Context context) {
        super(context);
        this.context = context;
    }

    public boolean checkForCheckin() {
        Preferences.loadSettings(this.context);
        this.updateDomain();
        StringBuilder uriBuilder = new StringBuilder(Preferences.domain);
        uriBuilder.append("/api?task=version");
        uriBuilder.append("&resp=json");
        try {
            response = this.GetURL(uriBuilder.toString());
            if (response == null) {
                this.log("Dome " + Preferences.domain);
                return false;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                jsonString = this.GetText(response);
                this.log("jack " + jsonString + " domains " + Preferences.domain);
                JSONObject jsonObject = new JSONObject(jsonString);
                int checkinStatus = jsonObject.getJSONObject("payload").getInt("checkins");
                this.log("Checkin status " + checkinStatus);
                return checkinStatus == 1;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (JSONException e) {
            return false;
        }
    }

    public boolean isCheckinEnabled() {
        boolean checkinEnabled;
        if (this.checkForCheckin()) {
            Preferences.isCheckinEnabled = 1;
            checkinEnabled = true;
        } else {
            Preferences.isCheckinEnabled = 0;
            checkinEnabled = false;
        }
        Preferences.saveSettings(this.context);
        return checkinEnabled;
    }

    public void clearAllReportData() {
        Database.mReportCategoryDao.deleteAllReportCategory();
        Database.mReportDao.deleteAllReport();
        Database.mMediaDao.deleteAllMedia();
        Database.mCategoryDao.deleteAllCategories();
    }

    public void clearAllFetchedReportData(int reportId) {
        Database.mReportCategoryDao.deleteAllReportCategory();
        Database.mReportDao.deleteAllReport();
        Database.mMediaDao.deleteAllMedia();
        Database.mCategoryDao.deleteAllCategories();
    }

    public static boolean validateUshahidiInstance(String ushahidiUrl) {
        if (!TextUtils.isEmpty((CharSequence)ushahidiUrl)) {
            pattern = Pattern.compile(VALID_URL_PATTERN);
            matcher = pattern.matcher(ushahidiUrl);
            return matcher.matches();
        }
        return false;
    }

    public static int extractPayloadJSON(String json_data) {
        try {
            jsonObject = new JSONObject(json_data);
            String errorCode = jsonObject.getJSONObject("error").getString("code");
            return Integer.parseInt(errorCode);
        }
        catch (JSONException e) {
            Log.e((String)CLASS_TAG, (String)e.toString());
            return 10;
        }
    }

    private String httpGet(String url) {
        try {
            HttpResponse r = this.GetURL(url);
            if (r == null) {
                return null;
            }
            int stat = r.getStatusLine().getStatusCode();
            String ret = this.GetText(r);
            if (stat != 200) {
                return null;
            }
            return ret;
        }
        catch (IOException e) {
            return null;
        }
    }

    private String trimVersion(String s) {
        return s.replaceAll("[^0-9.]", "");
    }

    public void updateDomain() {
        Preferences.loadSettings(this.context);
        StringBuilder uriBuilder = new StringBuilder(Preferences.domain);
        uriBuilder.append("/api?task=version");
        uriBuilder.append("&resp=json");
        try {
            int statusCode;
            response = this.GetURL(uriBuilder.toString());
            if (response != null && (statusCode = response.getStatusLine().getStatusCode()) == 200) {
                jsonString = this.GetText(response);
                this.log(String.format("%s %s ", "Update domain", jsonString));
                JSONObject payload = new JSONObject(jsonString).getJSONObject("payload");
                Preferences.domain = payload.getString("domain");
                String ogsVer = this.httpGet(Preferences.domain + "/opengeosms/version");
                Preferences.ogsPluginVersion = ogsVer == null ? "" : this.trimVersion(ogsVer);
                Preferences.phonenumber = payload.has("sms") ? payload.getString("sms") : "";
                Preferences.saveSettings(this.context);
            }
        }
        catch (IOException e) {
            this.log(CLASS_TAG, e);
        }
        catch (JSONException e) {
            this.log(CLASS_TAG, (Exception)((Object)e));
        }
    }
}

