/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Category;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CategoriesApiUtils {
    private JSONObject jsonObject;
    private boolean processingResult = true;

    public CategoriesApiUtils(String jsonString) {
        try {
            this.jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException e) {
            new Util().log("JSONException", (Exception)((Object)e));
            this.processingResult = false;
        }
    }

    private JSONObject getCategoryPayloadObj() {
        try {
            return this.jsonObject.getJSONObject("payload");
        }
        catch (JSONException e) {
            new Util().log("JSONException", (Exception)((Object)e));
            return new JSONObject();
        }
    }

    private JSONArray getCategoriesArr() {
        try {
            return this.getCategoryPayloadObj().getJSONArray("categories");
        }
        catch (JSONException e) {
            new Util().log("JSONException", (Exception)((Object)e));
            return new JSONArray();
        }
    }

    public boolean getCategoriesList() {
        new Util().log("Save report");
        if (this.processingResult) {
            ArrayList<Category> listCategory = new ArrayList<Category>();
            JSONArray categoriesArr = this.getCategoriesArr();
            int id2 = 0;
            if (categoriesArr != null) {
                for (int i = 0; i < categoriesArr.length(); ++i) {
                    Category category = new Category();
                    try {
                        id2 = categoriesArr.getJSONObject(i).getJSONObject("category").getInt("id");
                        category.setCategoryId(id2);
                        if (!categoriesArr.getJSONObject(i).getJSONObject("category").isNull("color")) {
                            category.setCategoryColor(categoriesArr.getJSONObject(i).getJSONObject("category").getString("color"));
                        }
                        if (!categoriesArr.getJSONObject(i).getJSONObject("category").isNull("parent_id")) {
                            category.setParentId(categoriesArr.getJSONObject(i).getJSONObject("category").getInt("parent_id"));
                        }
                        if (!categoriesArr.getJSONObject(i).getJSONObject("category").isNull("description")) {
                            category.setCategoryDescription(categoriesArr.getJSONObject(i).getJSONObject("category").getString("description"));
                        }
                        if (!categoriesArr.getJSONObject(i).getJSONObject("category").isNull("title")) {
                            category.setCategoryTitle(categoriesArr.getJSONObject(i).getJSONObject("category").getString("title"));
                        }
                        if (!categoriesArr.getJSONObject(i).getJSONObject("category").isNull("position")) {
                            category.setCategoryPosition(categoriesArr.getJSONObject(i).getJSONObject("category").getInt("position"));
                        }
                    }
                    catch (JSONException e) {
                        new Util().log("JSONException", (Exception)((Object)e));
                        this.processingResult = false;
                        return false;
                    }
                    listCategory.add(category);
                }
                return this.saveCategories(listCategory);
            }
        }
        return false;
    }

    private boolean saveCategories(List<Category> categories) {
        if (categories != null && categories.size() > 0) {
            return Database.mCategoryDao.addCategories(categories);
        }
        return false;
    }
}

