/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.content.Context;
import android.text.TextUtils;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Checkin;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.entities.User;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckinApiUtils {
    private JSONObject jsonObject;
    private boolean processingResult = true;

    public CheckinApiUtils(String jsonString) {
        try {
            this.jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException e) {
            new Util().log("JSONException", (Exception)((Object)e));
            this.processingResult = false;
        }
    }

    private JSONObject getCheckinsObject() {
        try {
            return this.jsonObject.getJSONObject("payload");
        }
        catch (JSONException e) {
            return new JSONObject();
        }
    }

    private JSONArray getCheckinsArray() {
        try {
            return this.getCheckinsObject().getJSONArray("checkins");
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    private JSONArray getCheckinsUsersArray() {
        try {
            return this.getCheckinsObject().getJSONArray("users");
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    public ArrayList<User> getCheckinsUsersList() {
        if (this.processingResult) {
            ArrayList<User> checkinsUsersList = new ArrayList<User>();
            JSONArray checkinsUsersArray = this.getCheckinsUsersArray();
            if (checkinsUsersArray != null) {
                for (int index = 0; index < checkinsUsersArray.length(); ++index) {
                    User users = new User();
                    try {
                        users.setUserId(checkinsUsersArray.getJSONObject(index).getInt("id"));
                        users.setUsername(checkinsUsersArray.getJSONObject(index).getString("name"));
                        users.setColor(checkinsUsersArray.getJSONObject(index).getString("color"));
                    }
                    catch (JSONException e) {
                        this.processingResult = false;
                        return null;
                    }
                    checkinsUsersList.add(users);
                }
                return checkinsUsersList;
            }
        }
        return null;
    }

    public List<Checkin> getCheckinsList(Context context) {
        new Util().log("Save report");
        if (this.processingResult) {
            ArrayList<Checkin> checkinList = new ArrayList<Checkin>();
            ArrayList<User> checkinsUsersList = new ArrayList<User>();
            JSONArray checkinsArray = this.getCheckinsArray();
            int id2 = 0;
            if (checkinsArray != null && checkinsArray.length() > 0) {
                for (int i = 0; i < checkinsArray.length(); ++i) {
                    Checkin currentCheckin = new Checkin();
                    try {
                        id2 = checkinsArray.getJSONObject(i).getInt("id");
                        currentCheckin.setCheckinId(id2);
                        currentCheckin.setLocationName(checkinsArray.getJSONObject(i).getString("loc"));
                        currentCheckin.setLocationLatitude(checkinsArray.getJSONObject(i).getString("lat"));
                        currentCheckin.setLocationLongitude(checkinsArray.getJSONObject(i).getString("lon"));
                        currentCheckin.setDate(checkinsArray.getJSONObject(i).getString("date"));
                        currentCheckin.setMessage(checkinsArray.getJSONObject(i).getString("msg"));
                        if (checkinsArray.getJSONObject(i).isNull("user")) {
                            currentCheckin.setUsername(checkinsArray.getJSONObject(i).getString("name"));
                        } else {
                            currentCheckin.setUserId(checkinsArray.getJSONObject(i).getJSONObject("user").getInt("id"));
                            User users = new User();
                            users.setUserId(checkinsArray.getJSONObject(i).getJSONObject("user").getInt("id"));
                            users.setUsername(checkinsArray.getJSONObject(i).getJSONObject("user").getString("name"));
                            users.setColor(checkinsArray.getJSONObject(i).getJSONObject("user").getString("color"));
                            checkinsUsersList.add(users);
                            this.saveUsers(checkinsUsersList);
                        }
                        if (!checkinsArray.getJSONObject(i).isNull("media")) {
                            JSONArray mediaArr = checkinsArray.getJSONObject(i).getJSONArray("media");
                            for (int w = 0; w < mediaArr.length(); ++w) {
                                try {
                                    if (mediaArr.getJSONObject(w).isNull("id")) continue;
                                    if (mediaArr.getJSONObject(w).getInt("type") == 1 && !mediaArr.getJSONObject(w).isNull("link")) {
                                        String fileName = Util.getDateTime() + ".jpg";
                                        this.saveMedia(mediaArr.getJSONObject(w).getInt("id"), id2, mediaArr.getJSONObject(w).getInt("type"), fileName);
                                        if (mediaArr.getJSONObject(w).getString("link").startsWith("http")) {
                                            this.saveImages(mediaArr.getJSONObject(w).getString("link"), fileName, context);
                                            continue;
                                        }
                                        String link = Preferences.domain + "/media/uploads/" + mediaArr.getJSONObject(w).getString("link");
                                        this.saveImages(link, fileName, context);
                                        continue;
                                    }
                                    this.saveMedia(mediaArr.getJSONObject(w).getInt("id"), id2, mediaArr.getJSONObject(w).getInt("type"), mediaArr.getJSONObject(w).getString("link"));
                                    continue;
                                }
                                catch (JSONException exc) {
                                    new Util().log("JSONException", (Exception)((Object)exc));
                                }
                            }
                        }
                    }
                    catch (JSONException e) {
                        new Util().log("JSONException", (Exception)((Object)e));
                        this.processingResult = false;
                        return null;
                    }
                    checkinList.add(currentCheckin);
                }
                return checkinList;
            }
        }
        return null;
    }

    public boolean saveCheckins(Context context) {
        List<Checkin> checkins = this.getCheckinsList(context);
        if (checkins != null) {
            return Database.mCheckin.addCheckins(checkins);
        }
        return false;
    }

    public boolean saveUsers() {
        ArrayList<User> users = this.getCheckinsUsersList();
        if (users != null && users.size() > 0) {
            return Database.mUserDao.addUser(users);
        }
        return false;
    }

    public boolean saveUsers(List<User> users) {
        if (users != null && users.size() > 0) {
            return Database.mUserDao.addUser(users);
        }
        return false;
    }

    private void saveMedia(int mediaId, int checkinId, int type, String link) {
        new Util().log("downloading... " + link + " CheckinId: " + checkinId);
        Media media = new Media();
        media.setMediaId(mediaId);
        media.setCheckinId(checkinId);
        media.setType(type);
        media.setLink(link);
        ArrayList<Media> sMedia = new ArrayList<Media>();
        sMedia.add(media);
        Database.mMediaDao.addMedia(sMedia);
    }

    private void saveImages(String linkUrl, String fileName, Context context) {
        new Util().log("Save Images: " + linkUrl + " FileName: " + fileName);
        if (!TextUtils.isEmpty((CharSequence)linkUrl)) {
            ImageManager.downloadImage(linkUrl, fileName, context);
        }
    }
}

