/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.content.Context;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Comment;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommentApiUtils {
    private JSONObject jsonObject;
    private boolean processingResult = true;

    public CommentApiUtils(String jsonString) {
        new Util().log("JSONString: " + jsonString);
        try {
            this.jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException e) {
            new Util().log("JSONException", (Exception)((Object)e));
            this.processingResult = false;
        }
    }

    private JSONObject getCommentsObject() {
        try {
            return this.jsonObject.getJSONObject("payload");
        }
        catch (JSONException e) {
            return new JSONObject();
        }
    }

    private JSONArray getCommentsArray() {
        try {
            return this.getCommentsObject().getJSONArray("comments");
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    public List<Comment> getCommentsList(Context context) {
        new Util().log("Save comments");
        if (this.processingResult) {
            ArrayList<Comment> commentList = new ArrayList<Comment>();
            JSONArray commentArray = this.getCommentsArray();
            int id2 = 0;
            if (commentArray != null && commentArray.length() > 0) {
                for (int i = 0; i < commentArray.length(); ++i) {
                    Comment currentComment = new Comment();
                    try {
                        id2 = commentArray.getJSONObject(i).getJSONObject("comment").getInt("id");
                        currentComment.setCommentId(id2);
                        currentComment.setReportId(commentArray.getJSONObject(i).getJSONObject("comment").getInt("incident_id"));
                        currentComment.setCommentAuthor(commentArray.getJSONObject(i).getJSONObject("comment").getString("comment_author"));
                        currentComment.setCommentDate(commentArray.getJSONObject(i).getJSONObject("comment").getString("comment_date"));
                        currentComment.setCommentDescription(commentArray.getJSONObject(i).getJSONObject("comment").getString("comment_description"));
                    }
                    catch (JSONException e) {
                        new Util().log("JSONException", (Exception)((Object)e));
                        this.processingResult = false;
                        return null;
                    }
                    commentList.add(currentComment);
                }
                return commentList;
            }
        }
        return null;
    }

    public List<Comment> getCheckinCommentsList(Context context) {
        new Util().log("Save comments");
        if (this.processingResult) {
            ArrayList<Comment> commentList = new ArrayList<Comment>();
            JSONArray commentArray = this.getCommentsArray();
            int id2 = 0;
            if (commentArray != null && commentArray.length() > 0) {
                for (int i = 0; i < commentArray.length(); ++i) {
                    Comment currentComment = new Comment();
                    try {
                        id2 = commentArray.getJSONObject(i).getJSONObject("comment").getInt("id");
                        currentComment.setCommentId(id2);
                        currentComment.setCheckinId(commentArray.getJSONObject(i).getJSONObject("comment").getInt("checkin_id"));
                        currentComment.setCommentAuthor(commentArray.getJSONObject(i).getJSONObject("comment").getString("comment_author"));
                        currentComment.setCommentDate(commentArray.getJSONObject(i).getJSONObject("comment").getString("comment_date"));
                        currentComment.setCommentDescription(commentArray.getJSONObject(i).getJSONObject("comment").getString("comment_description"));
                    }
                    catch (JSONException e) {
                        new Util().log("JSONException", (Exception)((Object)e));
                        this.processingResult = false;
                        return null;
                    }
                    commentList.add(currentComment);
                }
                return commentList;
            }
        }
        return null;
    }

    public boolean saveComments(Context context) {
        List<Comment> comments = this.getCommentsList(context);
        if (comments != null && comments.size() > 0) {
            for (Comment comment : comments) {
                Database.mCommentDao.deleteCommentByReportId(comment.getReportId());
            }
            return Database.mCommentDao.addComment(comments);
        }
        return false;
    }

    public boolean saveCheckinsComments(Context context) {
        List<Comment> comments = this.getCheckinCommentsList(context);
        if (comments != null && comments.size() > 0) {
            for (Comment comment : comments) {
                Database.mCommentDao.deleteCommentByCheckinId(comment.getCheckinId());
            }
            return Database.mCommentDao.addComment(comments);
        }
        return false;
    }
}

