/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import com.ushahidi.android.app.entities.IDbEntity;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DbUtils {
    public static final String COLUMN_ID = "_id";
    public static final int DATABASE_VERSION = 14;
    public static final String DATABASE_NAME = "ushahidi_db";
    private static final String[] SQL_KEYWORDS = new String[]{"from", "group", "select"};

    private static boolean isSqlRestricted(String string2) {
        for (String keyword : SQL_KEYWORDS) {
            if (!keyword.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getCreateStatement(Class<? extends IDbEntity> entityClass) {
        if (entityClass.isPrimitive() || entityClass.isEnum()) {
            throw new IllegalArgumentException("Cannot store primitive type or enum in separate table: " + entityClass);
        }
        StringBuilder bob = new StringBuilder();
        for (Field intransientField : DbUtils.getFields(entityClass)) {
            bob.append(", ");
            String columnName = DbUtils.getColumnName(intransientField);
            bob.append(columnName);
            bob.append(" ");
            bob.append(DbUtils.getColumnType(intransientField.getType()));
            if (!columnName.equalsIgnoreCase(COLUMN_ID)) continue;
            bob.append(" PRIMARY KEY AUTOINCREMENT");
        }
        return "CREATE TABLE " + DbUtils.getTableName(entityClass) + " (" + bob.substring(2) + ");";
    }

    public static String getCreateTable(String tableName) {
        if (tableName.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an empty table ");
        }
        return "CREATE TABLE " + tableName;
    }

    static String getColumnType(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return "TEXT";
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class) || clazz.equals(Long.TYPE) || clazz.equals(Long.class) || clazz.isEnum()) {
            return "INTEGER";
        }
        throw new IllegalArgumentException("Unsupported column type: " + clazz);
    }

    public static String getColumnName(Field field) {
        String columnName = field.getName();
        if (DbUtils.isSqlRestricted(columnName)) {
            columnName = "_" + columnName;
        }
        return columnName;
    }

    public static List<Field> getFields(Class<? extends IDbEntity> entityClass) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field declared : entityClass.getDeclaredFields()) {
            if (Modifier.isTransient(declared.getModifiers())) continue;
            declared.setAccessible(true);
            fields.add(declared);
        }
        return fields;
    }

    public static String getTableName(Class<? extends IDbEntity> entityClass) {
        return entityClass.getSimpleName();
    }

    public static Object getContentValue(IDbEntity entity, Field field) {
        try {
            return field.get(entity);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static void addContentValue(ContentValues values, IDbEntity entity, Field field, boolean insertNulls) {
        block18: {
            try {
                Class<?> type = field.getType();
                String key = DbUtils.getColumnName(field);
                if (type.equals(Integer.TYPE)) {
                    values.put(key, Integer.valueOf(field.getInt(entity)));
                    break block18;
                }
                if (type.equals(Integer.class)) {
                    Object value = field.get(entity);
                    if (insertNulls || value != null) {
                        values.put(key, (Integer)value);
                    }
                    break block18;
                }
                if (type.equals(Long.TYPE)) {
                    values.put(key, Long.valueOf(field.getLong(entity)));
                    break block18;
                }
                if (type.equals(Long.class)) {
                    Object value = field.get(entity);
                    if (insertNulls || value != null) {
                        values.put(key, (Long)value);
                    }
                    break block18;
                }
                if (type.equals(String.class)) {
                    Object value = field.get(entity);
                    if (insertNulls || value != null) {
                        values.put(key, (String)value);
                    }
                    break block18;
                }
                if (type.isEnum()) {
                    Object value = field.get(entity);
                    if (value != null) {
                        values.put(key, Integer.valueOf(((Enum)value).ordinal()));
                    } else if (insertNulls) {
                        values.put(key, (Integer)null);
                    }
                    break block18;
                }
                if (type.equals(IDbEntity.class)) {
                    Object value = field.get(entity);
                    if (value != null) {
                        values.put(key, Integer.valueOf(((IDbEntity)value).getDbId()));
                    } else if (insertNulls) {
                        values.put(key, (Integer)null);
                    }
                    break block18;
                }
                throw new IllegalArgumentException("Unable to add content value for class");
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static <T extends IDbEntity> List<T> asList(Class<T> entityClass, Cursor cursor) {
        if (cursor == null) {
            return Collections.emptyList();
        }
        ArrayList<IDbEntity> results = new ArrayList<IDbEntity>(cursor.getCount());
        List<Field> fields = DbUtils.getFields(entityClass);
        while (cursor.moveToNext()) {
            IDbEntity instance;
            try {
                instance = (IDbEntity)entityClass.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to create instance of " + entityClass);
            }
            for (Field field : fields) {
                DbUtils.setFieldValue(instance, field, cursor);
            }
            results.add(instance);
        }
        cursor.close();
        return results;
    }

    static <T extends IDbEntity> void setFieldValue(T instance, Field field, Cursor cursor) {
        Object value;
        Class<?> type = field.getType();
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            value = cursor.getInt(cursor.getColumnIndex(DbUtils.getColumnName(field)));
        } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            value = cursor.getLong(cursor.getColumnIndex(DbUtils.getColumnName(field)));
        } else if (type.equals(String.class)) {
            value = cursor.getString(cursor.getColumnIndex(DbUtils.getColumnName(field)));
        } else if (type.isEnum()) {
            value = type.getEnumConstants()[cursor.getInt(cursor.getColumnIndex(DbUtils.getColumnName(field)))];
        } else {
            throw new IllegalArgumentException("Unsupported column type: " + type);
        }
        try {
            field.set(instance, value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not set field " + field.getName() + " of " + instance.getClass());
        }
    }

    public static String getWhereClause(Uri uri, String selection) {
        List pathSegments = uri.getPathSegments();
        if (pathSegments.size() > 1) {
            if (selection.length() > 0) {
                selection = selection + " AND ";
            }
            selection = selection + "_id=" + (String)pathSegments.get(1);
        }
        return null;
    }

    public static String getTableName(Uri uri) {
        return (String)uri.getPathSegments().get(0);
    }

    public static String getUri(String baseUri, Class<? extends IDbEntity> entityClass) {
        return baseUri + '/' + DbUtils.getTableName(entityClass);
    }

    public static ContentValues getValues(IDbEntity entity) {
        return DbUtils.getValues(entity, true);
    }

    public static ContentValues getNonNullValues(IDbEntity entity) {
        return DbUtils.getValues(entity, false);
    }

    static ContentValues getValues(IDbEntity entity, boolean insertNulls) {
        List<Field> fields = DbUtils.getFields(entity.getClass());
        ContentValues values = new ContentValues(fields.size());
        for (Field field : fields) {
            DbUtils.addContentValue(values, entity, field, insertNulls);
        }
        return values;
    }

    public static String getValueAsSqlString(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("I don't expect you can use NULL in this way... should be a special method for that.");
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Long) {
            return Integer.toString((Integer)value);
        }
        if (value.getClass().isEnum()) {
            return Integer.toString(((Enum)value).ordinal());
        }
        throw new IllegalArgumentException("Unsupported value type for where statement: " + value.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getColumns(SQLiteDatabase db, String tableName) {
        ArrayList<String> ar = null;
        try (Cursor c = null;){
            c = db.rawQuery("SELECT * FROM " + tableName + " LIMIT 1", null);
            if (c != null) {
                ar = new ArrayList<String>(Arrays.asList(c.getColumnNames()));
            }
        }
        return ar;
    }

    public static String join(List<String> list, String delim) {
        StringBuilder buf = new StringBuilder();
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            if (i != 0) {
                buf.append(delim);
            }
            buf.append(list.get(i));
        }
        return buf.toString();
    }
}

