/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.AsyncTask;
import android.widget.ImageSwitcher;
import com.ushahidi.android.app.ImageManager;
import java.lang.ref.WeakReference;

public class ImageSwitchWorker {
    private static final int FADE_IN_TIME = 200;
    private Context context;
    private Bitmap loadingBitmap;
    private boolean fadeIn = true;

    public ImageSwitchWorker(Context context) {
        this.context = context;
    }

    public void loadImage(Object data, ImageSwitcher imageSwitcher, boolean fullScale, int width) {
        BitmapWorkerTask task = new BitmapWorkerTask(imageSwitcher);
        AsyncDrawable asyncDrawable = new AsyncDrawable(this.context.getResources(), this.loadingBitmap, task);
        imageSwitcher.setImageDrawable((Drawable)asyncDrawable);
        task.fullScale = fullScale;
        task.width = width;
        task.imageSwitcher = imageSwitcher;
        task.execute(new Object[]{data});
    }

    public void setLoadingImage(Bitmap bitmap) {
        this.loadingBitmap = bitmap;
    }

    public void setImageFadeIn(boolean fadeIn) {
        this.fadeIn = fadeIn;
    }

    private void setImageBitmap(ImageSwitcher imageSwitcher, Bitmap bitmap) {
        if (this.fadeIn) {
            TransitionDrawable td = new TransitionDrawable(new Drawable[]{new ColorDrawable(17170445), new BitmapDrawable(this.context.getResources(), bitmap)});
            imageSwitcher.setBackgroundDrawable((Drawable)new BitmapDrawable(this.context.getResources(), this.loadingBitmap));
            imageSwitcher.setImageDrawable((Drawable)td);
            td.startTransition(200);
        } else {
            imageSwitcher.setImageDrawable((Drawable)new BitmapDrawable(bitmap));
        }
    }

    private class BitmapWorkerTask
    extends AsyncTask<Object, Void, Bitmap> {
        private Object data;
        private final WeakReference<ImageSwitcher> imageSwitcherReference;
        protected ImageSwitcher imageSwitcher;
        protected int width;
        protected boolean fullScale = false;

        public BitmapWorkerTask(ImageSwitcher imageSwitcher) {
            this.imageSwitcherReference = new WeakReference<ImageSwitcher>(imageSwitcher);
        }

        protected Bitmap doInBackground(Object ... params) {
            this.data = params[0];
            String dataString = String.valueOf(this.data);
            Bitmap bitmap = null;
            if (bitmap == null && !this.isCancelled()) {
                bitmap = this.fullScale && this.width == 0 ? ImageManager.getBitmaps(ImageSwitchWorker.this.context, dataString) : ImageManager.getBitmaps(ImageSwitchWorker.this.context, dataString, this.width);
            }
            return bitmap;
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (this.isCancelled()) {
                bitmap = null;
            }
            if (bitmap != null && this.imageSwitcher != null) {
                ImageSwitchWorker.this.setImageBitmap(this.imageSwitcher, bitmap);
            }
        }
    }

    static class AsyncDrawable
    extends BitmapDrawable {
        private final WeakReference<BitmapWorkerTask> bitmapWorkerTaskReference;

        public AsyncDrawable(Resources res, Bitmap bitmap, BitmapWorkerTask bitmapWorkerTask) {
            super(res, bitmap);
            this.bitmapWorkerTaskReference = new WeakReference<BitmapWorkerTask>(bitmapWorkerTask);
        }

        public BitmapWorkerTask getBitmapWorkerTask() {
            return (BitmapWorkerTask)((Object)this.bitmapWorkerTaskReference.get());
        }
    }
}

