/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.ImageView;
import com.ushahidi.android.app.BuildConfig;
import com.ushahidi.android.app.ImageManager;
import java.lang.ref.WeakReference;

public class ImageViewWorker {
    private static final int FADE_IN_TIME = 200;
    private Context context;
    private Bitmap loadingBitmap;
    private boolean fadeIn = true;
    private static String TAG = ImageViewWorker.class.getSimpleName();

    public ImageViewWorker(Context context) {
        this.context = context;
    }

    public void loadImage(Object data, ImageView imageView, boolean fullScale, int width) {
        BitmapWorkerTask task = new BitmapWorkerTask(imageView);
        AsyncDrawable asyncDrawable = new AsyncDrawable(this.context.getResources(), this.loadingBitmap, task);
        imageView.setImageDrawable((Drawable)asyncDrawable);
        task.fullScale = fullScale;
        task.width = width;
        task.execute(new Object[]{data});
    }

    public void setLoadingImage(Bitmap bitmap) {
        this.loadingBitmap = bitmap;
    }

    public void setImageFadeIn(boolean fadeIn) {
        this.fadeIn = fadeIn;
    }

    public static void cancelWork(ImageView imageView) {
        BitmapWorkerTask bitmapWorkerTask = ImageViewWorker.getBitmapWorkerTask(imageView);
        if (bitmapWorkerTask != null) {
            bitmapWorkerTask.cancel(true);
            if (BuildConfig.DEBUG) {
                Object bitmapData = bitmapWorkerTask.data;
                Log.d((String)TAG, (String)("cancelWork - cancelled work for " + bitmapData));
            }
        }
    }

    public static boolean cancelPotentialWork(Object data, ImageView imageView) {
        BitmapWorkerTask bitmapWorkerTask = ImageViewWorker.getBitmapWorkerTask(imageView);
        if (bitmapWorkerTask != null) {
            Object bitmapData = bitmapWorkerTask.data;
            if (bitmapData == null || !bitmapData.equals(data)) {
                bitmapWorkerTask.cancel(true);
                if (BuildConfig.DEBUG) {
                    Log.d((String)TAG, (String)("cancelPotentialWork - cancelled work for " + data));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static BitmapWorkerTask getBitmapWorkerTask(ImageView imageView) {
        Drawable drawable2;
        if (imageView != null && (drawable2 = imageView.getDrawable()) instanceof AsyncDrawable) {
            AsyncDrawable asyncDrawable = (AsyncDrawable)drawable2;
            return asyncDrawable.getBitmapWorkerTask();
        }
        return null;
    }

    private void setImageBitmap(ImageView imageView, Bitmap bitmap) {
        if (this.fadeIn) {
            TransitionDrawable td = new TransitionDrawable(new Drawable[]{new ColorDrawable(17170445), new BitmapDrawable(this.context.getResources(), bitmap)});
            imageView.setBackgroundDrawable((Drawable)new BitmapDrawable(this.context.getResources(), this.loadingBitmap));
            imageView.setImageDrawable((Drawable)td);
            td.startTransition(200);
        } else {
            imageView.setImageBitmap(bitmap);
        }
    }

    private class BitmapWorkerTask
    extends AsyncTask<Object, Void, Bitmap> {
        private Object data;
        private final WeakReference<ImageView> imageViewReference;
        protected int width;
        protected boolean fullScale = false;

        public BitmapWorkerTask(ImageView imageView) {
            this.imageViewReference = new WeakReference<ImageView>(imageView);
        }

        protected Bitmap doInBackground(Object ... params) {
            this.data = params[0];
            String dataString = String.valueOf(this.data);
            Bitmap bitmap = null;
            if (bitmap == null && !this.isCancelled() && this.getAttachedImageView() != null) {
                bitmap = this.fullScale && this.width == 0 ? ImageManager.getBitmaps(ImageViewWorker.this.context, dataString) : ImageManager.getBitmaps(ImageViewWorker.this.context, dataString, this.width);
            }
            return bitmap;
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (this.isCancelled()) {
                bitmap = null;
            }
            ImageView imageView = this.getAttachedImageView();
            if (bitmap != null && imageView != null) {
                ImageViewWorker.this.setImageBitmap(imageView, bitmap);
            }
        }

        private ImageView getAttachedImageView() {
            ImageView imageView = (ImageView)this.imageViewReference.get();
            BitmapWorkerTask bitmapWorkerTask = ImageViewWorker.getBitmapWorkerTask(imageView);
            if (this == bitmapWorkerTask) {
                return imageView;
            }
            return null;
        }
    }

    static class AsyncDrawable
    extends BitmapDrawable {
        private final WeakReference<BitmapWorkerTask> bitmapWorkerTaskReference;

        public AsyncDrawable(Resources res, Bitmap bitmap, BitmapWorkerTask bitmapWorkerTask) {
            super(res, bitmap);
            this.bitmapWorkerTaskReference = new WeakReference<BitmapWorkerTask>(bitmapWorkerTask);
        }

        public BitmapWorkerTask getBitmapWorkerTask() {
            return (BitmapWorkerTask)((Object)this.bitmapWorkerTaskReference.get());
        }
    }
}

