/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.util.Log;
import android.view.InflateException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class Objects {
    public static <T, X extends T> X cast(T o) {
        return (X)o;
    }

    public static Type[] getGenericTypes(Object obj) {
        ParameterizedType superclass = (ParameterizedType)obj.getClass().getGenericSuperclass();
        return superclass.getActualTypeArguments();
    }

    public static Type getGenericType(Object obj, int index) {
        ParameterizedType superclass = (ParameterizedType)obj.getClass().getGenericSuperclass();
        return superclass.getActualTypeArguments()[index];
    }

    public static <T> T createInstance(Class<?> targetClass) {
        try {
            return (T)targetClass.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T createInstance(Class type, Class constructor, Object ... params) {
        try {
            return type.getConstructor(constructor).newInstance(params);
        }
        catch (InstantiationException e) {
            Log.e((String)Objects.class.getName(), (String)"InstantiationException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)Objects.class.getName(), (String)"IllegalAccessException", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)Objects.class.getName(), (String)"InvocationTargetException", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)Objects.class.getName(), (String)"NoSuchMethodException", (Throwable)e);
        }
        return null;
    }

    public static <T> T createInstance(Class type, Class[] constructors, Object ... params) {
        try {
            return type.getConstructor(constructors).newInstance(params);
        }
        catch (InstantiationException e) {
            Log.e((String)Objects.class.getName(), (String)"InstantiationException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)Objects.class.getName(), (String)"IllegalAccessException", (Throwable)e);
        }
        catch (IllegalStateException e) {
            Log.e((String)Objects.class.getName(), (String)"IllegalStateException", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)Objects.class.getName(), (String)"InvocationTargetException", (Throwable)e);
            for (StackTraceElement exception : e.getStackTrace()) {
                Log.e((String)Objects.class.getName(), (String)String.format("%s", exception.toString()));
            }
        }
        catch (NoSuchMethodException e) {
            Log.e((String)Objects.class.getName(), (String)"NoSuchMethodException", (Throwable)e);
        }
        catch (InflateException e) {
            Log.e((String)Objects.class.getName(), (String)"InflateException", (Throwable)e);
        }
        return null;
    }

    public static <T> T createInstance(Type type, Class[] constructorClasses, Object[] constructorParams) {
        try {
            Log.i((String)"Type", (String)type.toString());
            if (type.getClass().getConstructors().length > 0) {
                for (Constructor<?> construct : type.getClass().getConstructors()) {
                    Log.i((String)"Constructor", (String)construct.toString());
                }
                Constructor<?> constructor = type.getClass().getConstructor(constructorClasses);
                return (T)constructor.newInstance(constructorParams);
            }
            String typeName = type.toString().replaceFirst("class ", "");
            for (Constructor<?> construct : Class.forName(typeName).getConstructors()) {
                Log.i((String)"Constructor", (String)construct.toString());
            }
            Constructor<?> constructor = Class.forName(typeName).getConstructor(constructorClasses);
            return (T)constructor.newInstance(constructorParams);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

