/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import android.view.Display;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class PhotoUtils {
    private static final String CLASS_TAG = PhotoUtils.class.getCanonicalName();
    private static final String PENDING = "/pending";

    public static int getScreenOrientation(Activity context) {
        Display display = context.getWindowManager().getDefaultDisplay();
        if (display.getWidth() == display.getHeight()) {
            return 3;
        }
        if (display.getWidth() < display.getHeight()) {
            return 1;
        }
        return 2;
    }

    public static File[] getPendingPhotos(Context context) {
        File path = PhotoUtils.pendingPhotosPath(context);
        if (path != null && path.exists()) {
            return path.listFiles();
        }
        return null;
    }

    public static File pendingPhotosPath(Context context) {
        File path = new File(Environment.getExternalStorageDirectory(), context.getPackageName() + PENDING);
        return path;
    }

    public static Uri getPhotoUri(String filename, Activity activity) {
        File path = new File(Environment.getExternalStorageDirectory(), activity.getPackageName() + PENDING);
        if (!path.exists() && path.mkdir()) {
            return Uri.fromFile((File)new File(path, filename));
        }
        return Uri.fromFile((File)new File(path, filename));
    }

    public static String getPhotoPath(Activity activity) {
        new Util().log("getPhotoPath");
        File path = new File(Environment.getExternalStorageDirectory(), activity.getPackageName() + PENDING);
        return path.exists() ? path.getAbsolutePath() : null;
    }

    public static boolean imageExist(String filename, Activity activity) {
        new Util().log("%s %s ", "imageExist(): ", filename);
        File path = new File(filename);
        if (!path.exists()) {
            Log.d((String)CLASS_TAG, (String)"image does not exist");
            return false;
        }
        Log.d((String)CLASS_TAG, (String)"image does exist");
        return true;
    }

    public static Bitmap getGalleryPhoto(Activity activity, Uri uri) {
        if (uri != null) {
            String[] columns = new String[]{"_data", "orientation"};
            Cursor cursor = activity.getContentResolver().query(uri, columns, null, null, null);
            if (cursor != null) {
                cursor.moveToFirst();
                String filePath = cursor.getString(cursor.getColumnIndex(columns[0]));
                int orientation = cursor.getInt(cursor.getColumnIndex(columns[1]));
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
                if (options != null) {
                    Bitmap scaled = PhotoUtils.scaleBitmap(options, filePath);
                    if (orientation == 0 && scaled.getWidth() < scaled.getHeight()) {
                        new Util().log(String.format("FILE:%s ORIENTATION: LANDSCAPE", filePath));
                        Bitmap rotated = PhotoUtils.rotatePhoto(scaled, -90);
                        scaled.recycle();
                        return rotated;
                    }
                    if (orientation == 90 && scaled.getWidth() > scaled.getHeight()) {
                        new Util().log(String.format("FILE:%s ORIENTATION: PORTRAIT", filePath));
                        Bitmap rotated = PhotoUtils.rotatePhoto(scaled, 90);
                        scaled.recycle();
                        return rotated;
                    }
                    new Util().log(String.format("FILE:%s ORIENTATION: %d", filePath, orientation));
                    return scaled;
                }
            }
        }
        return null;
    }

    public static Bitmap getCameraPhoto(Activity activity, Uri uri) {
        if (uri != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
            if (options != null) {
                new Util().log(String.format("ORIGINAL %dx%d", options.outWidth, options.outHeight));
                Bitmap scaled = PhotoUtils.scaleBitmap(options, uri.getPath());
                if (scaled != null) {
                    new Util().log(String.format("SCALED %dx%d", scaled.getWidth(), scaled.getHeight()));
                    if (PhotoUtils.getScreenOrientation(activity) == 1 && scaled.getWidth() > scaled.getHeight()) {
                        Bitmap rotated = PhotoUtils.rotatePhoto(scaled, 90);
                        scaled.recycle();
                        return rotated;
                    }
                    return scaled;
                }
            }
        }
        return null;
    }

    public static boolean savePhoto(Activity activity, Bitmap bitmap, String fileName) {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)byteArray);
            bitmap.recycle();
            ImageManager.writeImage(byteArray.toByteArray(), fileName, PhotoUtils.getPhotoPath(activity));
            byteArray.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Bitmap rotatePhoto(Bitmap bitmap, int rotate) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotate);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static synchronized Bitmap scaleBitmap(BitmapFactory.Options options, String filePath) {
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (options != null) {
            float ratio = (float)options.outHeight / (float)options.outWidth;
            int width = Preferences.photoWidth > 0 ? Preferences.photoWidth : 500;
            new Util().log("Scaling image to " + width + " x " + ratio);
            options.inSampleSize = PhotoUtils.calculateInSampleSize(options, width, (int)((float)width * ratio));
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        return null;
    }

    public static synchronized Bitmap scaleBitmapByWidth(BitmapFactory.Options options, int width, String filePath) {
        if (options != null) {
            float ratio = (float)options.outHeight / (float)options.outWidth;
            new Util().log("Scaling image to " + width + " x " + ratio);
            int w = width > 0 ? width : 500;
            options.inSampleSize = PhotoUtils.calculateInSampleSize(options, w, (int)((float)w * ratio));
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        return null;
    }

    public static Bitmap scaleThumbnail(Bitmap original) {
        int height = 50;
        int width = 50;
        if (original != null) {
            Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)original, (int)width, (int)height, (boolean)true);
            original.recycle();
            return scaled;
        }
        return null;
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap input, float cornerRadius, int w, int h, boolean squareTL, boolean squareTR, boolean squareBL, boolean squareBR) {
        Bitmap output = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, w, h);
        RectF rectF = new RectF(rect);
        float roundPx = cornerRadius;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        if (squareTL) {
            canvas.drawRect(0.0f, 0.0f, (float)(w / 2), (float)(h / 2), paint);
        }
        if (squareTR) {
            canvas.drawRect((float)(w / 2), 0.0f, (float)w, (float)(h / 2), paint);
        }
        if (squareBL) {
            canvas.drawRect(0.0f, (float)(h / 2), (float)(w / 2), (float)h, paint);
        }
        if (squareBR) {
            canvas.drawRect((float)(w / 2), (float)(h / 2), (float)w, (float)h, paint);
        }
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(input, 0.0f, 0.0f, paint);
        return output;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int width = options.outWidth;
        int height = options.outHeight;
        int inSampleSize = 1;
        new Util().log(String.format("ORIGINAL %dx%d", reqWidth, reqHeight));
        if (height > reqHeight || width > reqWidth) {
            inSampleSize = width > height ? Math.round((float)height / (float)reqHeight) : Math.round((float)width / (float)reqWidth);
            float totalPixels = width * height;
            float totalReqPixelsCap = reqWidth * reqHeight * 2;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }
}

