/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ushahidi.android.app.ImageManager;
import com.ushahidi.android.app.MainApplication;
import com.ushahidi.android.app.Preferences;
import com.ushahidi.android.app.database.Database;
import com.ushahidi.android.app.entities.Media;
import com.ushahidi.android.app.entities.Report;
import com.ushahidi.android.app.entities.ReportCategory;
import com.ushahidi.android.app.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportsApiUtils {
    private JSONObject jsonObject;
    private boolean processingResult = true;

    public ReportsApiUtils(String jsonString) {
        try {
            this.jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException e) {
            this.log("JSONException", (Exception)((Object)e));
            this.processingResult = false;
        }
    }

    private JSONObject getReportPayloadObj() {
        try {
            if (!this.jsonObject.isNull("payload")) {
                return this.jsonObject.getJSONObject("payload");
            }
            return new JSONObject();
        }
        catch (JSONException e) {
            this.log("JSONException", (Exception)((Object)e));
            return new JSONObject();
        }
    }

    private JSONArray getReportsArr() {
        try {
            if (!this.getReportPayloadObj().isNull("incidents")) {
                return this.getReportPayloadObj().getJSONArray("incidents");
            }
            return new JSONArray();
        }
        catch (JSONException e) {
            this.log("JSONException", (Exception)((Object)e));
            return new JSONArray();
        }
    }

    public List<Report> getReportList(Context context) {
        this.log("Save report");
        if (this.processingResult) {
            ArrayList<Report> listReport = new ArrayList<Report>();
            JSONArray reportsArr = this.getReportsArr();
            int id2 = 0;
            if (reportsArr != null && reportsArr.length() > 0) {
                for (int i = 0; i < reportsArr.length(); ++i) {
                    Report report = new Report();
                    try {
                        if (!reportsArr.getJSONObject(i).isNull("incident")) {
                            id2 = reportsArr.getJSONObject(i).getJSONObject("incident").getInt("incidentid");
                        }
                        report.setReportId(id2);
                        report.setTitle(reportsArr.getJSONObject(i).getJSONObject("incident").getString("incidenttitle"));
                        report.setDescription(reportsArr.getJSONObject(i).getJSONObject("incident").getString("incidentdescription"));
                        report.setReportDate(reportsArr.getJSONObject(i).getJSONObject("incident").getString("incidentdate"));
                        report.setMode(reportsArr.getJSONObject(i).getJSONObject("incident").getString("incidentmode"));
                        report.setVerified(reportsArr.getJSONObject(i).getJSONObject("incident").getString("incidentverified"));
                        report.setLocationName(reportsArr.getJSONObject(i).getJSONObject("incident").getString("locationname"));
                        report.setLatitude(reportsArr.getJSONObject(i).getJSONObject("incident").getString("locationlatitude"));
                        report.setLongitude(reportsArr.getJSONObject(i).getJSONObject("incident").getString("locationlongitude"));
                        if (!reportsArr.getJSONObject(i).isNull("categories")) {
                            JSONArray catsArr = reportsArr.getJSONObject(i).getJSONArray("categories");
                            for (int j = 0; j < catsArr.length(); ++j) {
                                try {
                                    this.saveCategories(catsArr.getJSONObject(j).getJSONObject("category").getInt("id"), id2);
                                    continue;
                                }
                                catch (JSONException ex) {
                                    this.log("JSONException", (Exception)((Object)ex));
                                }
                            }
                        }
                        if (!reportsArr.getJSONObject(i).isNull("media")) {
                            JSONArray mediaArr = reportsArr.getJSONObject(i).getJSONArray("media");
                            for (int w = 0; w < mediaArr.length(); ++w) {
                                try {
                                    if (mediaArr.getJSONObject(w).isNull("id")) continue;
                                    if (mediaArr.getJSONObject(w).getInt("type") == 1 && !mediaArr.getJSONObject(w).isNull("link")) {
                                        String fileName = Util.getDateTime() + ".jpg";
                                        this.saveMedia(mediaArr.getJSONObject(w).getInt("id"), id2, mediaArr.getJSONObject(w).getInt("type"), fileName);
                                        if (mediaArr.getJSONObject(w).getString("link").startsWith("http")) {
                                            this.saveImages(mediaArr.getJSONObject(w).getString("link"), fileName, context);
                                            continue;
                                        }
                                        String link = Preferences.domain + "/media/uploads/" + mediaArr.getJSONObject(w).getString("link");
                                        this.saveImages(link, fileName, context);
                                        continue;
                                    }
                                    this.saveMedia(mediaArr.getJSONObject(w).getInt("id"), id2, mediaArr.getJSONObject(w).getInt("type"), mediaArr.getJSONObject(w).getString("link"));
                                    continue;
                                }
                                catch (JSONException exc) {
                                    this.log("JSONException", (Exception)((Object)exc));
                                }
                            }
                        }
                    }
                    catch (JSONException e) {
                        this.log("JSONException", (Exception)((Object)e));
                        this.processingResult = false;
                        return null;
                    }
                    listReport.add(report);
                }
                return listReport;
            }
        }
        return null;
    }

    public boolean saveReports(Context context) {
        List<Report> reports = this.getReportList(context);
        if (reports != null) {
            return Database.mReportDao.addReport(reports);
        }
        return false;
    }

    private void saveCategories(int categoryId, int reportId) {
        ReportCategory reportCategory = new ReportCategory();
        reportCategory.setCategoryId(categoryId);
        reportCategory.setReportId(reportId);
        ArrayList<ReportCategory> reportCategories = new ArrayList<ReportCategory>();
        reportCategories.add(reportCategory);
        Database.mReportCategoryDao.addReportCategories(reportCategories);
    }

    private void saveMedia(int mediaId, int reportId, int type, String link) {
        this.log("downloading... " + link + " ReportId: " + reportId);
        Media media = new Media();
        media.setMediaId(mediaId);
        media.setReportId(reportId);
        media.setType(type);
        media.setLink(link);
        ArrayList<Media> sMedia = new ArrayList<Media>();
        sMedia.add(media);
        Database.mMediaDao.addMedia(sMedia);
    }

    private void saveImages(String linkUrl, String fileName, Context context) {
        if (!TextUtils.isEmpty((CharSequence)linkUrl)) {
            ImageManager.downloadImage(linkUrl, fileName, context);
        }
    }

    private void log(String message) {
        if (MainApplication.LOGGING_MODE) {
            Log.i((String)this.getClass().getName(), (String)message);
        }
    }

    private void log(String message, Exception ex) {
        if (MainApplication.LOGGING_MODE) {
            Log.e((String)this.getClass().getName(), (String)message, (Throwable)ex);
        }
    }
}

