/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.location.Criteria;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.widget.Toast;
import com.ushahidi.android.app.MainApplication;
import com.ushahidi.android.app.net.MainGeocoder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    private static JSONObject jsonObject;
    private static NetworkInfo networkInfo;
    private static Random random;
    private static final String VALID_EMAIL_PATTERN = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static Pattern pattern;
    private static Matcher matcher;
    public static final int IO_BUFFER_SIZE = 8192;

    public static String joinString(String first, String second) {
        return first.concat(second);
    }

    public static int toInt(String value) {
        return Integer.parseInt(value);
    }

    public static String capitalizeString(String text) {
        if (text.length() == 0) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
    }

    public static String implode(Vector<String> text) {
        String implode = "";
        int i = 0;
        for (String value : text) {
            implode = implode + (i == text.size() - 1 ? value : value + ",");
            ++i;
        }
        return implode;
    }

    public static boolean isConnected(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        networkInfo = connectivity.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected() && networkInfo.isAvailable();
    }

    public static boolean isAirplaneModeOn(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    public static String truncateText(String text) {
        if (text.length() > 30) {
            return text.substring(0, 25).trim() + "";
        }
        return text;
    }

    public static String limitString(String value, int length) {
        StringBuilder buf = new StringBuilder(value);
        if (buf.length() > length) {
            buf.setLength(length);
            buf.append(" ...");
        }
        return buf.toString();
    }

    public static String formatDate(String dateFormat, String date, String toFormat) {
        return Util.formatDate(dateFormat, date, toFormat, null, null);
    }

    public static String formatDate(String dateFormat, String date, String toFormat, Locale fromLocale, Locale toLocale) {
        String formatted = "";
        SimpleDateFormat formatter = fromLocale == null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, fromLocale);
        try {
            Date dateStr = formatter.parse(date);
            formatted = formatter.format(dateStr);
            Date formatDate = formatter.parse(formatted);
            formatter = toLocale == null ? new SimpleDateFormat(toFormat) : new SimpleDateFormat(toFormat, toLocale);
            formatted = formatter.format(formatDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return formatted;
    }

    public static void appendLog(String text) {
        File logFile = new File(Environment.getExternalStorageDirectory(), "ush_log.txt");
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            BufferedWriter buf = new BufferedWriter(new FileWriter(logFile, true));
            buf.append(text);
            buf.newLine();
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getFromLocation(double latitude, double longitude, Context context) {
        String json_data = "";
        int status = 0;
        try {
            if (!Util.isConnected(context)) {
                return "";
            }
            MainGeocoder geoCoder = new MainGeocoder(context);
            json_data = geoCoder.reverseGeocode(latitude, longitude);
            if (json_data != null) {
                jsonObject = new JSONObject(json_data);
                status = jsonObject.getJSONObject("Status").getInt("code");
                if (status == 200) {
                    JSONArray jsonArray = jsonObject.getJSONArray("Placemark");
                    return jsonArray.getJSONObject(0).getJSONObject("AddressDetails").getJSONObject("Country").getJSONObject("AdministrativeArea").getJSONObject("Locality").getString("LocalityName");
                }
                return "";
            }
        }
        catch (JSONException e) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
        return "";
    }

    public static void showToast(Context context, int i) {
        int duration = 1;
        Toast.makeText((Context)context, (int)i, (int)duration).show();
    }

    public static boolean validateEmail(String emailAddress) {
        if (!TextUtils.isEmpty((CharSequence)emailAddress)) {
            pattern = Pattern.compile(VALID_EMAIL_PATTERN);
            matcher = pattern.matcher(emailAddress);
            return matcher.matches();
        }
        return false;
    }

    public static void rmDir(String path) {
        File dir = new File(path);
        if (dir.isDirectory()) {
            String[] children = dir.list();
            Log.d((String)"Directory", (String)("dir.list returned some files" + children.length + "--"));
            for (int i = 0; i < children.length; ++i) {
                File temp = new File(dir, children[i]);
                if (temp.isDirectory()) {
                    Util.rmDir(temp.getName());
                    continue;
                }
                temp.delete();
            }
            dir.delete();
        } else {
            Log.d((String)"Directory", (String)("This is not a directory" + path));
        }
    }

    public static String capitalize(String text) {
        if (text != null) {
            String[] words = text.split("\\s");
            String capWord = "";
            int n = 0;
            String[] stringArray = words;
            int n2 = stringArray.length;
            if (n < n2) {
                String word = stringArray[n];
                capWord = capWord + Util.capitalizeString(word) + " ";
                return capWord;
            }
        }
        return "";
    }

    public static Criteria createCoarseCriteria() {
        Criteria c = new Criteria();
        c.setAccuracy(2);
        c.setAltitudeRequired(false);
        c.setBearingRequired(false);
        c.setSpeedRequired(false);
        c.setCostAllowed(true);
        c.setPowerRequirement(3);
        return c;
    }

    public static Criteria createFineCriteria() {
        Criteria c = new Criteria();
        c.setAccuracy(1);
        c.setAltitudeRequired(false);
        c.setBearingRequired(false);
        c.setSpeedRequired(false);
        c.setCostAllowed(true);
        c.setPowerRequirement(3);
        return c;
    }

    public static String generateFilename(boolean thumbnail) {
        if (thumbnail) {
            return Util.randomString() + "_t.jpg";
        }
        return Util.randomString() + ".jpg";
    }

    public static String randomString() {
        return Long.toString(Math.abs(random.nextLong()), 10);
    }

    public static boolean deviceHasCamera(Context context) {
        PackageManager pm = context.getPackageManager();
        return pm.hasSystemFeature("android.hardware.camera");
    }

    public static boolean deviceCameraHasAutofocus(Context context) {
        PackageManager pm = context.getPackageManager();
        return pm.hasSystemFeature("android.hardware.camera.autofocus");
    }

    public static boolean isHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean isHoneycombTablet(Context context) {
        return Util.isHoneycomb() && Util.isTablet(context);
    }

    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        return display.getWidth();
    }

    public static String getDateTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(new Date());
    }

    public static String IMEI(Context context) {
        TelephonyManager TelephonyMgr = (TelephonyManager)context.getSystemService("phone");
        return TelephonyMgr.getDeviceId();
    }

    @SuppressLint(value={"NewApi"})
    public static int getBitmapSize(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    @SuppressLint(value={"NewApi"})
    public static boolean isExternalStorageRemovable() {
        if (Build.VERSION.SDK_INT >= 9) {
            return Environment.isExternalStorageRemovable();
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public static File getExternalCacheDir(Context context) {
        if (Util.hasExternalCacheDir()) {
            return context.getExternalCacheDir();
        }
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
        return new File(Environment.getExternalStorageDirectory().getPath() + cacheDir);
    }

    @SuppressLint(value={"NewApi"})
    public static long getUsableSpace(File path) {
        if (Build.VERSION.SDK_INT >= 9) {
            return path.getUsableSpace();
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }

    public static int getMemoryClass(Context context) {
        return ((ActivityManager)context.getSystemService("activity")).getMemoryClass();
    }

    public static boolean hasExternalCacheDir() {
        return Build.VERSION.SDK_INT >= 8;
    }

    public void log(String message) {
        if (MainApplication.LOGGING_MODE) {
            Log.i((String)this.getClass().getName(), (String)message);
        }
    }

    public void log(String format, Object ... args) {
        if (MainApplication.LOGGING_MODE) {
            Log.i((String)this.getClass().getName(), (String)String.format(format, args));
        }
    }

    public void log(String message, Exception ex) {
        if (MainApplication.LOGGING_MODE) {
            Log.e((String)this.getClass().getName(), (String)message, (Throwable)ex);
        }
    }

    static {
        random = new Random();
    }
}

