/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.views;

import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.entities.Map;
import com.ushahidi.android.app.models.ListMapModel;
import com.ushahidi.android.app.util.ApiUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class AddMapView {
    private EditText mMapName;
    private EditText mMapDescription;
    private EditText mMapUrl;
    private int mMapId;
    private ListMapModel mapModel = new ListMapModel();

    public AddMapView(View dialogViews) {
        this.mMapName = (EditText)dialogViews.findViewById(R.id.map_name);
        this.mMapDescription = (EditText)dialogViews.findViewById(R.id.map_description);
        this.mMapUrl = (EditText)dialogViews.findViewById(R.id.map_url);
        this.mMapUrl.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (TextUtils.isEmpty((CharSequence)AddMapView.this.getMapUrl())) {
                    AddMapView.this.setMapUrl("http://");
                }
                return false;
            }
        });
    }

    public void setMapName(String mapName) {
        if (!TextUtils.isEmpty((CharSequence)mapName)) {
            this.mMapName.setText((CharSequence)mapName);
        }
    }

    public void setMapId(int mapId) {
        this.mMapId = mapId;
    }

    public void setMapDescription(String mapDescription) {
        this.mMapDescription.setText((CharSequence)mapDescription);
    }

    public void setMapUrl(String mapUrl) {
        if (!TextUtils.isEmpty((CharSequence)mapUrl)) {
            this.mMapUrl.setText((CharSequence)mapUrl);
        }
    }

    public int getMapId() {
        return this.mMapId;
    }

    public String getMapName() {
        return this.mMapName.getText().toString();
    }

    public String getMapDescription() {
        return this.mMapDescription.getText().toString();
    }

    public String getMapUrl() {
        return this.mMapUrl.getText().toString();
    }

    public boolean addMapDetails() {
        if (ApiUtils.validateUshahidiInstance(this.getMapUrl()) && !TextUtils.isEmpty((CharSequence)this.getMapName())) {
            Map map = new Map();
            map.setMapId(0);
            map.setCatId(0);
            map.setActive("0");
            map.setLat("0.0");
            map.setLon("0.0");
            map.setName(this.getMapName());
            map.setDesc(this.getMapDescription());
            map.setUrl(this.getMapUrl());
            map.setDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            if (TextUtils.isEmpty((CharSequence)this.getMapDescription())) {
                map.setDesc(this.getMapName());
            }
            ArrayList<Map> maps = new ArrayList<Map>();
            maps.add(map);
            return this.mapModel.addMap(maps);
        }
        return false;
    }

    public boolean updateMapDetails() {
        if (!TextUtils.isEmpty((CharSequence)this.getMapName())) {
            if (!TextUtils.isEmpty((CharSequence)this.getMapDescription())) {
                return this.mapModel.updateMap(this.getMapId(), this.getMapName(), this.getMapDescription(), this.getMapUrl());
            }
            return this.mapModel.updateMap(this.getMapId(), this.getMapName(), this.getMapName(), this.getMapUrl());
        }
        return false;
    }
}

