/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.maps.OverlayItem;
import com.ushahidi.android.app.R;

public class BalloonOverlayView<Item extends OverlayItem>
extends FrameLayout {
    private LinearLayout layout;
    private TextView title;
    private TextView snippet;

    public BalloonOverlayView(Context context, int balloonBottomOffset) {
        super(context);
        this.setPadding(10, 0, 10, balloonBottomOffset);
        this.layout = new LimitLinearLayout(context);
        this.layout.setVisibility(0);
        this.setupView(context, (ViewGroup)this.layout);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 0;
        this.addView((View)this.layout, (ViewGroup.LayoutParams)params);
    }

    protected void setupView(Context context, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View v = inflater.inflate(R.layout.balloon_overlay, parent);
        this.title = (TextView)v.findViewById(R.id.balloon_item_title);
        this.snippet = (TextView)v.findViewById(R.id.balloon_item_snippet);
    }

    public void setData(Item item) {
        this.layout.setVisibility(0);
        this.setBalloonData(item, (ViewGroup)this.layout);
    }

    protected void setBalloonData(Item item, ViewGroup parent) {
        if (item.getTitle() != null) {
            this.title.setVisibility(0);
            this.title.setText((CharSequence)item.getTitle());
        } else {
            this.title.setText((CharSequence)"");
            this.title.setVisibility(8);
        }
        if (item.getSnippet() != null) {
            this.snippet.setVisibility(0);
            this.snippet.setText((CharSequence)item.getSnippet());
        } else {
            this.snippet.setText((CharSequence)"");
            this.snippet.setVisibility(8);
        }
    }

    private class LimitLinearLayout
    extends LinearLayout {
        private static final int MAX_WIDTH_DP = 280;
        final float SCALE;

        public LimitLinearLayout(Context context) {
            super(context);
            this.SCALE = this.getContext().getResources().getDisplayMetrics().density;
        }

        public LimitLinearLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.SCALE = this.getContext().getResources().getDisplayMetrics().density;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int adjustedMaxWidth = (int)(280.0f * this.SCALE + 0.5f);
            int adjustedWidth = Math.min(measuredWidth, adjustedMaxWidth);
            int adjustedWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)adjustedWidth, (int)mode);
            super.onMeasure(adjustedWidthMeasureSpec, heightMeasureSpec);
        }
    }
}

