/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.views;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.maps.OverlayItem;
import com.ushahidi.android.app.CheckinMapOverlayItem;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.ui.phone.ViewCheckinActivity;
import com.ushahidi.android.app.util.ImageViewWorker;
import com.ushahidi.android.app.views.BalloonOverlayView;

public class CheckinMapBallonOverlayView<Item extends OverlayItem>
extends BalloonOverlayView<CheckinMapOverlayItem> {
    private TextView title;
    private TextView snippet;
    private static TextView readMore;
    private ImageView image;
    private static Activity mActivity;

    public CheckinMapBallonOverlayView(Context context, int balloonBottomOffset, Activity activity) {
        super(context, balloonBottomOffset);
        mActivity = activity;
    }

    @Override
    protected void setupView(Context context, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View v = inflater.inflate(R.layout.map_balloon_overlay, parent);
        this.title = (TextView)v.findViewById(R.id.balloon_item_title);
        this.snippet = (TextView)v.findViewById(R.id.balloon_item_snippet);
        readMore = (TextView)v.findViewById(R.id.balloon_item_readmore);
        this.image = (ImageView)v.findViewById(R.id.balloon_item_image);
    }

    public static void viewCheckins(final int id2, final int filterUserId) {
        CheckinMapBallonOverlayView.launchViewCheckin(id2, filterUserId);
        readMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CheckinMapBallonOverlayView.launchViewCheckin(id2, filterUserId);
            }
        });
    }

    @Override
    protected void setBalloonData(CheckinMapOverlayItem item, ViewGroup parent) {
        this.title.setText((CharSequence)item.getTitle());
        this.snippet.setText((CharSequence)item.getSnippet());
        if (item.getImage() == null) {
            this.image.setImageResource(R.drawable.report_icon);
        } else {
            this.getPhoto(item.getImage(), this.image);
        }
    }

    private static void launchViewCheckin(int position, int filterUserId) {
        Intent i = new Intent((Context)mActivity, ViewCheckinActivity.class);
        i.putExtra("id", position);
        if (filterUserId > 0) {
            i.putExtra("userid", filterUserId);
        } else {
            i.putExtra("userid", 0);
        }
        mActivity.startActivityForResult(i, 0);
        mActivity.overridePendingTransition(R.anim.home_enter, R.anim.home_exit);
    }

    private void getPhoto(String fileName, ImageView imageView) {
        ImageViewWorker imageWorker = new ImageViewWorker((Context)mActivity);
        imageWorker.setImageFadeIn(true);
        imageWorker.loadImage(fileName, imageView, true, 0);
    }
}

