/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.views;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.Toast;
import android.widget.ViewAnimator;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.views.View;

public class ReportVideoView
extends View {
    public ViewAnimator viewAnimator;
    public WebView webView;
    public Context context;
    private ProgressBar loadingSpinner;
    public String url;
    private static boolean CLEAR_CACHE_ON_LOAD = false;
    private WebViewClient webClient = new WebViewClient(){

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            ReportVideoView.this.loadingSpinner.setVisibility(0);
            ReportVideoView.this.webView.setVisibility(4);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            ReportVideoView.this.loadingSpinner.setVisibility(8);
            ReportVideoView.this.webView.setVisibility(0);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            Toast.makeText((Context)view.getContext(), (CharSequence)("Error " + errorCode + ": " + description), (int)1).show();
            super.onReceivedError(view, errorCode, description, failingUrl);
        }
    };

    public ReportVideoView(Activity activity) {
        super(activity);
        this.context = activity;
        this.viewAnimator = (ViewAnimator)activity.findViewById(R.id.videoViewAnimator);
        this.webView = (WebView)activity.findViewById(R.id.videoWebView);
        this.loadingSpinner = (ProgressBar)activity.findViewById(R.id.loading_spinner);
    }

    public void goNext(String url) {
        Animation out = AnimationUtils.loadAnimation((Context)this.context, (int)17432579);
        Animation in = AnimationUtils.loadAnimation((Context)this.context, (int)17432578);
        this.viewAnimator.setInAnimation(in);
        this.viewAnimator.setOutAnimation(out);
        this.url = url;
        this.setWebView();
    }

    public void goPrevious(String url) {
        Animation out = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.fade_in);
        Animation in = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.fade_out);
        this.viewAnimator.setInAnimation(in);
        this.viewAnimator.setOutAnimation(out);
        this.url = url;
        this.setWebView();
    }

    public void setWebView() {
        WebSettings settings = this.webView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setLightTouchEnabled(true);
        this.webView.setWebViewClient(this.webClient);
        this.webView.post(new Runnable(){

            @Override
            public void run() {
                if (CLEAR_CACHE_ON_LOAD) {
                    ReportVideoView.this.webView.clearCache(true);
                }
                ReportVideoView.this.webView.loadUrl(ReportVideoView.this.url);
            }
        });
    }
}

