/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.views;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.google.android.maps.MapView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.ListCommentAdapter;
import com.ushahidi.android.app.adapters.ListPhotoAdapter;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.ListPhotoModel;
import com.ushahidi.android.app.util.ImageViewWorker;
import com.ushahidi.android.app.views.View;
import java.util.List;

public class ViewCheckinView
extends View {
    public TextView name;
    public TextView message;
    public TextView date;
    public ViewAnimator viewCheckinRoot;
    public LayoutInflater inflater;
    public ListView listComments;
    public TextView listPhotosEmptyView;
    private TextView listCommentEmptyView;
    public ListPhotoAdapter photoAdapter;
    public ListCommentAdapter commentAdapter;
    public MapView mapView;
    private Context context;
    public ImageView photo;
    public TextView total;

    public ViewCheckinView(Activity activity) {
        super(activity);
        this.context = activity;
        this.viewCheckinRoot = (ViewAnimator)activity.findViewById(R.id.view_checkin_root);
        this.mapView = (MapView)activity.findViewById(R.id.checkin_loc_map);
        this.name = (TextView)activity.findViewById(R.id.checkin_title);
        this.message = (TextView)activity.findViewById(R.id.checkin_description);
        this.date = (TextView)activity.findViewById(R.id.checkin_date);
        this.photo = (ImageView)activity.findViewById(R.id.list_report_photo);
        this.total = (TextView)activity.findViewById(R.id.photo_total);
        this.listPhotosEmptyView = (TextView)activity.findViewById(R.id.checkin_empty_photo_list);
        this.photoAdapter = new ListPhotoAdapter((Context)activity);
        this.commentAdapter = new ListCommentAdapter(this.context);
        this.listComments = (ListView)activity.findViewById(R.id.list_comments);
        this.listCommentEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_comment);
        if (this.listCommentEmptyView != null) {
            this.listComments.setEmptyView((android.view.View)this.listCommentEmptyView);
        }
        this.inflater = (LayoutInflater)activity.getSystemService("layout_inflater");
    }

    public android.view.View filterCheckin() {
        android.view.View v = this.inflater.inflate(R.layout.list_checkin_header, null);
        return v;
    }

    public void setTitle(String title) {
        this.name.setText((CharSequence)title);
    }

    public String getTitle() {
        return this.getTitle().toString();
    }

    public void setDate(String date) {
        this.date.setText((CharSequence)date);
    }

    public String getDate() {
        return this.date.getText().toString();
    }

    public void setBody(String body) {
        this.message.setText((CharSequence)body);
    }

    public String getBody() {
        return this.message.getText().toString();
    }

    public void setListPhotos(int checkinId) {
        if (this.photo != null) {
            ListPhotoModel mListPhotoModel = new ListPhotoModel();
            boolean loaded = mListPhotoModel.loadCheckinPhoto(checkinId);
            int totalPhotos = mListPhotoModel.totalReportPhoto();
            if (loaded) {
                List<Photo> items = mListPhotoModel.getPhotos();
                if (items.size() > 0) {
                    this.getPhoto(items.get(0).getPhoto(), this.photo);
                    this.total.setText((CharSequence)this.context.getResources().getQuantityString(R.plurals.no_of_images, totalPhotos, new Object[]{totalPhotos}));
                } else {
                    this.photo.setVisibility(8);
                    this.total.setVisibility(8);
                    this.listPhotosEmptyView.setVisibility(0);
                }
            }
        }
    }

    public void setListComments(int checkinId) {
        if (this.listComments != null) {
            this.commentAdapter.refreshCheckinComment(checkinId);
            this.listComments.setAdapter((ListAdapter)this.commentAdapter);
        }
    }

    public ListView getListComments() {
        return this.listComments;
    }

    public ImageView getListPhotos() {
        return this.photo;
    }

    public void goNext() {
        Animation in = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.slide_right_in);
        this.viewCheckinRoot.startAnimation(in);
    }

    public void goPrevious() {
        Animation out = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.slide_left_in);
        this.viewCheckinRoot.startAnimation(out);
    }

    public void getPhoto(String fileName, ImageView imageView) {
        ImageViewWorker imageWorker = new ImageViewWorker(this.context);
        imageWorker.setImageFadeIn(true);
        imageWorker.loadImage(fileName, imageView, true, 0);
    }
}

