/*
 * Decompiled with CFR 0.152.
 */
package com.ushahidi.android.app.views;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.google.android.maps.MapView;
import com.ushahidi.android.app.R;
import com.ushahidi.android.app.adapters.ListCommentAdapter;
import com.ushahidi.android.app.adapters.ListNewsAdapter;
import com.ushahidi.android.app.adapters.ListPhotoAdapter;
import com.ushahidi.android.app.adapters.ListVideoAdapter;
import com.ushahidi.android.app.entities.Photo;
import com.ushahidi.android.app.models.ListPhotoModel;
import com.ushahidi.android.app.util.ImageViewWorker;
import com.ushahidi.android.app.views.View;
import java.util.List;

public class ViewReportView
extends View {
    private TextView title;
    private TextView body;
    private TextView date;
    private TextView location;
    private TextView category;
    private TextView status;
    private TextView listNewsEmptyView;
    private TextView listPhotosEmptyView;
    private TextView listVideoEmptyView;
    private TextView listCommentEmptyView;
    public MapView mapView;
    private ListView listNews;
    private ListView listPhotos;
    private ListView listVideos;
    private ListView listComments;
    private Context context;
    private ViewAnimator viewReportRoot;
    public ListPhotoAdapter photoAdapter;
    public ListNewsAdapter newsAdapter;
    public ListVideoAdapter videoAdapter;
    public ListCommentAdapter commentAdapter;
    private LayoutInflater inflater;
    public ImageView photo;
    public TextView total;

    public ViewReportView(Activity activity) {
        super(activity);
        this.context = activity;
        this.inflater = (LayoutInflater)activity.getSystemService("layout_inflater");
        this.viewReportRoot = (ViewAnimator)activity.findViewById(R.id.view_report_root);
        this.mapView = (MapView)activity.findViewById(R.id.loc_map);
        this.title = (TextView)activity.findViewById(R.id.title);
        this.category = (TextView)activity.findViewById(R.id.category);
        this.date = (TextView)activity.findViewById(R.id.date);
        this.location = (TextView)activity.findViewById(R.id.location);
        this.body = (TextView)activity.findViewById(R.id.desc);
        this.status = (TextView)activity.findViewById(R.id.status);
        this.listNews = (ListView)activity.findViewById(R.id.list_news);
        this.photoAdapter = new ListPhotoAdapter((Context)activity);
        this.newsAdapter = new ListNewsAdapter((Context)activity);
        this.videoAdapter = new ListVideoAdapter((Context)activity);
        this.commentAdapter = new ListCommentAdapter((Context)activity);
        this.dialog.setMessage((CharSequence)activity.getResources().getString(R.string.please_wait));
        this.listNewsEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_news);
        if (this.listNewsEmptyView != null) {
            this.listNews.setEmptyView((android.view.View)this.listNewsEmptyView);
        }
        this.photo = (ImageView)activity.findViewById(R.id.list_report_photo);
        this.total = (TextView)activity.findViewById(R.id.photo_total);
        this.listPhotosEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_photos);
        this.listVideos = (ListView)activity.findViewById(R.id.list_video);
        this.listVideoEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_video);
        if (this.listVideoEmptyView != null) {
            this.listVideos.setEmptyView((android.view.View)this.listVideoEmptyView);
        }
        this.listComments = (ListView)activity.findViewById(R.id.list_comments);
        this.listCommentEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_comment);
        if (this.listCommentEmptyView != null) {
            this.listComments.setEmptyView((android.view.View)this.listCommentEmptyView);
        }
    }

    public ViewReportView(ViewGroup activity, Context context) {
        super((android.view.View)activity);
        this.context = context;
        this.mapView = (MapView)activity.findViewById(R.id.loc_map);
        this.title = (TextView)activity.findViewById(R.id.title);
        this.category = (TextView)activity.findViewById(R.id.category);
        this.date = (TextView)activity.findViewById(R.id.date);
        this.location = (TextView)activity.findViewById(R.id.location);
        this.body = (TextView)activity.findViewById(R.id.desc);
        this.status = (TextView)activity.findViewById(R.id.status);
        this.listNews = (ListView)activity.findViewById(R.id.list_news);
        this.listNewsEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_news);
        if (this.listNewsEmptyView != null) {
            this.listNews.setEmptyView((android.view.View)this.listNewsEmptyView);
        }
        this.listPhotosEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_photos);
        if (this.listPhotosEmptyView != null) {
            this.listPhotos.setEmptyView((android.view.View)this.listPhotosEmptyView);
        }
        this.listVideos = (ListView)activity.findViewById(R.id.list_video);
        this.listVideoEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_video);
        if (this.listVideoEmptyView != null) {
            this.listVideos.setEmptyView((android.view.View)this.listVideoEmptyView);
        }
        this.listComments = (ListView)activity.findViewById(R.id.list_comments);
        this.listCommentEmptyView = (TextView)activity.findViewById(R.id.empty_list_for_comment);
        if (this.listCommentEmptyView != null) {
            this.listComments.setEmptyView((android.view.View)this.listCommentEmptyView);
        }
    }

    public android.view.View filterReport() {
        android.view.View v = this.inflater.inflate(R.layout.list_report_header, null);
        return v;
    }

    public void setTitle(String title) {
        this.title.setText((CharSequence)title);
    }

    public String getTitle() {
        return this.getTitle().toString();
    }

    public void setCategory(String category) {
        this.category.setText((CharSequence)category);
    }

    public String getCategory() {
        return this.category.getText().toString();
    }

    public void setDate(String date) {
        this.date.setText((CharSequence)date);
    }

    public String getDate() {
        return this.date.getText().toString();
    }

    public void setLocation(String location) {
        this.location.setText((CharSequence)location);
    }

    public String getLocation() {
        return this.location.getText().toString();
    }

    public void setBody(String body) {
        this.body.setText((CharSequence)body);
    }

    public String getBody() {
        return this.body.getText().toString();
    }

    public void setStatus(String status) {
        String s = status == this.context.getString(R.string.verified) ? this.context.getString(R.string.yes) : this.context.getString(R.string.no);
        this.status.setText((CharSequence)s);
    }

    public String getStatus() {
        return this.status.getText().toString();
    }

    public MapView getMapView() {
        return this.mapView;
    }

    public void setListNews(int reportId) {
        if (this.listNews != null) {
            ListNewsAdapter adapter = new ListNewsAdapter(this.context);
            adapter.refresh(reportId);
            this.listNews.setAdapter((ListAdapter)adapter);
        }
    }

    public ListView getListNews() {
        return this.listNews;
    }

    public void setListPhotos(int reportId) {
        if (this.photo != null) {
            ListPhotoModel mListPhotoModel = new ListPhotoModel();
            boolean loaded = mListPhotoModel.load(reportId);
            int totalPhotos = mListPhotoModel.totalReportPhoto();
            if (loaded) {
                List<Photo> items = mListPhotoModel.getPhotos();
                if (items.size() > 0) {
                    this.getPhoto(items.get(0).getPhoto(), this.photo);
                    this.total.setText((CharSequence)this.context.getResources().getQuantityString(R.plurals.no_of_images, totalPhotos, new Object[]{totalPhotos}));
                } else {
                    this.photo.setVisibility(8);
                    this.total.setVisibility(8);
                    this.listPhotosEmptyView.setVisibility(0);
                }
            }
        }
    }

    public ImageView getListPhotos() {
        return this.photo;
    }

    public void setListComments(int reportId) {
        if (this.listComments != null) {
            this.commentAdapter.refresh(reportId);
            this.listComments.setAdapter((ListAdapter)this.commentAdapter);
        }
    }

    public ListView getListComments() {
        return this.listComments;
    }

    public void setListVideos(int reportId) {
        if (this.listVideos != null) {
            ListVideoAdapter adapter = new ListVideoAdapter(this.context);
            adapter.refresh(reportId);
            this.listVideos.setAdapter((ListAdapter)adapter);
        }
    }

    public ListView getListVideos() {
        return this.listVideos;
    }

    public void goNext() {
        Animation in = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.slide_right_in);
        this.viewReportRoot.startAnimation(in);
    }

    public void goPrevious() {
        Animation out = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.slide_left_in);
        this.viewReportRoot.startAnimation(out);
    }

    public void getPhoto(String fileName, ImageView imageView) {
        ImageViewWorker imageWorker = new ImageViewWorker(this.context);
        imageWorker.setImageFadeIn(true);
        imageWorker.loadImage(fileName, imageView, true, 0);
    }
}

