/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.MathUtils;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.ViewOffsetBehavior;
import android.support.design.widget.ViewUtils;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v4.widget.ScrollerCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
public class AppBarLayout
extends LinearLayout {
    private static final int INVALID_SCROLL_RANGE = -1;
    private int mTotalScrollRange = -1;
    private int mDownPreScrollRange = -1;
    private int mDownScrollRange = -1;
    boolean mHaveChildWithInterpolator;
    private float mTargetElevation;
    private WindowInsetsCompat mLastInsets;
    private final List<WeakReference<OnOffsetChangedListener>> mListeners;

    public AppBarLayout(Context context) {
        this(context, null);
    }

    public AppBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AppBarLayout, 0, R.style.Widget_Design_AppBarLayout);
        this.mTargetElevation = a.getDimensionPixelSize(R.styleable.AppBarLayout_elevation, 0);
        this.setBackgroundDrawable(a.getDrawable(R.styleable.AppBarLayout_android_background));
        a.recycle();
        ViewUtils.setBoundsViewOutlineProvider((View)this);
        this.mListeners = new ArrayList<WeakReference<OnOffsetChangedListener>>();
        ViewCompat.setElevation((View)this, (float)this.mTargetElevation);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                AppBarLayout.this.setWindowInsets(insets);
                return insets.consumeSystemWindowInsets();
            }
        });
    }

    public void addOnOffsetChangedListener(OnOffsetChangedListener listener) {
        int z = this.mListeners.size();
        for (int i = 0; i < z; ++i) {
            WeakReference<OnOffsetChangedListener> ref = this.mListeners.get(i);
            if (ref == null || ref.get() != listener) continue;
            return;
        }
        this.mListeners.add(new WeakReference<OnOffsetChangedListener>(listener));
    }

    public void removeOnOffsetChangedListener(OnOffsetChangedListener listener) {
        Iterator<WeakReference<OnOffsetChangedListener>> i = this.mListeners.iterator();
        while (i.hasNext()) {
            WeakReference<OnOffsetChangedListener> ref = i.next();
            OnOffsetChangedListener item = (OnOffsetChangedListener)ref.get();
            if (item != listener && item != null) continue;
            i.remove();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mTotalScrollRange = -1;
        this.mDownPreScrollRange = -1;
        this.mDownPreScrollRange = -1;
        this.mHaveChildWithInterpolator = false;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams childLp = (LayoutParams)child.getLayoutParams();
            Interpolator interpolator = childLp.getScrollInterpolator();
            if (interpolator == null) continue;
            this.mHaveChildWithInterpolator = true;
            break;
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 1) {
            throw new IllegalArgumentException("AppBarLayout is always vertical and does not support horizontal orientation");
        }
        super.setOrientation(orientation);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LinearLayout.LayoutParams) {
            return new LayoutParams((LinearLayout.LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    final boolean hasChildWithInterpolator() {
        return this.mHaveChildWithInterpolator;
    }

    public final int getTotalScrollRange() {
        if (this.mTotalScrollRange != -1) {
            return this.mTotalScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = ViewCompat.isLaidOut((View)child) ? child.getHeight() : child.getMeasuredHeight();
            int flags = lp.mScrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight;
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child);
            break;
        }
        int top = this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() : 0;
        this.mTotalScrollRange = range - top;
        return this.mTotalScrollRange;
    }

    final boolean hasScrollableChildren() {
        return this.getTotalScrollRange() != 0;
    }

    final int getUpNestedPreScrollRange() {
        return this.getTotalScrollRange();
    }

    final int getDownNestedPreScrollRange() {
        if (this.mDownPreScrollRange != -1) {
            return this.mDownPreScrollRange;
        }
        int range = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = ViewCompat.isLaidOut((View)child) ? child.getHeight() : child.getMeasuredHeight();
            int flags = lp.mScrollFlags;
            if ((flags & 5) == 5) {
                if ((flags & 8) != 0) {
                    range += ViewCompat.getMinimumHeight((View)child);
                    continue;
                }
                range += childHeight;
                continue;
            }
            if (range > 0) break;
        }
        this.mDownPreScrollRange = range;
        return this.mDownPreScrollRange;
    }

    final int getDownNestedScrollRange() {
        if (this.mDownScrollRange != -1) {
            return this.mDownScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = ViewCompat.isLaidOut((View)child) ? child.getHeight() : child.getMeasuredHeight();
            int flags = lp.mScrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight;
            if ((flags & 2) == 0) continue;
            return range - ViewCompat.getMinimumHeight((View)child);
        }
        this.mDownScrollRange = range;
        return this.mDownScrollRange;
    }

    final int getMinimumHeightForVisibleOverlappingContent() {
        int topInset = this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() : 0;
        int minHeight = ViewCompat.getMinimumHeight((View)this);
        if (minHeight != 0) {
            return minHeight * 2 + topInset;
        }
        int childCount = this.getChildCount();
        return childCount >= 1 ? ViewCompat.getMinimumHeight((View)this.getChildAt(childCount - 1)) * 2 + topInset : 0;
    }

    public void setTargetElevation(float elevation) {
        this.mTargetElevation = elevation;
    }

    public float getTargetElevation() {
        return this.mTargetElevation;
    }

    private void setWindowInsets(WindowInsetsCompat insets) {
        View child;
        this.mTotalScrollRange = -1;
        this.mLastInsets = insets;
        int z = this.getChildCount();
        for (int i = 0; i < z && !(insets = ViewCompat.dispatchApplyWindowInsets((View)(child = this.getChildAt(i)), (WindowInsetsCompat)insets)).isConsumed(); ++i) {
        }
    }

    public static class ScrollingViewBehavior
    extends ViewOffsetBehavior<View> {
        private int mOverlayTop;

        public ScrollingViewBehavior() {
        }

        public ScrollingViewBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScrollingViewBehavior_Params);
            this.mOverlayTop = a.getDimensionPixelSize(R.styleable.ScrollingViewBehavior_Params_behavior_overlapTop, 0);
            a.recycle();
        }

        @Override
        public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
            return dependency instanceof AppBarLayout;
        }

        @Override
        public boolean onMeasureChild(CoordinatorLayout parent, View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
            if (child.getLayoutParams().height == -1) {
                List<View> dependencies = parent.getDependencies(child);
                if (dependencies.isEmpty()) {
                    return false;
                }
                AppBarLayout appBar = ScrollingViewBehavior.findFirstAppBarLayout(dependencies);
                if (appBar != null && ViewCompat.isLaidOut((View)appBar)) {
                    int availableHeight;
                    if (ViewCompat.getFitsSystemWindows((View)appBar)) {
                        ViewCompat.setFitsSystemWindows((View)child, (boolean)true);
                    }
                    if ((availableHeight = View.MeasureSpec.getSize((int)parentHeightMeasureSpec)) == 0) {
                        availableHeight = parent.getHeight();
                    }
                    int height = availableHeight - appBar.getMeasuredHeight() + appBar.getTotalScrollRange();
                    int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
                    parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, heightMeasureSpec, heightUsed);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)dependency.getLayoutParams()).getBehavior();
            if (behavior instanceof Behavior) {
                int appBarOffset = ((Behavior)behavior).getTopBottomOffsetForScrollingSibling();
                int expandedMax = dependency.getHeight() - this.mOverlayTop;
                int collapsedMin = parent.getHeight() - child.getHeight();
                if (this.mOverlayTop != 0 && dependency instanceof AppBarLayout) {
                    int scrollRange = ((AppBarLayout)dependency).getTotalScrollRange();
                    this.setTopAndBottomOffset(AnimationUtils.lerp(expandedMax, collapsedMin, (float)Math.abs(appBarOffset) / (float)scrollRange));
                } else {
                    this.setTopAndBottomOffset(dependency.getHeight() - this.mOverlayTop + appBarOffset);
                }
            }
            return false;
        }

        public void setOverlayTop(int overlayTop) {
            this.mOverlayTop = overlayTop;
        }

        public int getOverlayTop() {
            return this.mOverlayTop;
        }

        private static AppBarLayout findFirstAppBarLayout(List<View> views) {
            int z = views.size();
            for (int i = 0; i < z; ++i) {
                View view = views.get(i);
                if (!(view instanceof AppBarLayout)) continue;
                return (AppBarLayout)view;
            }
            return null;
        }
    }

    public static class Behavior
    extends ViewOffsetBehavior<AppBarLayout> {
        private static final int INVALID_POSITION = -1;
        private int mOffsetDelta;
        private boolean mSkipNestedPreScroll;
        private Runnable mFlingRunnable;
        private ScrollerCompat mScroller;
        private ValueAnimatorCompat mAnimator;
        private int mOffsetToChildIndexOnLayout = -1;
        private boolean mOffsetToChildIndexOnLayoutIsMinHeight;
        private float mOffsetToChildIndexOnLayoutPerc;

        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        @Override
        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
            boolean started;
            boolean bl = started = (nestedScrollAxes & 2) != 0 && child.hasScrollableChildren() && coordinatorLayout.getHeight() - target.getHeight() <= child.getHeight();
            if (started && this.mAnimator != null) {
                this.mAnimator.cancel();
            }
            return started;
        }

        @Override
        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dx, int dy, int[] consumed) {
            if (dy != 0 && !this.mSkipNestedPreScroll) {
                int max;
                int min;
                if (dy < 0) {
                    min = -child.getTotalScrollRange();
                    max = min + child.getDownNestedPreScrollRange();
                } else {
                    min = -child.getUpNestedPreScrollRange();
                    max = 0;
                }
                consumed[1] = this.scroll(coordinatorLayout, child, dy, min, max);
            }
        }

        @Override
        public void onNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            if (dyUnconsumed < 0) {
                this.scroll(coordinatorLayout, child, dyUnconsumed, -child.getDownNestedScrollRange(), 0);
                this.mSkipNestedPreScroll = true;
            } else {
                this.mSkipNestedPreScroll = false;
            }
        }

        @Override
        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target) {
            this.mSkipNestedPreScroll = false;
        }

        @Override
        public boolean onNestedFling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, float velocityX, float velocityY, boolean consumed) {
            int targetScroll;
            if (!consumed) {
                return this.fling(coordinatorLayout, child, -child.getTotalScrollRange(), 0, -velocityY);
            }
            if (velocityY < 0.0f) {
                targetScroll = -child.getTotalScrollRange() + child.getDownNestedPreScrollRange();
                if (this.getTopBottomOffsetForScrollingSibling() > targetScroll) {
                    return false;
                }
            } else {
                targetScroll = -child.getUpNestedPreScrollRange();
                if (this.getTopBottomOffsetForScrollingSibling() < targetScroll) {
                    return false;
                }
            }
            if (this.getTopBottomOffsetForScrollingSibling() != targetScroll) {
                this.animateOffsetTo(coordinatorLayout, child, targetScroll);
                return true;
            }
            return false;
        }

        private void animateOffsetTo(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, int offset) {
            if (this.mAnimator == null) {
                this.mAnimator = ViewUtils.createAnimator();
                this.mAnimator.setInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
                this.mAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                    @Override
                    public void onAnimationUpdate(ValueAnimatorCompat animator) {
                        Behavior.this.setAppBarTopBottomOffset(coordinatorLayout, child, animator.getAnimatedIntValue());
                    }
                });
            } else {
                this.mAnimator.cancel();
            }
            this.mAnimator.setIntValues(this.getTopBottomOffsetForScrollingSibling(), offset);
            this.mAnimator.start();
        }

        private boolean fling(CoordinatorLayout coordinatorLayout, AppBarLayout layout2, int minOffset, int maxOffset, float velocityY) {
            if (this.mFlingRunnable != null) {
                layout2.removeCallbacks(this.mFlingRunnable);
            }
            if (this.mScroller == null) {
                this.mScroller = ScrollerCompat.create((Context)layout2.getContext());
            }
            this.mScroller.fling(0, this.getTopBottomOffsetForScrollingSibling(), 0, Math.round(velocityY), 0, 0, minOffset, maxOffset);
            if (this.mScroller.computeScrollOffset()) {
                this.mFlingRunnable = new FlingRunnable(coordinatorLayout, layout2);
                ViewCompat.postOnAnimation((View)layout2, (Runnable)this.mFlingRunnable);
                return true;
            }
            this.mFlingRunnable = null;
            return false;
        }

        @Override
        public boolean onLayoutChild(CoordinatorLayout parent, AppBarLayout appBarLayout, int layoutDirection) {
            boolean handled = super.onLayoutChild(parent, appBarLayout, layoutDirection);
            if (this.mOffsetToChildIndexOnLayout >= 0) {
                View child = appBarLayout.getChildAt(this.mOffsetToChildIndexOnLayout);
                int offset = -child.getBottom();
                offset = this.mOffsetToChildIndexOnLayoutIsMinHeight ? (offset += ViewCompat.getMinimumHeight((View)child)) : (offset += Math.round((float)child.getHeight() * this.mOffsetToChildIndexOnLayoutPerc));
                this.setTopAndBottomOffset(offset);
                this.mOffsetToChildIndexOnLayout = -1;
            }
            this.dispatchOffsetUpdates(appBarLayout);
            return handled;
        }

        private int scroll(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int dy, int minOffset, int maxOffset) {
            return this.setAppBarTopBottomOffset(coordinatorLayout, appBarLayout, this.getTopBottomOffsetForScrollingSibling() - dy, minOffset, maxOffset);
        }

        final int setAppBarTopBottomOffset(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int newOffset) {
            return this.setAppBarTopBottomOffset(coordinatorLayout, appBarLayout, newOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        final int setAppBarTopBottomOffset(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, int newOffset, int minOffset, int maxOffset) {
            int curOffset = this.getTopBottomOffsetForScrollingSibling();
            int consumed = 0;
            if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset && curOffset != (newOffset = MathUtils.constrain(newOffset, minOffset, maxOffset))) {
                int interpolatedOffset = appBarLayout.hasChildWithInterpolator() ? this.interpolateOffset(appBarLayout, newOffset) : newOffset;
                boolean offsetChanged = this.setTopAndBottomOffset(interpolatedOffset);
                consumed = curOffset - newOffset;
                this.mOffsetDelta = newOffset - interpolatedOffset;
                if (!offsetChanged && appBarLayout.hasChildWithInterpolator()) {
                    coordinatorLayout.dispatchDependentViewsChanged((View)appBarLayout);
                }
                this.dispatchOffsetUpdates(appBarLayout);
            }
            return consumed;
        }

        private void dispatchOffsetUpdates(AppBarLayout layout2) {
            List listeners = layout2.mListeners;
            int z = listeners.size();
            for (int i = 0; i < z; ++i) {
                OnOffsetChangedListener listener;
                WeakReference ref = (WeakReference)listeners.get(i);
                OnOffsetChangedListener onOffsetChangedListener = listener = ref != null ? (OnOffsetChangedListener)ref.get() : null;
                if (listener == null) continue;
                listener.onOffsetChanged(layout2, this.getTopAndBottomOffset());
            }
        }

        private int interpolateOffset(AppBarLayout layout2, int offset) {
            int absOffset = Math.abs(offset);
            int z = layout2.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = layout2.getChildAt(i);
                LayoutParams childLp = (LayoutParams)child.getLayoutParams();
                Interpolator interpolator = childLp.getScrollInterpolator();
                if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
                if (interpolator == null) break;
                int childScrollableHeight = 0;
                int flags = childLp.getScrollFlags();
                if ((flags & 1) != 0) {
                    childScrollableHeight += child.getHeight();
                    if ((flags & 2) != 0) {
                        childScrollableHeight -= ViewCompat.getMinimumHeight((View)child);
                    }
                }
                if (childScrollableHeight <= 0) break;
                int offsetForView = absOffset - child.getTop();
                int interpolatedDiff = Math.round((float)childScrollableHeight * interpolator.getInterpolation((float)offsetForView / (float)childScrollableHeight));
                return Integer.signum(offset) * (child.getTop() + interpolatedDiff);
            }
            return offset;
        }

        final int getTopBottomOffsetForScrollingSibling() {
            return this.getTopAndBottomOffset() + this.mOffsetDelta;
        }

        @Override
        public Parcelable onSaveInstanceState(CoordinatorLayout parent, AppBarLayout appBarLayout) {
            Parcelable superState = super.onSaveInstanceState(parent, appBarLayout);
            int offset = this.getTopAndBottomOffset();
            int count = appBarLayout.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = appBarLayout.getChildAt(i);
                int visBottom = child.getBottom() + offset;
                if (child.getTop() + offset > 0 || visBottom < 0) continue;
                SavedState ss = new SavedState(superState);
                ss.firstVisibleChildIndex = i;
                ss.firstVisibileChildAtMinimumHeight = visBottom == ViewCompat.getMinimumHeight((View)child);
                ss.firstVisibileChildPercentageShown = (float)visBottom / (float)child.getHeight();
                return ss;
            }
            return superState;
        }

        @Override
        public void onRestoreInstanceState(CoordinatorLayout parent, AppBarLayout appBarLayout, Parcelable state) {
            if (state instanceof SavedState) {
                SavedState ss = (SavedState)state;
                super.onRestoreInstanceState(parent, appBarLayout, ss.getSuperState());
                this.mOffsetToChildIndexOnLayout = ss.firstVisibleChildIndex;
                this.mOffsetToChildIndexOnLayoutPerc = ss.firstVisibileChildPercentageShown;
                this.mOffsetToChildIndexOnLayoutIsMinHeight = ss.firstVisibileChildAtMinimumHeight;
            } else {
                super.onRestoreInstanceState(parent, appBarLayout, state);
                this.mOffsetToChildIndexOnLayout = -1;
            }
        }

        protected static class SavedState
        extends View.BaseSavedState {
            int firstVisibleChildIndex;
            float firstVisibileChildPercentageShown;
            boolean firstVisibileChildAtMinimumHeight;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

                public SavedState createFromParcel(Parcel source) {
                    return new SavedState(source);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            public SavedState(Parcel source) {
                super(source);
                this.firstVisibleChildIndex = source.readInt();
                this.firstVisibileChildPercentageShown = source.readFloat();
                this.firstVisibileChildAtMinimumHeight = source.readByte() != 0;
            }

            public SavedState(Parcelable superState) {
                super(superState);
            }

            public void writeToParcel(Parcel dest, int flags) {
                super.writeToParcel(dest, flags);
                dest.writeInt(this.firstVisibleChildIndex);
                dest.writeFloat(this.firstVisibileChildPercentageShown);
                dest.writeByte((byte)(this.firstVisibileChildAtMinimumHeight ? 1 : 0));
            }
        }

        private class FlingRunnable
        implements Runnable {
            private final CoordinatorLayout mParent;
            private final AppBarLayout mLayout;

            FlingRunnable(CoordinatorLayout parent, AppBarLayout layout2) {
                this.mParent = parent;
                this.mLayout = layout2;
            }

            @Override
            public void run() {
                if (this.mLayout != null && Behavior.this.mScroller != null && Behavior.this.mScroller.computeScrollOffset()) {
                    Behavior.this.setAppBarTopBottomOffset(this.mParent, this.mLayout, Behavior.this.mScroller.getCurrY());
                    ViewCompat.postOnAnimation((View)this.mLayout, (Runnable)this);
                }
            }
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public static final int SCROLL_FLAG_SCROLL = 1;
        public static final int SCROLL_FLAG_EXIT_UNTIL_COLLAPSED = 2;
        public static final int SCROLL_FLAG_ENTER_ALWAYS = 4;
        public static final int SCROLL_FLAG_ENTER_ALWAYS_COLLAPSED = 8;
        static final int FLAG_QUICK_RETURN = 5;
        int mScrollFlags = 1;
        Interpolator mScrollInterpolator;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.AppBarLayout_LayoutParams);
            this.mScrollFlags = a.getInt(R.styleable.AppBarLayout_LayoutParams_layout_scrollFlags, 0);
            if (a.hasValue(R.styleable.AppBarLayout_LayoutParams_layout_scrollInterpolator)) {
                int resId = a.getResourceId(R.styleable.AppBarLayout_LayoutParams_layout_scrollInterpolator, 0);
                this.mScrollInterpolator = android.view.animation.AnimationUtils.loadInterpolator((Context)c, (int)resId);
            }
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height, weight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LinearLayout.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((LinearLayout.LayoutParams)source);
            this.mScrollFlags = source.mScrollFlags;
            this.mScrollInterpolator = source.mScrollInterpolator;
        }

        public void setScrollFlags(int flags) {
            this.mScrollFlags = flags;
        }

        public int getScrollFlags() {
            return this.mScrollFlags;
        }

        public void setScrollInterpolator(Interpolator interpolator) {
            this.mScrollInterpolator = interpolator;
        }

        public Interpolator getScrollInterpolator() {
            return this.mScrollInterpolator;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ScrollFlags {
        }
    }

    public static interface OnOffsetChangedListener {
        public void onOffsetChanged(AppBarLayout var1, int var2);
    }
}

