/*
 * Decompiled with CFR 0.152.
 */
package github.ankushsachdeva.emojicon;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Spannable;
import android.util.AttributeSet;
import android.widget.EditText;
import github.ankushsachdeva.emojicon.EmojiconHandler;
import github.ankushsachdeva.emojicon.R;

public class EmojiconEditText
extends EditText {
    private int mEmojiconSize;

    public EmojiconEditText(Context context) {
        super(context);
        this.mEmojiconSize = this.getLineHeight();
    }

    public EmojiconEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public EmojiconEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Emojicon);
        this.mEmojiconSize = (int)a.getDimension(R.styleable.Emojicon_emojiconSize, (float)this.getLineHeight());
        a.recycle();
        this.setText((CharSequence)this.getText());
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        EmojiconHandler.addEmojis(this.getContext(), (Spannable)this.getText(), this.mEmojiconSize);
    }

    public void setEmojiconSize(int pixels) {
        this.mEmojiconSize = pixels;
    }
}

