/*
 * Decompiled with CFR 0.152.
 */
package github.ankushsachdeva.emojicon;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import github.ankushsachdeva.emojicon.EmojiAdapter;
import github.ankushsachdeva.emojicon.EmojiconRecents;
import github.ankushsachdeva.emojicon.EmojiconsPopup;
import github.ankushsachdeva.emojicon.R;
import github.ankushsachdeva.emojicon.emoji.Emojicon;
import github.ankushsachdeva.emojicon.emoji.People;
import java.util.Arrays;

public class EmojiconGridView {
    public View rootView;
    EmojiconsPopup mEmojiconPopup;
    EmojiconRecents mRecents;
    Emojicon[] mData;

    public EmojiconGridView(Context context, Emojicon[] emojicons, EmojiconRecents recents, EmojiconsPopup emojiconPopup) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mEmojiconPopup = emojiconPopup;
        this.rootView = inflater.inflate(R.layout.emojicon_grid, null);
        this.setRecents(recents);
        GridView gridView = (GridView)this.rootView.findViewById(R.id.Emoji_GridView);
        if (emojicons == null) {
            this.mData = People.DATA;
        } else {
            Object[] o = emojicons;
            this.mData = Arrays.asList(o).toArray(new Emojicon[o.length]);
        }
        EmojiAdapter mAdapter = new EmojiAdapter(this.rootView.getContext(), this.mData);
        mAdapter.setEmojiClickListener(new OnEmojiconClickedListener(){

            @Override
            public void onEmojiconClicked(Emojicon emojicon) {
                if (EmojiconGridView.this.mEmojiconPopup.onEmojiconClickedListener != null) {
                    EmojiconGridView.this.mEmojiconPopup.onEmojiconClickedListener.onEmojiconClicked(emojicon);
                }
                if (EmojiconGridView.this.mRecents != null) {
                    EmojiconGridView.this.mRecents.addRecentEmoji(EmojiconGridView.this.rootView.getContext(), emojicon);
                }
            }
        });
        gridView.setAdapter((ListAdapter)mAdapter);
    }

    private void setRecents(EmojiconRecents recents) {
        this.mRecents = recents;
    }

    public static interface OnEmojiconClickedListener {
        public void onEmojiconClicked(Emojicon var1);
    }
}

