/*
 * Decompiled with CFR 0.152.
 */
package github.ankushsachdeva.emojicon;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.widget.TextView;
import github.ankushsachdeva.emojicon.EmojiconHandler;
import github.ankushsachdeva.emojicon.R;

public class EmojiconTextView
extends TextView {
    private int mEmojiconSize;
    private int mTextStart = 0;
    private int mTextLength = -1;

    public EmojiconTextView(Context context) {
        super(context);
        this.init(null);
    }

    public EmojiconTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public EmojiconTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs == null) {
            this.mEmojiconSize = this.getLineHeight();
        } else {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Emojicon);
            this.mEmojiconSize = (int)a.getDimension(R.styleable.Emojicon_emojiconSize, (float)this.getLineHeight());
            this.mTextStart = a.getInteger(R.styleable.Emojicon_emojiconTextStart, 0);
            this.mTextLength = a.getInteger(R.styleable.Emojicon_emojiconTextLength, -1);
            a.recycle();
        }
        this.setText(this.getText());
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        EmojiconHandler.addEmojis(this.getContext(), (Spannable)builder, this.mEmojiconSize, this.mTextStart, this.mTextLength);
        super.setText((CharSequence)builder, type);
    }

    public void setEmojiconSize(int pixels) {
        this.mEmojiconSize = pixels;
    }
}

