/*
 * Decompiled with CFR 0.152.
 */
package github.ankushsachdeva.emojicon;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.SystemClock;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import github.ankushsachdeva.emojicon.EmojiconGridView;
import github.ankushsachdeva.emojicon.EmojiconRecents;
import github.ankushsachdeva.emojicon.EmojiconRecentsGridView;
import github.ankushsachdeva.emojicon.EmojiconRecentsManager;
import github.ankushsachdeva.emojicon.R;
import github.ankushsachdeva.emojicon.emoji.Emojicon;
import github.ankushsachdeva.emojicon.emoji.Nature;
import github.ankushsachdeva.emojicon.emoji.Objects;
import github.ankushsachdeva.emojicon.emoji.People;
import github.ankushsachdeva.emojicon.emoji.Places;
import github.ankushsachdeva.emojicon.emoji.Symbols;
import java.util.Arrays;
import java.util.List;

public class EmojiconsPopup
extends PopupWindow
implements ViewPager.OnPageChangeListener,
EmojiconRecents {
    private int mEmojiTabLastSelectedIndex = -1;
    private View[] mEmojiTabs;
    private PagerAdapter mEmojisAdapter;
    private EmojiconRecentsManager mRecentsManager;
    private int keyBoardHeight = 0;
    private Boolean pendingOpen = false;
    private Boolean isOpened = false;
    EmojiconGridView.OnEmojiconClickedListener onEmojiconClickedListener;
    OnEmojiconBackspaceClickedListener onEmojiconBackspaceClickedListener;
    OnSoftKeyboardOpenCloseListener onSoftKeyboardOpenCloseListener;
    View rootView;
    Context mContext;
    private ViewPager emojisPager;
    private final int lessThanKeyboardHeight;
    private int screenHeightDelta = 0;

    public EmojiconsPopup(View rootView, Context mContext) {
        super(mContext);
        this.mContext = mContext;
        this.rootView = rootView;
        View customView = this.createCustomView();
        this.setContentView(customView);
        this.setSoftInputMode(5);
        this.lessThanKeyboardHeight = (int)mContext.getResources().getDimension(R.dimen.less_than_keyboard_height);
        this.setSize((int)mContext.getResources().getDimension(R.dimen.keyboard_height), -1);
        this.setBackgroundDrawable((Drawable)new BitmapDrawable());
    }

    public void setOnSoftKeyboardOpenCloseListener(OnSoftKeyboardOpenCloseListener listener) {
        this.onSoftKeyboardOpenCloseListener = listener;
    }

    public void setOnEmojiconClickedListener(EmojiconGridView.OnEmojiconClickedListener listener) {
        this.onEmojiconClickedListener = listener;
    }

    public void setOnEmojiconBackspaceClickedListener(OnEmojiconBackspaceClickedListener listener) {
        this.onEmojiconBackspaceClickedListener = listener;
    }

    public void showAtBottom() {
        this.showAtLocation(this.rootView, 80, 0, 0);
    }

    public void showAtBottomPending() {
        if (this.isKeyBoardOpen().booleanValue()) {
            this.showAtBottom();
        } else {
            this.pendingOpen = true;
        }
    }

    public Boolean isKeyBoardOpen() {
        return this.isOpened;
    }

    public void dismiss() {
        super.dismiss();
        EmojiconRecentsManager.getInstance(this.mContext).saveRecents();
    }

    public void setSizeForSoftKeyboard() {
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Rect r = new Rect();
                EmojiconsPopup.this.rootView.getWindowVisibleDisplayFrame(r);
                int screenHeight = EmojiconsPopup.this.rootView.getRootView().getHeight();
                int heightDifference = screenHeight - (r.bottom - r.top);
                int resourceId = EmojiconsPopup.this.mContext.getResources().getIdentifier("status_bar_height", "dimen", "android");
                if (resourceId > 0) {
                    heightDifference -= EmojiconsPopup.this.mContext.getResources().getDimensionPixelSize(resourceId);
                }
                if (heightDifference > EmojiconsPopup.this.lessThanKeyboardHeight) {
                    EmojiconsPopup.this.keyBoardHeight = heightDifference - EmojiconsPopup.this.screenHeightDelta;
                    EmojiconsPopup.this.setSize(-1, EmojiconsPopup.this.keyBoardHeight);
                    if (!EmojiconsPopup.this.isOpened.booleanValue() && EmojiconsPopup.this.onSoftKeyboardOpenCloseListener != null) {
                        EmojiconsPopup.this.onSoftKeyboardOpenCloseListener.onKeyboardOpen(EmojiconsPopup.this.keyBoardHeight);
                    }
                    EmojiconsPopup.this.isOpened = true;
                    if (EmojiconsPopup.this.pendingOpen.booleanValue()) {
                        EmojiconsPopup.this.showAtBottom();
                        EmojiconsPopup.this.pendingOpen = false;
                    }
                } else {
                    EmojiconsPopup.this.screenHeightDelta = heightDifference;
                    EmojiconsPopup.this.isOpened = false;
                    if (EmojiconsPopup.this.onSoftKeyboardOpenCloseListener != null) {
                        EmojiconsPopup.this.onSoftKeyboardOpenCloseListener.onKeyboardClose();
                    }
                }
            }
        });
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    private View createCustomView() {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.emojicons, null, false);
        this.emojisPager = (ViewPager)view.findViewById(R.id.emojis_pager);
        this.emojisPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        EmojiconsPopup recents = this;
        this.mEmojisAdapter = new EmojisPagerAdapter(Arrays.asList(new EmojiconRecentsGridView(this.mContext, null, null, this), new EmojiconGridView(this.mContext, People.DATA, recents, this), new EmojiconGridView(this.mContext, Nature.DATA, recents, this), new EmojiconGridView(this.mContext, Objects.DATA, recents, this), new EmojiconGridView(this.mContext, Places.DATA, recents, this), new EmojiconGridView(this.mContext, Symbols.DATA, recents, this)));
        this.emojisPager.setAdapter(this.mEmojisAdapter);
        this.mEmojiTabs = new View[6];
        this.mEmojiTabs[0] = view.findViewById(R.id.emojis_tab_0_recents);
        this.mEmojiTabs[1] = view.findViewById(R.id.emojis_tab_1_people);
        this.mEmojiTabs[2] = view.findViewById(R.id.emojis_tab_2_nature);
        this.mEmojiTabs[3] = view.findViewById(R.id.emojis_tab_3_objects);
        this.mEmojiTabs[4] = view.findViewById(R.id.emojis_tab_4_cars);
        this.mEmojiTabs[5] = view.findViewById(R.id.emojis_tab_5_punctuation);
        for (int i = 0; i < this.mEmojiTabs.length; ++i) {
            final int position = i;
            this.mEmojiTabs[i].setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    EmojiconsPopup.this.emojisPager.setCurrentItem(position);
                }
            });
        }
        view.findViewById(R.id.emojis_backspace).setOnTouchListener((View.OnTouchListener)new RepeatListener(1000, 50, new View.OnClickListener(){

            public void onClick(View v) {
                if (EmojiconsPopup.this.onEmojiconBackspaceClickedListener != null) {
                    EmojiconsPopup.this.onEmojiconBackspaceClickedListener.onEmojiconBackspaceClicked(v);
                }
            }
        }));
        this.mRecentsManager = EmojiconRecentsManager.getInstance(view.getContext());
        int page = this.mRecentsManager.getRecentPage();
        if (page == 0 && this.mRecentsManager.size() == 0) {
            page = 1;
        }
        if (page == 0) {
            this.onPageSelected(page);
        } else {
            this.emojisPager.setCurrentItem(page, false);
        }
        return view;
    }

    @Override
    public void addRecentEmoji(Context context, Emojicon emojicon) {
        EmojiconRecentsGridView fragment = ((EmojisPagerAdapter)this.emojisPager.getAdapter()).getRecentFragment();
        fragment.addRecentEmoji(context, emojicon);
    }

    public void onPageScrolled(int i, float v, int i2) {
    }

    public void onPageSelected(int i) {
        if (this.mEmojiTabLastSelectedIndex == i) {
            return;
        }
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.mEmojiTabLastSelectedIndex >= 0 && this.mEmojiTabLastSelectedIndex < this.mEmojiTabs.length) {
                    this.mEmojiTabs[this.mEmojiTabLastSelectedIndex].setSelected(false);
                }
                this.mEmojiTabs[i].setSelected(true);
                this.mEmojiTabLastSelectedIndex = i;
                this.mRecentsManager.setRecentPage(i);
            }
        }
    }

    public void onPageScrollStateChanged(int i) {
    }

    public static interface OnSoftKeyboardOpenCloseListener {
        public void onKeyboardOpen(int var1);

        public void onKeyboardClose();
    }

    public static interface OnEmojiconBackspaceClickedListener {
        public void onEmojiconBackspaceClicked(View var1);
    }

    public static class RepeatListener
    implements View.OnTouchListener {
        private Handler handler = new Handler();
        private int initialInterval;
        private final int normalInterval;
        private final View.OnClickListener clickListener;
        private Runnable handlerRunnable = new Runnable(){

            @Override
            public void run() {
                if (RepeatListener.this.downView == null) {
                    return;
                }
                RepeatListener.this.handler.removeCallbacksAndMessages((Object)RepeatListener.this.downView);
                RepeatListener.this.handler.postAtTime((Runnable)this, (Object)RepeatListener.this.downView, SystemClock.uptimeMillis() + (long)RepeatListener.this.normalInterval);
                RepeatListener.this.clickListener.onClick(RepeatListener.this.downView);
            }
        };
        private View downView;

        public RepeatListener(int initialInterval, int normalInterval, View.OnClickListener clickListener) {
            if (clickListener == null) {
                throw new IllegalArgumentException("null runnable");
            }
            if (initialInterval < 0 || normalInterval < 0) {
                throw new IllegalArgumentException("negative interval");
            }
            this.initialInterval = initialInterval;
            this.normalInterval = normalInterval;
            this.clickListener = clickListener;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            switch (motionEvent.getAction()) {
                case 0: {
                    this.downView = view;
                    this.handler.removeCallbacks(this.handlerRunnable);
                    this.handler.postAtTime(this.handlerRunnable, (Object)this.downView, SystemClock.uptimeMillis() + (long)this.initialInterval);
                    this.clickListener.onClick(view);
                    return true;
                }
                case 1: 
                case 3: 
                case 4: {
                    this.handler.removeCallbacksAndMessages((Object)this.downView);
                    this.downView = null;
                    return true;
                }
            }
            return false;
        }
    }

    private static class EmojisPagerAdapter
    extends PagerAdapter {
        private List<EmojiconGridView> views;

        public EmojiconRecentsGridView getRecentFragment() {
            for (EmojiconGridView it : this.views) {
                if (!(it instanceof EmojiconRecentsGridView)) continue;
                return (EmojiconRecentsGridView)it;
            }
            return null;
        }

        public EmojisPagerAdapter(List<EmojiconGridView> views) {
            this.views = views;
        }

        public int getCount() {
            return this.views.size();
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View v = this.views.get((int)position).rootView;
            ((ViewPager)container).addView(v, 0);
            return v;
        }

        public void destroyItem(ViewGroup container, int position, Object view) {
            ((ViewPager)container).removeView((View)view);
        }

        public boolean isViewFromObject(View view, Object key) {
            return key == view;
        }
    }
}

