/*
 * Decompiled with CFR 0.152.
 */
package com.melnykov.fab;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.ImageButton;
import android.widget.ScrollView;
import com.melnykov.fab.AbsListViewScrollDetector;
import com.melnykov.fab.ObservableScrollView;
import com.melnykov.fab.R;
import com.melnykov.fab.RecyclerViewScrollDetector;
import com.melnykov.fab.ScrollDirectionListener;
import com.melnykov.fab.ScrollViewScrollDetector;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;

public class FloatingActionButton
extends ImageButton {
    private static final int TRANSLATE_DURATION_MILLIS = 200;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_MINI = 1;
    private boolean mVisible;
    private int mColorNormal;
    private int mColorPressed;
    private int mColorRipple;
    private boolean mShadow;
    private int mType;
    private int mShadowSize;
    private int mScrollThreshold;
    private boolean mMarginsSet;
    private final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = this.getDimension(this.mType == 0 ? R.dimen.fab_size_normal : R.dimen.fab_size_mini);
        if (this.mShadow && !this.hasLollipopApi()) {
            size += this.mShadowSize * 2;
            this.setMarginsWithoutShadow();
        }
        this.setMeasuredDimension(size, size);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.mVisible = true;
        this.mColorNormal = this.getColor(R.color.material_blue_500);
        this.mColorPressed = this.getColor(R.color.material_blue_600);
        this.mColorRipple = this.getColor(17170443);
        this.mType = 0;
        this.mShadow = true;
        this.mScrollThreshold = this.getResources().getDimensionPixelOffset(R.dimen.fab_scroll_threshold);
        this.mShadowSize = this.getDimension(R.dimen.fab_shadow_size);
        if (attributeSet != null) {
            this.initAttributes(context, attributeSet);
        }
        this.updateBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attributeSet) {
        TypedArray attr = this.getTypedArray(context, attributeSet, R.styleable.FloatingActionButton);
        if (attr != null) {
            try {
                this.mColorNormal = attr.getColor(R.styleable.FloatingActionButton_fab_colorNormal, this.getColor(R.color.material_blue_500));
                this.mColorPressed = attr.getColor(R.styleable.FloatingActionButton_fab_colorPressed, this.getColor(R.color.material_blue_600));
                this.mColorRipple = attr.getColor(R.styleable.FloatingActionButton_fab_colorRipple, this.getColor(17170443));
                this.mShadow = attr.getBoolean(R.styleable.FloatingActionButton_fab_shadow, true);
                this.mType = attr.getInt(R.styleable.FloatingActionButton_fab_type, 0);
            }
            finally {
                attr.recycle();
            }
        }
    }

    private void updateBackground() {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.addState(new int[]{16842919}, this.createDrawable(this.mColorPressed));
        drawable2.addState(new int[0], this.createDrawable(this.mColorNormal));
        this.setBackgroundCompat((Drawable)drawable2);
    }

    private Drawable createDrawable(int color2) {
        OvalShape ovalShape = new OvalShape();
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)ovalShape);
        shapeDrawable.getPaint().setColor(color2);
        if (this.mShadow && !this.hasLollipopApi()) {
            Drawable shadowDrawable = this.getResources().getDrawable(this.mType == 0 ? R.drawable.shadow : R.drawable.shadow_mini);
            LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{shadowDrawable, shapeDrawable});
            layerDrawable.setLayerInset(1, this.mShadowSize, this.mShadowSize, this.mShadowSize, this.mShadowSize);
            return layerDrawable;
        }
        return shapeDrawable;
    }

    private TypedArray getTypedArray(Context context, AttributeSet attributeSet, int[] attr) {
        return context.obtainStyledAttributes(attributeSet, attr, 0, 0);
    }

    private int getColor(int id) {
        return this.getResources().getColor(id);
    }

    private int getDimension(int id) {
        return this.getResources().getDimensionPixelSize(id);
    }

    private void setMarginsWithoutShadow() {
        if (!this.mMarginsSet && this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            int leftMargin = layoutParams.leftMargin - this.mShadowSize;
            int topMargin = layoutParams.topMargin - this.mShadowSize;
            int rightMargin = layoutParams.rightMargin - this.mShadowSize;
            int bottomMargin = layoutParams.bottomMargin - this.mShadowSize;
            layoutParams.setMargins(leftMargin, topMargin, rightMargin, bottomMargin);
            this.requestLayout();
            this.mMarginsSet = true;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setBackgroundCompat(Drawable drawable2) {
        if (this.hasLollipopApi()) {
            float elevation = this.mShadow ? (this.getElevation() > 0.0f ? this.getElevation() : (float)this.getDimension(R.dimen.fab_elevation_lollipop)) : 0.0f;
            this.setElevation(elevation);
            RippleDrawable rippleDrawable = new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{this.mColorRipple}), drawable2, null);
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    int size = FloatingActionButton.this.getDimension(FloatingActionButton.this.mType == 0 ? R.dimen.fab_size_normal : R.dimen.fab_size_mini);
                    outline.setOval(0, 0, size, size);
                }
            });
            this.setClipToOutline(true);
            this.setBackground((Drawable)rippleDrawable);
        } else if (this.hasJellyBeanApi()) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    private int getMarginBottom() {
        int marginBottom = 0;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            marginBottom = ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin;
        }
        return marginBottom;
    }

    public void setColorNormal(int color2) {
        if (color2 != this.mColorNormal) {
            this.mColorNormal = color2;
            this.updateBackground();
        }
    }

    public void setColorNormalResId(int colorResId) {
        this.setColorNormal(this.getColor(colorResId));
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public void setColorPressed(int color2) {
        if (color2 != this.mColorPressed) {
            this.mColorPressed = color2;
            this.updateBackground();
        }
    }

    public void setColorPressedResId(int colorResId) {
        this.setColorPressed(this.getColor(colorResId));
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public void setColorRipple(int color2) {
        if (color2 != this.mColorRipple) {
            this.mColorRipple = color2;
            this.updateBackground();
        }
    }

    public void setColorRippleResId(int colorResId) {
        this.setColorRipple(this.getColor(colorResId));
    }

    public int getColorRipple() {
        return this.mColorRipple;
    }

    public void setShadow(boolean shadow) {
        if (shadow != this.mShadow) {
            this.mShadow = shadow;
            this.updateBackground();
        }
    }

    public boolean hasShadow() {
        return this.mShadow;
    }

    public void setType(@TYPE int type) {
        if (type != this.mType) {
            this.mType = type;
            this.updateBackground();
        }
    }

    @TYPE
    public int getType() {
        return this.mType;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void show() {
        this.show(true);
    }

    public void hide() {
        this.hide(true);
    }

    public void show(boolean animate) {
        this.toggle(true, animate, false);
    }

    public void hide(boolean animate) {
        this.toggle(false, animate, false);
    }

    private void toggle(final boolean visible, final boolean animate, boolean force) {
        if (this.mVisible != visible || force) {
            int translationY;
            ViewTreeObserver vto;
            this.mVisible = visible;
            int height = this.getHeight();
            if (height == 0 && !force && (vto = this.getViewTreeObserver()).isAlive()) {
                vto.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ViewTreeObserver currentVto = FloatingActionButton.this.getViewTreeObserver();
                        if (currentVto.isAlive()) {
                            currentVto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        }
                        FloatingActionButton.this.toggle(visible, animate, true);
                        return true;
                    }
                });
                return;
            }
            int n = translationY = visible ? 0 : height + this.getMarginBottom();
            if (animate) {
                ViewPropertyAnimator.animate((View)this).setInterpolator(this.mInterpolator).setDuration(200L).translationY((float)translationY);
            } else {
                ViewHelper.setTranslationY((View)this, (float)translationY);
            }
            if (!this.hasHoneycombApi()) {
                this.setClickable(visible);
            }
        }
    }

    public void attachToListView(@NonNull AbsListView listView) {
        this.attachToListView(listView, null, null);
    }

    public void attachToListView(@NonNull AbsListView listView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToListView(listView, scrollDirectionListener, null);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.attachToRecyclerView(recyclerView, null, null);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToRecyclerView(recyclerView, scrollDirectionListener, null);
    }

    public void attachToScrollView(@NonNull ObservableScrollView scrollView) {
        this.attachToScrollView(scrollView, null, null);
    }

    public void attachToScrollView(@NonNull ObservableScrollView scrollView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToScrollView(scrollView, scrollDirectionListener, null);
    }

    public void attachToListView(@NonNull AbsListView listView, ScrollDirectionListener scrollDirectionListener, AbsListView.OnScrollListener onScrollListener) {
        AbsListViewScrollDetectorImpl scrollDetector = new AbsListViewScrollDetectorImpl();
        scrollDetector.setScrollDirectionListener(scrollDirectionListener);
        scrollDetector.setOnScrollListener(onScrollListener);
        scrollDetector.setListView(listView);
        scrollDetector.setScrollThreshold(this.mScrollThreshold);
        listView.setOnScrollListener((AbsListView.OnScrollListener)scrollDetector);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView, ScrollDirectionListener scrollDirectionlistener, RecyclerView.OnScrollListener onScrollListener) {
        RecyclerViewScrollDetectorImpl scrollDetector = new RecyclerViewScrollDetectorImpl();
        scrollDetector.setScrollDirectionListener(scrollDirectionlistener);
        scrollDetector.setOnScrollListener(onScrollListener);
        scrollDetector.setScrollThreshold(this.mScrollThreshold);
        recyclerView.setOnScrollListener((RecyclerView.OnScrollListener)scrollDetector);
    }

    public void attachToScrollView(@NonNull ObservableScrollView scrollView, ScrollDirectionListener scrollDirectionListener, ObservableScrollView.OnScrollChangedListener onScrollChangedListener) {
        ScrollViewScrollDetectorImpl scrollDetector = new ScrollViewScrollDetectorImpl();
        scrollDetector.setScrollDirectionListener(scrollDirectionListener);
        scrollDetector.setOnScrollChangedListener(onScrollChangedListener);
        scrollDetector.setScrollThreshold(this.mScrollThreshold);
        scrollView.setOnScrollChangedListener(scrollDetector);
    }

    private boolean hasLollipopApi() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private boolean hasJellyBeanApi() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private boolean hasHoneycombApi() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private class ScrollViewScrollDetectorImpl
    extends ScrollViewScrollDetector {
        private ScrollDirectionListener mScrollDirectionListener;
        private ObservableScrollView.OnScrollChangedListener mOnScrollChangedListener;

        private ScrollViewScrollDetectorImpl() {
        }

        private void setScrollDirectionListener(ScrollDirectionListener scrollDirectionListener) {
            this.mScrollDirectionListener = scrollDirectionListener;
        }

        public void setOnScrollChangedListener(ObservableScrollView.OnScrollChangedListener onScrollChangedListener) {
            this.mOnScrollChangedListener = onScrollChangedListener;
        }

        @Override
        public void onScrollDown() {
            FloatingActionButton.this.show();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollDown();
            }
        }

        @Override
        public void onScrollUp() {
            FloatingActionButton.this.hide();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollUp();
            }
        }

        @Override
        public void onScrollChanged(ScrollView who, int l, int t, int oldl, int oldt) {
            if (this.mOnScrollChangedListener != null) {
                this.mOnScrollChangedListener.onScrollChanged(who, l, t, oldl, oldt);
            }
            super.onScrollChanged(who, l, t, oldl, oldt);
        }
    }

    private class RecyclerViewScrollDetectorImpl
    extends RecyclerViewScrollDetector {
        private ScrollDirectionListener mScrollDirectionListener;
        private RecyclerView.OnScrollListener mOnScrollListener;

        private RecyclerViewScrollDetectorImpl() {
        }

        private void setScrollDirectionListener(ScrollDirectionListener scrollDirectionListener) {
            this.mScrollDirectionListener = scrollDirectionListener;
        }

        public void setOnScrollListener(RecyclerView.OnScrollListener onScrollListener) {
            this.mOnScrollListener = onScrollListener;
        }

        @Override
        public void onScrollDown() {
            FloatingActionButton.this.show();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollDown();
            }
        }

        @Override
        public void onScrollUp() {
            FloatingActionButton.this.hide();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollUp();
            }
        }

        @Override
        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScrolled(recyclerView, dx, dy);
            }
            super.onScrolled(recyclerView, dx, dy);
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScrollStateChanged(recyclerView, newState);
            }
            super.onScrollStateChanged(recyclerView, newState);
        }
    }

    private class AbsListViewScrollDetectorImpl
    extends AbsListViewScrollDetector {
        private ScrollDirectionListener mScrollDirectionListener;
        private AbsListView.OnScrollListener mOnScrollListener;

        private AbsListViewScrollDetectorImpl() {
        }

        private void setScrollDirectionListener(ScrollDirectionListener scrollDirectionListener) {
            this.mScrollDirectionListener = scrollDirectionListener;
        }

        public void setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
            this.mOnScrollListener = onScrollListener;
        }

        @Override
        public void onScrollDown() {
            FloatingActionButton.this.show();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollDown();
            }
        }

        @Override
        public void onScrollUp() {
            FloatingActionButton.this.hide();
            if (this.mScrollDirectionListener != null) {
                this.mScrollDirectionListener.onScrollUp();
            }
        }

        @Override
        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            super.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }

        @Override
        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScrollStateChanged(view, scrollState);
            }
            super.onScrollStateChanged(view, scrollState);
        }
    }

    @IntDef(value={0L, 1L})
    public static @interface TYPE {
    }
}

