/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksoichiro.android.observablescrollview;

import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;

public final class ScrollUtils {
    private ScrollUtils() {
    }

    public static float getFloat(float value, float minValue, float maxValue) {
        return Math.min(maxValue, Math.max(minValue, value));
    }

    public static int getColorWithAlpha(float alpha, int baseColor) {
        int a = Math.min(255, Math.max(0, (int)(alpha * 255.0f))) << 24;
        int rgb = 0xFFFFFF & baseColor;
        return a + rgb;
    }

    public static void addOnGlobalLayoutListener(final View view, final Runnable runnable) {
        ViewTreeObserver vto = view.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                runnable.run();
            }
        });
    }

    public static int mixColors(int fromColor, int toColor, float toAlpha) {
        float[] fromCmyk = ScrollUtils.cmykFromRgb(fromColor);
        float[] toCmyk = ScrollUtils.cmykFromRgb(toColor);
        float[] result = new float[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = Math.min(1.0f, fromCmyk[i] * (1.0f - toAlpha) + toCmyk[i] * toAlpha);
        }
        return -16777216 + (0xFFFFFF & ScrollUtils.rgbFromCmyk(result));
    }

    public static float[] cmykFromRgb(int rgbColor) {
        int red = (0xFF0000 & rgbColor) >> 16;
        int green = (0xFF00 & rgbColor) >> 8;
        int blue = 0xFF & rgbColor;
        float black = Math.min(1.0f - (float)red / 255.0f, Math.min(1.0f - (float)green / 255.0f, 1.0f - (float)blue / 255.0f));
        float cyan = 1.0f;
        float magenta = 1.0f;
        float yellow = 1.0f;
        if (black != 1.0f) {
            cyan = (1.0f - (float)red / 255.0f - black) / (1.0f - black);
            magenta = (1.0f - (float)green / 255.0f - black) / (1.0f - black);
            yellow = (1.0f - (float)blue / 255.0f - black) / (1.0f - black);
        }
        return new float[]{cyan, magenta, yellow, black};
    }

    public static int rgbFromCmyk(float[] cmyk) {
        float cyan = cmyk[0];
        float magenta = cmyk[1];
        float yellow = cmyk[2];
        float black = cmyk[3];
        int red = (int)((1.0f - Math.min(1.0f, cyan * (1.0f - black) + black)) * 255.0f);
        int green = (int)((1.0f - Math.min(1.0f, magenta * (1.0f - black) + black)) * 255.0f);
        int blue = (int)((1.0f - Math.min(1.0f, yellow * (1.0f - black) + black)) * 255.0f);
        return ((0xFF & red) << 16) + ((0xFF & green) << 8) + (0xFF & blue);
    }
}

