/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j;

public class OtrPolicy {
    public static final int ALLOW_V1 = 1;
    public static final int ALLOW_V2 = 2;
    public static final int ALLOW_V3 = 64;
    public static final int REQUIRE_ENCRYPTION = 4;
    public static final int SEND_WHITESPACE_TAG = 8;
    public static final int WHITESPACE_START_AKE = 16;
    public static final int ERROR_START_AKE = 32;
    public static final int VERSION_MASK = 67;
    public static final int NEVER = 0;
    public static final int OPPORTUNISTIC = 123;
    public static final int OTRL_POLICY_MANUAL = 67;
    public static final int OTRL_POLICY_ALWAYS = 119;
    public static final int OTRL_POLICY_DEFAULT = 123;
    private int policy;

    public OtrPolicy() {
        this.setPolicy(0);
    }

    public OtrPolicy(int policy) {
        this.setPolicy(policy);
    }

    public int getPolicy() {
        return this.policy;
    }

    private void setPolicy(int policy) {
        this.policy = policy;
    }

    public boolean getAllowV1() {
        return (this.policy & 1) != 0;
    }

    public boolean getAllowV2() {
        return (this.policy & 2) != 0;
    }

    public boolean getAllowV3() {
        return (this.policy & 0x40) != 0;
    }

    public boolean getErrorStartAKE() {
        return (this.policy & 0x20) != 0;
    }

    public boolean getRequireEncryption() {
        return this.getEnableManual() && (this.policy & 4) != 0;
    }

    public boolean getSendWhitespaceTag() {
        return (this.policy & 8) != 0;
    }

    public boolean getWhitespaceStartAKE() {
        return (this.policy & 0x10) != 0;
    }

    public void setAllowV1(boolean value) {
        this.policy = value ? (this.policy |= 1) : (this.policy &= 0xFFFFFFFE);
    }

    public void setAllowV2(boolean value) {
        this.policy = value ? (this.policy |= 2) : (this.policy &= 0xFFFFFFFD);
    }

    public void setAllowV3(boolean value) {
        this.policy = value ? (this.policy |= 0x40) : (this.policy &= 0xFFFFFFBF);
    }

    public void setErrorStartAKE(boolean value) {
        this.policy = value ? (this.policy |= 0x20) : (this.policy &= 0xFFFFFFDF);
    }

    public void setRequireEncryption(boolean value) {
        this.policy = value ? (this.policy |= 4) : (this.policy &= 0xFFFFFFFB);
    }

    public void setSendWhitespaceTag(boolean value) {
        this.policy = value ? (this.policy |= 8) : (this.policy &= 0xFFFFFFF7);
    }

    public void setWhitespaceStartAKE(boolean value) {
        this.policy = value ? (this.policy |= 0x10) : (this.policy &= 0xFFFFFFEF);
    }

    public boolean getEnableAlways() {
        return this.getEnableManual() && this.getErrorStartAKE() && this.getSendWhitespaceTag() && this.getWhitespaceStartAKE();
    }

    public void setEnableAlways(boolean value) {
        if (value) {
            this.setEnableManual(true);
        }
        this.setErrorStartAKE(value);
        this.setSendWhitespaceTag(value);
        this.setWhitespaceStartAKE(value);
    }

    public boolean getEnableManual() {
        return this.getAllowV1() && this.getAllowV2() && this.getAllowV3();
    }

    public void setEnableManual(boolean value) {
        this.setAllowV1(value);
        this.setAllowV2(value);
        this.setAllowV3(value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OtrPolicy policy = (OtrPolicy)obj;
        return policy.getPolicy() == this.getPolicy();
    }

    public int hashCode() {
        return this.getPolicy();
    }
}

