/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrEngineListener;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;

public class OtrSessionManager {
    private OtrEngineHost host;
    private Map<SessionID, Session> sessions;
    private List<OtrEngineListener> listeners = new Vector<OtrEngineListener>();

    public OtrSessionManager(OtrEngineHost host) {
        if (host == null) {
            throw new IllegalArgumentException("OtrEngineHost is required.");
        }
        this.setHost(host);
    }

    public Session getSession(SessionID sessionID) {
        if (sessionID == null || sessionID.equals(SessionID.Empty)) {
            throw new IllegalArgumentException();
        }
        if (this.sessions == null) {
            this.sessions = new Hashtable<SessionID, Session>();
        }
        if (!this.sessions.containsKey(sessionID)) {
            Session session = new Session(sessionID, this.getHost());
            this.sessions.put(sessionID, session);
            session.addOtrEngineListener(new OtrEngineListener(){

                @Override
                public void sessionStatusChanged(SessionID sessionID) {
                    for (OtrEngineListener l : OtrSessionManager.this.listeners) {
                        l.sessionStatusChanged(sessionID);
                    }
                }

                @Override
                public void multipleInstancesDetected(SessionID sessionID) {
                    for (OtrEngineListener l : OtrSessionManager.this.listeners) {
                        l.multipleInstancesDetected(sessionID);
                    }
                }

                @Override
                public void outgoingSessionChanged(SessionID sessionID) {
                    for (OtrEngineListener l : OtrSessionManager.this.listeners) {
                        l.outgoingSessionChanged(sessionID);
                    }
                }
            });
            return session;
        }
        return this.sessions.get(sessionID);
    }

    private void setHost(OtrEngineHost host) {
        this.host = host;
    }

    private OtrEngineHost getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }
}

