/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.java.otr4j.crypto.Util;
import net.java.otr4j.io.OtrInputStream;
import net.java.otr4j.io.OtrOutputStream;
import net.java.otr4j.io.SerializationUtils;

public class SM {
    public static final int EXPECT1 = 0;
    public static final int EXPECT2 = 1;
    public static final int EXPECT3 = 2;
    public static final int EXPECT4 = 3;
    public static final int EXPECT5 = 4;
    public static final int PROG_OK = 0;
    public static final int PROG_CHEATED = -2;
    public static final int PROG_FAILED = -1;
    public static final int PROG_SUCCEEDED = 1;
    public static final int MSG1_LEN = 6;
    public static final int MSG2_LEN = 11;
    public static final int MSG3_LEN = 8;
    public static final int MSG4_LEN = 3;
    public static final BigInteger MODULUS_S = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA237327FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger MODULUS_MINUS_2 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA237327FFFFFFFFFFFFFFFD", 16);
    public static final BigInteger ORDER_S = new BigInteger("7FFFFFFFFFFFFFFFE487ED5110B4611A62633145C06E0E68948127044533E63A0105DF531D89CD9128A5043CC71A026EF7CA8CD9E69D218D98158536F92F8A1BA7F09AB6B6A8E122F242DABB312F3F637A262174D31BF6B585FFAE5B7A035BF6F71C35FDAD44CFD2D74F9208BE258FF324943328F6722D9EE1003E5C50B1DF82CC6D241B0E2AE9CD348B1FD47E9267AFC1B2AE91EE51D6CB0E3179AB1042A95DCF6A9483B84B4B36B3861AA7255E4C0278BA36046511B993FFFFFFFFFFFFFFFF", 16);
    public static final byte[] GENERATOR_S = Util.hexStringToBytes("02");
    public static final int MOD_LEN_BITS = 1536;
    public static final int MOD_LEN_BYTES = 192;

    public static BigInteger randomExponent() {
        SecureRandom sr = new SecureRandom();
        byte[] sb = new byte[192];
        sr.nextBytes(sb);
        return new BigInteger(1, sb);
    }

    public static BigInteger hash(int version, BigInteger a, BigInteger b) throws SMException {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update((byte)version);
            sha256.update(SerializationUtils.writeMpi(a));
            if (b != null) {
                sha256.update(SerializationUtils.writeMpi(b));
            }
            return new BigInteger(1, sha256.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SMException("cannot find SHA-256");
        }
        catch (IOException e) {
            throw new SMException("cannot serialize bigint");
        }
    }

    public static byte[] serialize(BigInteger[] ints) throws SMException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OtrOutputStream oos = new OtrOutputStream(out);
            oos.writeInt(ints.length);
            for (BigInteger i : ints) {
                oos.writeBigInt(i);
            }
            byte[] b = out.toByteArray();
            oos.close();
            return b;
        }
        catch (IOException ex) {
            throw new SMException("cannot serialize bigints");
        }
    }

    public static BigInteger[] unserialize(byte[] bytes) throws SMException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            OtrInputStream ois = new OtrInputStream(in);
            int len = ois.readInt();
            if (len > 100) {
                ois.close();
                throw new SMException("Too many ints");
            }
            BigInteger[] ints = new BigInteger[len];
            for (int i = 0; i < len; ++i) {
                ints[i] = ois.readBigInt();
            }
            ois.close();
            return ints;
        }
        catch (IOException ex) {
            throw new SMException("cannot unserialize bigints");
        }
    }

    public static boolean checkGroupElem(BigInteger g) {
        return g.compareTo(BigInteger.valueOf(2L)) <= 0 || g.compareTo(MODULUS_MINUS_2) >= 0;
    }

    public static boolean checkExpon(BigInteger x) {
        return x.compareTo(BigInteger.ONE) <= 0 || x.compareTo(ORDER_S) > 0;
    }

    public static BigInteger[] proofKnowLog(BigInteger g, BigInteger x, int version) throws SMException {
        BigInteger r = SM.randomExponent();
        BigInteger temp = g.modPow(r, MODULUS_S);
        BigInteger c = SM.hash(version, temp, null);
        temp = x.multiply(c).mod(ORDER_S);
        BigInteger d = r.subtract(temp).mod(ORDER_S);
        BigInteger[] ret = new BigInteger[]{c, d};
        return ret;
    }

    public static int checkKnowLog(BigInteger c, BigInteger d, BigInteger g, BigInteger x, int version) throws SMException {
        BigInteger gd = g.modPow(d, MODULUS_S);
        BigInteger xc = x.modPow(c, MODULUS_S);
        BigInteger gdxc = gd.multiply(xc).mod(MODULUS_S);
        BigInteger hgdxc = SM.hash(version, gdxc, null);
        return hgdxc.compareTo(c);
    }

    public static BigInteger[] proofEqualCoords(SMState state, BigInteger r, int version) throws SMException {
        BigInteger r1 = SM.randomExponent();
        BigInteger r2 = SM.randomExponent();
        BigInteger temp1 = state.g1.modPow(r1, MODULUS_S);
        BigInteger temp2 = state.g2.modPow(r2, MODULUS_S);
        temp2 = temp1.multiply(temp2).mod(MODULUS_S);
        temp1 = state.g3.modPow(r1, MODULUS_S);
        BigInteger c = SM.hash(version, temp1, temp2);
        temp1 = r.multiply(c).mod(ORDER_S);
        BigInteger d1 = r1.subtract(temp1).mod(ORDER_S);
        temp1 = state.secret.multiply(c).mod(ORDER_S);
        BigInteger d2 = r2.subtract(temp1).mod(ORDER_S);
        BigInteger[] ret = new BigInteger[]{c, d1, d2};
        return ret;
    }

    public static int checkEqualCoords(BigInteger c, BigInteger d1, BigInteger d2, BigInteger p, BigInteger q, SMState state, int version) throws SMException {
        BigInteger temp2 = state.g3.modPow(d1, MODULUS_S);
        BigInteger temp3 = p.modPow(c, MODULUS_S);
        BigInteger temp1 = temp2.multiply(temp3).mod(MODULUS_S);
        temp2 = state.g1.modPow(d1, MODULUS_S);
        temp3 = state.g2.modPow(d2, MODULUS_S);
        temp2 = temp2.multiply(temp3).mod(MODULUS_S);
        temp3 = q.modPow(c, MODULUS_S);
        temp2 = temp3.multiply(temp2).mod(MODULUS_S);
        BigInteger cprime = SM.hash(version, temp1, temp2);
        return c.compareTo(cprime);
    }

    public static BigInteger[] proofEqualLogs(SMState state, int version) throws SMException {
        BigInteger r = SM.randomExponent();
        BigInteger temp1 = state.g1.modPow(r, MODULUS_S);
        BigInteger temp2 = state.qab.modPow(r, MODULUS_S);
        BigInteger c = SM.hash(version, temp1, temp2);
        temp1 = state.x3.multiply(c).mod(ORDER_S);
        BigInteger d = r.subtract(temp1).mod(ORDER_S);
        BigInteger[] ret = new BigInteger[]{c, d};
        return ret;
    }

    public static int checkEqualLogs(BigInteger c, BigInteger d, BigInteger r, SMState state, int version) throws SMException {
        BigInteger temp2 = state.g1.modPow(d, MODULUS_S);
        BigInteger temp3 = state.g3o.modPow(c, MODULUS_S);
        BigInteger temp1 = temp2.multiply(temp3).mod(MODULUS_S);
        temp3 = state.qab.modPow(d, MODULUS_S);
        temp2 = r.modPow(c, MODULUS_S);
        temp2 = temp3.multiply(temp2).mod(MODULUS_S);
        BigInteger cprime = SM.hash(version, temp1, temp2);
        return c.compareTo(cprime);
    }

    public static byte[] step1(SMState astate, byte[] secret) throws SMException {
        BigInteger secret_mpi;
        astate.secret = secret_mpi = new BigInteger(1, secret);
        astate.receivedQuestion = 0;
        astate.x2 = SM.randomExponent();
        astate.x3 = SM.randomExponent();
        BigInteger[] msg1 = new BigInteger[6];
        msg1[0] = astate.g1.modPow(astate.x2, MODULUS_S);
        BigInteger[] res = SM.proofKnowLog(astate.g1, astate.x2, 1);
        msg1[1] = res[0];
        msg1[2] = res[1];
        msg1[3] = astate.g1.modPow(astate.x3, MODULUS_S);
        res = SM.proofKnowLog(astate.g1, astate.x3, 2);
        msg1[4] = res[0];
        msg1[5] = res[1];
        byte[] ret = SM.serialize(msg1);
        astate.smProgState = 0;
        return ret;
    }

    public static void step2a(SMState bstate, byte[] input, int received_question) throws SMException {
        bstate.receivedQuestion = received_question;
        bstate.smProgState = -2;
        BigInteger[] msg1 = SM.unserialize(input);
        if (SM.checkGroupElem(msg1[0]) || SM.checkExpon(msg1[2]) || SM.checkGroupElem(msg1[3]) || SM.checkExpon(msg1[5])) {
            throw new SMException("Invalid parameter");
        }
        bstate.g3o = msg1[3];
        if (SM.checkKnowLog(msg1[1], msg1[2], bstate.g1, msg1[0], 1) != 0 || SM.checkKnowLog(msg1[4], msg1[5], bstate.g1, msg1[3], 2) != 0) {
            throw new SMException("Proof checking failed");
        }
        bstate.x2 = SM.randomExponent();
        bstate.x3 = SM.randomExponent();
        bstate.g2 = msg1[0].modPow(bstate.x2, MODULUS_S);
        bstate.g3 = msg1[3].modPow(bstate.x3, MODULUS_S);
        bstate.smProgState = 0;
    }

    public static byte[] step2b(SMState bstate, byte[] secret) throws SMException {
        BigInteger secret_mpi;
        bstate.secret = secret_mpi = new BigInteger(1, secret);
        BigInteger[] msg2 = new BigInteger[11];
        msg2[0] = bstate.g1.modPow(bstate.x2, MODULUS_S);
        BigInteger[] res = SM.proofKnowLog(bstate.g1, bstate.x2, 3);
        msg2[1] = res[0];
        msg2[2] = res[1];
        msg2[3] = bstate.g1.modPow(bstate.x3, MODULUS_S);
        res = SM.proofKnowLog(bstate.g1, bstate.x3, 4);
        msg2[4] = res[0];
        msg2[5] = res[1];
        BigInteger r = SM.randomExponent();
        msg2[6] = bstate.p = bstate.g3.modPow(r, MODULUS_S);
        BigInteger qb1 = bstate.g1.modPow(r, MODULUS_S);
        BigInteger qb2 = bstate.g2.modPow(bstate.secret, MODULUS_S);
        msg2[7] = bstate.q = qb1.multiply(qb2).mod(MODULUS_S);
        res = SM.proofEqualCoords(bstate, r, 5);
        msg2[8] = res[0];
        msg2[9] = res[1];
        msg2[10] = res[2];
        return SM.serialize(msg2);
    }

    public static byte[] step3(SMState astate, byte[] input) throws SMException {
        astate.smProgState = -2;
        BigInteger[] msg2 = SM.unserialize(input);
        if (SM.checkGroupElem(msg2[0]) || SM.checkGroupElem(msg2[3]) || SM.checkGroupElem(msg2[6]) || SM.checkGroupElem(msg2[7]) || SM.checkExpon(msg2[2]) || SM.checkExpon(msg2[5]) || SM.checkExpon(msg2[9]) || SM.checkExpon(msg2[10])) {
            throw new SMException("Invalid Parameter");
        }
        BigInteger[] msg3 = new BigInteger[8];
        astate.g3o = msg2[3];
        if (SM.checkKnowLog(msg2[1], msg2[2], astate.g1, msg2[0], 3) != 0 || SM.checkKnowLog(msg2[4], msg2[5], astate.g1, msg2[3], 4) != 0) {
            throw new SMException("Proof checking failed");
        }
        astate.g2 = msg2[0].modPow(astate.x2, MODULUS_S);
        astate.g3 = msg2[3].modPow(astate.x3, MODULUS_S);
        if (SM.checkEqualCoords(msg2[8], msg2[9], msg2[10], msg2[6], msg2[7], astate, 5) != 0) {
            throw new SMException("Invalid Parameter");
        }
        BigInteger r = SM.randomExponent();
        msg3[0] = astate.p = astate.g3.modPow(r, MODULUS_S);
        BigInteger qa1 = astate.g1.modPow(r, MODULUS_S);
        BigInteger qa2 = astate.g2.modPow(astate.secret, MODULUS_S);
        msg3[1] = astate.q = qa1.multiply(qa2).mod(MODULUS_S);
        BigInteger[] res = SM.proofEqualCoords(astate, r, 6);
        msg3[2] = res[0];
        msg3[3] = res[1];
        msg3[4] = res[2];
        BigInteger inv = msg2[6].modInverse(MODULUS_S);
        astate.pab = astate.p.multiply(inv).mod(MODULUS_S);
        inv = msg2[7].modInverse(MODULUS_S);
        astate.qab = astate.q.multiply(inv).mod(MODULUS_S);
        msg3[5] = astate.qab.modPow(astate.x3, MODULUS_S);
        res = SM.proofEqualLogs(astate, 7);
        msg3[6] = res[0];
        msg3[7] = res[1];
        byte[] output = SM.serialize(msg3);
        astate.smProgState = 0;
        return output;
    }

    public static byte[] step4(SMState bstate, byte[] input) throws SMException {
        BigInteger[] msg3 = SM.unserialize(input);
        bstate.smProgState = -2;
        BigInteger[] msg4 = new BigInteger[3];
        if (SM.checkGroupElem(msg3[0]) || SM.checkGroupElem(msg3[1]) || SM.checkGroupElem(msg3[5]) || SM.checkExpon(msg3[3]) || SM.checkExpon(msg3[4]) || SM.checkExpon(msg3[7])) {
            throw new SMException("Invalid Parameter");
        }
        if (SM.checkEqualCoords(msg3[2], msg3[3], msg3[4], msg3[0], msg3[1], bstate, 6) != 0) {
            throw new SMException("Invalid Parameter");
        }
        BigInteger inv = bstate.p.modInverse(MODULUS_S);
        bstate.pab = msg3[0].multiply(inv).mod(MODULUS_S);
        inv = bstate.q.modInverse(MODULUS_S);
        bstate.qab = msg3[1].multiply(inv).mod(MODULUS_S);
        if (SM.checkEqualLogs(msg3[6], msg3[7], msg3[5], bstate, 7) != 0) {
            throw new SMException("Proof checking failed");
        }
        msg4[0] = bstate.qab.modPow(bstate.x3, MODULUS_S);
        BigInteger[] res = SM.proofEqualLogs(bstate, 8);
        msg4[1] = res[0];
        msg4[2] = res[1];
        byte[] output = SM.serialize(msg4);
        BigInteger rab = msg3[5].modPow(bstate.x3, MODULUS_S);
        int comp = rab.compareTo(bstate.pab);
        bstate.smProgState = comp != 0 ? -1 : 1;
        return output;
    }

    public static void step5(SMState astate, byte[] input) throws SMException {
        BigInteger[] msg4 = SM.unserialize(input);
        astate.smProgState = -2;
        if (SM.checkGroupElem(msg4[0]) || SM.checkExpon(msg4[2])) {
            throw new SMException("Invalid Parameter");
        }
        if (SM.checkEqualLogs(msg4[1], msg4[2], msg4[0], astate, 8) != 0) {
            throw new SMException("Invalid Parameter");
        }
        BigInteger rab = msg4[0].modPow(astate.x3, MODULUS_S);
        int comp = rab.compareTo(astate.pab);
        if (comp != 0) {
            // empty if block
        }
        astate.smProgState = comp != 0 ? -1 : 1;
    }

    public static void main(String[] args) throws SMException {
        BigInteger res = MODULUS_MINUS_2.subtract(MODULUS_S).mod(MODULUS_S);
        String ss = Util.bytesToHexString(res.toByteArray());
        System.out.println(ss);
        byte[] secret1 = "abcdef".getBytes(SerializationUtils.UTF8);
        SMState a = new SMState();
        SMState b = new SMState();
        byte[] msg1 = SM.step1(a, secret1);
        SM.step2a(b, msg1, 123);
        byte[] msg2 = SM.step2b(b, secret1);
        byte[] msg3 = SM.step3(a, msg2);
        byte[] msg4 = SM.step4(b, msg3);
        SM.step5(a, msg4);
    }

    public static class SMException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SMException() {
            super("");
        }

        public SMException(Throwable cause) {
            super(cause);
        }

        public SMException(String message) {
            super(message);
        }
    }

    public static class SMState {
        BigInteger secret;
        BigInteger x2;
        BigInteger x3;
        BigInteger g1 = new BigInteger(1, GENERATOR_S);
        BigInteger g2;
        BigInteger g3;
        BigInteger g3o;
        BigInteger p;
        BigInteger q;
        BigInteger pab;
        BigInteger qab;
        public int nextExpected;
        int receivedQuestion;
        public int smProgState = 0;
        public boolean approved = false;
        public boolean asked = false;
    }
}

