/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.crypto.OtrCryptoEngine;
import net.java.otr4j.io.SerializationConstants;
import net.java.otr4j.io.messages.SignatureX;

public class OtrInputStream
extends FilterInputStream
implements SerializationConstants {
    public OtrInputStream(InputStream in) {
        super(in);
    }

    private byte[] checkedRead(int length) throws IOException {
        if (length == 0) {
            return new byte[0];
        }
        byte[] b = new byte[length];
        int bytesRead = this.read(b);
        if (bytesRead != length) {
            throw new IOException("Unable to read the required amount of bytes from the stream. Expected were " + length + " bytes but I could only read " + bytesRead + " bytes.");
        }
        return b;
    }

    private int readNumber(int length) throws IOException {
        byte[] b = this.checkedRead(length);
        int value = 0;
        for (int i = 0; i < b.length; ++i) {
            int shift = (b.length - 1 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }

    public int readByte() throws IOException {
        return this.readNumber(1);
    }

    public int readInt() throws IOException {
        return this.readNumber(4);
    }

    public int readShort() throws IOException {
        return this.readNumber(2);
    }

    public byte[] readCtr() throws IOException {
        return this.checkedRead(8);
    }

    public byte[] readMac() throws IOException {
        return this.checkedRead(20);
    }

    public BigInteger readBigInt() throws IOException {
        byte[] b = this.readData();
        return new BigInteger(1, b);
    }

    public byte[] readData() throws IOException {
        int dataLen = this.readNumber(4);
        return this.checkedRead(dataLen);
    }

    public PublicKey readPublicKey() throws IOException {
        int type = this.readShort();
        switch (type) {
            case 0: {
                KeyFactory keyFactory;
                BigInteger p = this.readBigInt();
                BigInteger q = this.readBigInt();
                BigInteger g = this.readBigInt();
                BigInteger y = this.readBigInt();
                DSAPublicKeySpec keySpec = new DSAPublicKeySpec(y, p, q, g);
                try {
                    keyFactory = KeyFactory.getInstance("DSA");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException();
                }
                try {
                    return keyFactory.generatePublic(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw new IOException();
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public DHPublicKey readDHPublicKey() throws IOException {
        BigInteger gyMpi = this.readBigInt();
        try {
            return OtrCryptoEngine.getDHPublicKey(gyMpi);
        }
        catch (Exception ex) {
            throw new IOException();
        }
    }

    public byte[] readTlvData() throws IOException {
        int len = this.readNumber(2);
        return this.checkedRead(len);
    }

    public byte[] readSignature(PublicKey pubKey) throws IOException {
        if (!pubKey.getAlgorithm().equals("DSA")) {
            throw new UnsupportedOperationException();
        }
        DSAPublicKey dsaPubKey = (DSAPublicKey)pubKey;
        DSAParams dsaParams = dsaPubKey.getParams();
        return this.checkedRead(dsaParams.getQ().bitLength() / 4);
    }

    public SignatureX readMysteriousX() throws IOException {
        PublicKey pubKey = this.readPublicKey();
        int dhKeyID = this.readInt();
        byte[] sig = this.readSignature(pubKey);
        return new SignatureX(pubKey, dhKeyID, sig);
    }
}

