/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.OtrException;
import net.java.otr4j.crypto.OtrCryptoEngine;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.io.messages.AbstractMessage;
import net.java.otr4j.io.messages.DHCommitMessage;
import net.java.otr4j.io.messages.DHKeyMessage;
import net.java.otr4j.io.messages.QueryMessage;
import net.java.otr4j.io.messages.RevealSignatureMessage;
import net.java.otr4j.io.messages.SignatureM;
import net.java.otr4j.io.messages.SignatureMessage;
import net.java.otr4j.io.messages.SignatureX;
import net.java.otr4j.session.InstanceTag;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;

public class AuthContext {
    public static final int NONE = 0;
    public static final int AWAITING_DHKEY = 1;
    public static final int AWAITING_REVEALSIG = 2;
    public static final int AWAITING_SIG = 3;
    public static final int V1_SETUP = 4;
    public static final byte C_START = 1;
    public static final byte M1_START = 2;
    public static final byte M2_START = 3;
    public static final byte M1p_START = 4;
    public static final byte M2p_START = 5;
    SecureRandom secureRandom;
    byte[] r;
    KeyPair localDHKeyPair;
    byte[] localDHPublicKeyBytes;
    byte[] localDHPublicKeyHash;
    byte[] localDHPublicKeyEncrypted;
    private Session session;
    private int authenticationState;
    private DHPublicKey remoteDHPublicKey;
    private byte[] remoteDHPublicKeyEncrypted;
    private byte[] remoteDHPublicKeyHash;
    private int localDHPrivateKeyID;
    private BigInteger s;
    private byte[] c;
    private byte[] m1;
    private byte[] m2;
    private byte[] cp;
    private byte[] m1p;
    private byte[] m2p;
    private KeyPair localLongTermKeyPair;
    private Boolean isSecure = false;
    private Logger logger;
    private MessageFactory messageFactory = new MessageFactory();
    private PublicKey remoteLongTermPublicKey;

    public AuthContext(Session session) {
        SessionID sID = session.getSessionID();
        this.logger = Logger.getLogger(sID.getAccountID() + "-->" + sID.getUserID());
        this.setSession(session);
        this.reset();
    }

    public void reset() {
        this.logger.finest("Resetting authentication state.");
        this.authenticationState = 0;
        this.r = null;
        this.remoteDHPublicKey = null;
        this.remoteDHPublicKeyEncrypted = null;
        this.remoteDHPublicKeyHash = null;
        this.localDHKeyPair = null;
        this.localDHPrivateKeyID = 1;
        this.localDHPublicKeyBytes = null;
        this.localDHPublicKeyHash = null;
        this.localDHPublicKeyEncrypted = null;
        this.s = null;
        this.m2p = null;
        this.m1p = null;
        this.cp = null;
        this.m2 = null;
        this.m1 = null;
        this.c = null;
        this.localLongTermKeyPair = null;
        this.setIsSecure(false);
    }

    private void setIsSecure(Boolean isSecure) {
        this.isSecure = isSecure;
    }

    public boolean getIsSecure() {
        return this.isSecure;
    }

    void setAuthenticationState(int authenticationState) {
        this.authenticationState = authenticationState;
    }

    private int getAuthenticationState() {
        return this.authenticationState;
    }

    private byte[] getR() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        if (this.r == null) {
            this.logger.finest("Picking random key r.");
            this.r = new byte[16];
            this.secureRandom.nextBytes(this.r);
        }
        return this.r;
    }

    private void setRemoteDHPublicKey(DHPublicKey dhPublicKey) {
        if (dhPublicKey.getY().compareTo(OtrCryptoEngine.MODULUS_MINUS_TWO) > 0) {
            throw new IllegalArgumentException("Illegal D-H Public Key value, Ignoring message.");
        }
        if (dhPublicKey.getY().compareTo(OtrCryptoEngine.BIGINTEGER_TWO) < 0) {
            throw new IllegalArgumentException("Illegal D-H Public Key value, Ignoring message.");
        }
        this.logger.finest("Received D-H Public Key is a legal value.");
        this.remoteDHPublicKey = dhPublicKey;
    }

    public DHPublicKey getRemoteDHPublicKey() {
        return this.remoteDHPublicKey;
    }

    private void setRemoteDHPublicKeyEncrypted(byte[] remoteDHPublicKeyEncrypted) {
        this.logger.finest("Storing encrypted remote public key.");
        this.remoteDHPublicKeyEncrypted = remoteDHPublicKeyEncrypted;
    }

    private byte[] getRemoteDHPublicKeyEncrypted() {
        return this.remoteDHPublicKeyEncrypted;
    }

    private void setRemoteDHPublicKeyHash(byte[] remoteDHPublicKeyHash) {
        this.logger.finest("Storing encrypted remote public key hash.");
        this.remoteDHPublicKeyHash = remoteDHPublicKeyHash;
    }

    private byte[] getRemoteDHPublicKeyHash() {
        return this.remoteDHPublicKeyHash;
    }

    public KeyPair getLocalDHKeyPair() throws OtrException {
        if (this.localDHKeyPair == null) {
            this.localDHKeyPair = OtrCryptoEngine.generateDHKeyPair();
            this.logger.finest("Generated local D-H key pair.");
        }
        return this.localDHKeyPair;
    }

    private int getLocalDHKeyPairID() {
        return this.localDHPrivateKeyID;
    }

    private byte[] getLocalDHPublicKeyHash() throws OtrException {
        if (this.localDHPublicKeyHash == null) {
            this.localDHPublicKeyHash = OtrCryptoEngine.sha256Hash(this.getLocalDHPublicKeyBytes());
            this.logger.finest("Hashed local D-H public key.");
        }
        return this.localDHPublicKeyHash;
    }

    private byte[] getLocalDHPublicKeyEncrypted() throws OtrException {
        if (this.localDHPublicKeyEncrypted == null) {
            this.localDHPublicKeyEncrypted = OtrCryptoEngine.aesEncrypt(this.getR(), null, this.getLocalDHPublicKeyBytes());
            this.logger.finest("Encrypted our D-H public key.");
        }
        return this.localDHPublicKeyEncrypted;
    }

    public BigInteger getS() throws OtrException {
        if (this.s == null) {
            this.s = OtrCryptoEngine.generateSecret(this.getLocalDHKeyPair().getPrivate(), this.getRemoteDHPublicKey());
            this.logger.finest("Generated shared secret.");
        }
        return this.s;
    }

    private byte[] getC() throws OtrException {
        if (this.c != null) {
            return this.c;
        }
        byte[] h2 = this.h2((byte)1);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        this.c = new byte[16];
        buff.get(this.c);
        this.logger.finest("Computed c.");
        return this.c;
    }

    private byte[] getM1() throws OtrException {
        if (this.m1 != null) {
            return this.m1;
        }
        byte[] h2 = this.h2((byte)2);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] m1 = new byte[32];
        buff.get(m1);
        this.logger.finest("Computed m1.");
        this.m1 = m1;
        return m1;
    }

    byte[] getM2() throws OtrException {
        if (this.m2 != null) {
            return this.m2;
        }
        byte[] h2 = this.h2((byte)3);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] m2 = new byte[32];
        buff.get(m2);
        this.logger.finest("Computed m2.");
        this.m2 = m2;
        return m2;
    }

    private byte[] getCp() throws OtrException {
        if (this.cp != null) {
            return this.cp;
        }
        byte[] h2 = this.h2((byte)1);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] cp = new byte[16];
        buff.position(16);
        buff.get(cp);
        this.logger.finest("Computed c'.");
        this.cp = cp;
        return cp;
    }

    private byte[] getM1p() throws OtrException {
        if (this.m1p != null) {
            return this.m1p;
        }
        byte[] h2 = this.h2((byte)4);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] m1p = new byte[32];
        buff.get(m1p);
        this.m1p = m1p;
        this.logger.finest("Computed m1'.");
        return m1p;
    }

    byte[] getM2p() throws OtrException {
        if (this.m2p != null) {
            return this.m2p;
        }
        byte[] h2 = this.h2((byte)5);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] m2p = new byte[32];
        buff.get(m2p);
        this.m2p = m2p;
        this.logger.finest("Computed m2'.");
        return m2p;
    }

    public KeyPair getLocalLongTermKeyPair() throws OtrException {
        if (this.localLongTermKeyPair == null) {
            this.localLongTermKeyPair = this.getSession().getLocalKeyPair();
        }
        return this.localLongTermKeyPair;
    }

    private byte[] h2(byte b) throws OtrException {
        byte[] secbytes;
        try {
            secbytes = SerializationUtils.writeMpi(this.getS());
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        int len = secbytes.length + 1;
        ByteBuffer buff = ByteBuffer.allocate(len);
        buff.put(b);
        buff.put(secbytes);
        byte[] sdata = buff.array();
        return OtrCryptoEngine.sha256Hash(sdata);
    }

    private byte[] getLocalDHPublicKeyBytes() throws OtrException {
        if (this.localDHPublicKeyBytes == null) {
            try {
                this.localDHPublicKeyBytes = SerializationUtils.writeMpi(((DHPublicKey)this.getLocalDHKeyPair().getPublic()).getY());
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }
        return this.localDHPublicKeyBytes;
    }

    public void handleReceivingMessage(AbstractMessage m) throws OtrException {
        switch (m.messageType) {
            case 2: {
                this.handleDHCommitMessage((DHCommitMessage)m);
                break;
            }
            case 10: {
                this.handleDHKeyMessage((DHKeyMessage)m);
                break;
            }
            case 17: {
                this.handleRevealSignatureMessage((RevealSignatureMessage)m);
                break;
            }
            case 18: {
                this.handleSignatureMessage((SignatureMessage)m);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void handleSignatureMessage(SignatureMessage m) throws OtrException {
        Session session = this.getSession();
        SessionID sessionID = session.getSessionID();
        this.logger.finest(sessionID.getAccountID() + " received a signature message from " + sessionID.getUserID() + " through " + sessionID.getProtocolName() + ".");
        if (m.protocolVersion == 2 && !session.getSessionPolicy().getAllowV2()) {
            this.logger.finest("If ALLOW_V2 is not set, ignore this message.");
            return;
        }
        if (m.protocolVersion == 3 && !session.getSessionPolicy().getAllowV3()) {
            this.logger.finest("If ALLOW_V3 is not set, ignore this message.");
            return;
        }
        if (m.protocolVersion == 3 && session.getSenderInstanceTag().getValue() != m.receiverInstanceTag) {
            this.logger.finest("Received a Signature Message with receiver instance tag that is different from ours, ignore this message");
            return;
        }
        switch (this.getAuthenticationState()) {
            case 3: {
                byte[] signature;
                SignatureX remoteX;
                if (!m.verify(this.getM2p())) {
                    this.logger.finest("Signature MACs are not equal, ignoring message.");
                    return;
                }
                byte[] remoteXDecrypted = m.decrypt(this.getCp());
                try {
                    remoteX = SerializationUtils.toMysteriousX(remoteXDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                PublicKey remoteLongTermPublicKey = remoteX.longTermPublicKey;
                SignatureM remoteM = new SignatureM(this.getRemoteDHPublicKey(), (DHPublicKey)this.getLocalDHKeyPair().getPublic(), remoteLongTermPublicKey, remoteX.dhKeyID);
                try {
                    signature = OtrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(remoteM), this.getM1p());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                if (!OtrCryptoEngine.verify(signature, remoteLongTermPublicKey, remoteX.signature)) {
                    this.logger.finest("Signature verification failed.");
                    return;
                }
                this.setIsSecure(true);
                this.setRemoteLongTermPublicKey(remoteLongTermPublicKey);
                break;
            }
            default: {
                this.logger.finest("We were not expecting a signature, ignoring message.");
                return;
            }
        }
    }

    private void handleRevealSignatureMessage(RevealSignatureMessage m) throws OtrException {
        Session session = this.getSession();
        SessionID sessionID = session.getSessionID();
        this.logger.finest(sessionID.getAccountID() + " received a reveal signature message from " + sessionID.getUserID() + " through " + sessionID.getProtocolName() + ".");
        if (m.protocolVersion == 2 && !session.getSessionPolicy().getAllowV2()) {
            this.logger.finest("If ALLOW_V2 is not set, ignore this message.");
            return;
        }
        if (m.protocolVersion == 3 && !session.getSessionPolicy().getAllowV3()) {
            this.logger.finest("If ALLOW_V3 is not set, ignore this message.");
            return;
        }
        if (m.protocolVersion == 3 && session.getSenderInstanceTag().getValue() != m.receiverInstanceTag) {
            this.logger.finest("Received a Reveal Signature Message with receiver instance tag that is different from ours, ignore this message");
            return;
        }
        switch (this.getAuthenticationState()) {
            case 2: {
                byte[] signature;
                SignatureX remoteX;
                BigInteger remoteDHPublicKeyMpi;
                byte[] remoteDHPublicKeyDecrypted = OtrCryptoEngine.aesDecrypt(m.revealedKey, null, this.getRemoteDHPublicKeyEncrypted());
                byte[] remoteDHPublicKeyHash = OtrCryptoEngine.sha256Hash(remoteDHPublicKeyDecrypted);
                if (!Arrays.equals(remoteDHPublicKeyHash, this.getRemoteDHPublicKeyHash())) {
                    this.logger.finest("Hashes don't match, ignoring message.");
                    return;
                }
                try {
                    remoteDHPublicKeyMpi = SerializationUtils.readMpi(remoteDHPublicKeyDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                this.setRemoteDHPublicKey(OtrCryptoEngine.getDHPublicKey(remoteDHPublicKeyMpi));
                if (!m.verify(this.getM2())) {
                    this.logger.finest("Signature MACs are not equal, ignoring message.");
                    return;
                }
                byte[] remoteXDecrypted = m.decrypt(this.getC());
                try {
                    remoteX = SerializationUtils.toMysteriousX(remoteXDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                PublicKey remoteLongTermPublicKey = remoteX.longTermPublicKey;
                SignatureM remoteM = new SignatureM(this.getRemoteDHPublicKey(), (DHPublicKey)this.getLocalDHKeyPair().getPublic(), remoteLongTermPublicKey, remoteX.dhKeyID);
                try {
                    signature = OtrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(remoteM), this.getM1());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                if (!OtrCryptoEngine.verify(signature, remoteLongTermPublicKey, remoteX.signature)) {
                    this.logger.finest("Signature verification failed.");
                    return;
                }
                this.logger.finest("Signature verification succeeded.");
                this.setAuthenticationState(0);
                this.setIsSecure(true);
                this.setRemoteLongTermPublicKey(remoteLongTermPublicKey);
                this.getSession().injectMessage(this.messageFactory.getSignatureMessage());
                break;
            }
            default: {
                this.logger.finest("Ignoring message.");
            }
        }
    }

    private void handleDHKeyMessage(DHKeyMessage m) throws OtrException {
        Session session = this.getSession();
        SessionID sessionID = session.getSessionID();
        this.logger.finest(sessionID.getAccountID() + " received a D-H key message from " + sessionID.getUserID() + " through " + sessionID.getProtocolName() + ".");
        if (m.protocolVersion == 2 && !session.getSessionPolicy().getAllowV2()) {
            this.logger.finest("If ALLOW_V2 is not set, ignore this message.");
            return;
        }
        if (m.protocolVersion == 3 && !session.getSessionPolicy().getAllowV3()) {
            this.logger.finest("If ALLOW_V3 is not set, ignore this message.");
            return;
        }
        if (m.protocolVersion == 3 && session.getSenderInstanceTag().getValue() != m.receiverInstanceTag) {
            this.logger.finest("Received a D-H Key Message with receiver instance tag that is different from ours, ignore this message");
            return;
        }
        session.setReceiverInstanceTag(new InstanceTag(m.senderInstanceTag));
        switch (this.getAuthenticationState()) {
            case 0: 
            case 1: {
                this.setRemoteDHPublicKey(m.dhPublicKey);
                this.setAuthenticationState(3);
                this.getSession().injectMessage(this.messageFactory.getRevealSignatureMessage());
                this.logger.finest("Sent Reveal Signature.");
                break;
            }
            case 3: {
                if (m.dhPublicKey.getY().equals(this.getRemoteDHPublicKey().getY())) {
                    this.getSession().injectMessage(this.messageFactory.getRevealSignatureMessage());
                    this.logger.finest("Resent Reveal Signature.");
                    break;
                }
                this.logger.finest("Ignoring message.");
                break;
            }
        }
    }

    private void handleDHCommitMessage(DHCommitMessage m) throws OtrException {
        Session session = this.getSession();
        SessionID sessionID = session.getSessionID();
        this.logger.finest(sessionID.getAccountID() + " received a D-H commit message from " + sessionID.getUserID() + " through " + sessionID.getProtocolName() + ".");
        if (m.protocolVersion == 2 && !session.getSessionPolicy().getAllowV2()) {
            this.logger.finest("ALLOW_V2 is not set, ignore this message.");
            return;
        }
        if (m.protocolVersion == 3 && !session.getSessionPolicy().getAllowV3()) {
            this.logger.finest("ALLOW_V3 is not set, ignore this message.");
            return;
        }
        if (m.protocolVersion == 3 && session.getSenderInstanceTag().getValue() != m.receiverInstanceTag && m.receiverInstanceTag != 0) {
            this.logger.finest("Received a D-H commit message with receiver instance tag that is different from ours, ignore this message.");
            return;
        }
        session.setReceiverInstanceTag(new InstanceTag(m.senderInstanceTag));
        switch (this.getAuthenticationState()) {
            case 0: {
                this.reset();
                this.getSession().setProtocolVersion(m.protocolVersion);
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                this.logger.finest("Sent D-H key.");
                break;
            }
            case 1: {
                BigInteger ourHash = new BigInteger(1, this.getLocalDHPublicKeyHash());
                BigInteger theirHash = new BigInteger(1, m.dhPublicKeyHash);
                if (theirHash.compareTo(ourHash) == -1) {
                    this.getSession().injectMessage(this.messageFactory.getDHCommitMessage());
                    this.logger.finest("Ignored the incoming D-H Commit message, but resent our D-H Commit message.");
                    break;
                }
                this.reset();
                this.getSession().setProtocolVersion(m.protocolVersion);
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                this.logger.finest("Forgot our old gx value that we sent (encrypted) earlier, and pretended we're in AUTHSTATE_NONE -> Sent D-H key.");
                break;
            }
            case 2: {
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                this.logger.finest("Sent D-H key.");
                break;
            }
            case 3: {
                this.reset();
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                this.logger.finest("Sent D-H key.");
                break;
            }
            case 4: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void startAuth() throws OtrException {
        this.logger.finest("Starting Authenticated Key Exchange, sending query message");
        this.getSession().injectMessage(this.messageFactory.getQueryMessage());
    }

    public DHCommitMessage respondAuth(Integer version) throws OtrException {
        if (version != 2 && version != 3) {
            throw new OtrException(new Exception("Only allowed versions are: 2, 3"));
        }
        this.logger.finest("Responding to Query Message");
        this.reset();
        this.getSession().setProtocolVersion(version);
        this.setAuthenticationState(1);
        this.logger.finest("Generating D-H Commit.");
        DHCommitMessage message = this.messageFactory.getDHCommitMessage();
        return message;
    }

    private void setSession(Session session) {
        this.session = session;
    }

    private Session getSession() {
        return this.session;
    }

    public PublicKey getRemoteLongTermPublicKey() {
        return this.remoteLongTermPublicKey;
    }

    private void setRemoteLongTermPublicKey(PublicKey pubKey) {
        this.remoteLongTermPublicKey = pubKey;
    }

    class MessageFactory {
        MessageFactory() {
        }

        QueryMessage getQueryMessage() {
            Vector<Integer> versions = new Vector<Integer>();
            versions.add(2);
            versions.add(3);
            return new QueryMessage(versions);
        }

        DHCommitMessage getDHCommitMessage() throws OtrException {
            DHCommitMessage message = new DHCommitMessage(AuthContext.this.getSession().getProtocolVersion(), AuthContext.this.getLocalDHPublicKeyHash(), AuthContext.this.getLocalDHPublicKeyEncrypted());
            message.senderInstanceTag = AuthContext.this.session.getSenderInstanceTag().getValue();
            message.receiverInstanceTag = 0;
            return message;
        }

        DHKeyMessage getDHKeyMessage() throws OtrException {
            DHKeyMessage dhKeyMessage = new DHKeyMessage(AuthContext.this.getSession().getProtocolVersion(), (DHPublicKey)AuthContext.this.getLocalDHKeyPair().getPublic());
            dhKeyMessage.senderInstanceTag = AuthContext.this.getSession().getSenderInstanceTag().getValue();
            dhKeyMessage.receiverInstanceTag = AuthContext.this.getSession().getReceiverInstanceTag().getValue();
            return dhKeyMessage;
        }

        RevealSignatureMessage getRevealSignatureMessage() throws OtrException {
            try {
                SignatureM m = new SignatureM((DHPublicKey)AuthContext.this.getLocalDHKeyPair().getPublic(), AuthContext.this.getRemoteDHPublicKey(), AuthContext.this.getLocalLongTermKeyPair().getPublic(), AuthContext.this.getLocalDHKeyPairID());
                byte[] mhash = OtrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(m), AuthContext.this.getM1());
                byte[] signature = OtrCryptoEngine.sign(mhash, AuthContext.this.getLocalLongTermKeyPair().getPrivate());
                SignatureX mysteriousX = new SignatureX(AuthContext.this.getLocalLongTermKeyPair().getPublic(), AuthContext.this.getLocalDHKeyPairID(), signature);
                byte[] xEncrypted = OtrCryptoEngine.aesEncrypt(AuthContext.this.getC(), null, SerializationUtils.toByteArray(mysteriousX));
                byte[] tmp = SerializationUtils.writeData(xEncrypted);
                byte[] xEncryptedHash = OtrCryptoEngine.sha256Hmac160(tmp, AuthContext.this.getM2());
                RevealSignatureMessage revealSignatureMessage = new RevealSignatureMessage(AuthContext.this.getSession().getProtocolVersion(), xEncrypted, xEncryptedHash, AuthContext.this.getR());
                revealSignatureMessage.senderInstanceTag = AuthContext.this.getSession().getSenderInstanceTag().getValue();
                revealSignatureMessage.receiverInstanceTag = AuthContext.this.getSession().getReceiverInstanceTag().getValue();
                return revealSignatureMessage;
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }

        SignatureMessage getSignatureMessage() throws OtrException {
            byte[] mhash;
            SignatureM m = new SignatureM((DHPublicKey)AuthContext.this.getLocalDHKeyPair().getPublic(), AuthContext.this.getRemoteDHPublicKey(), AuthContext.this.getLocalLongTermKeyPair().getPublic(), AuthContext.this.getLocalDHKeyPairID());
            try {
                mhash = OtrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(m), AuthContext.this.getM1p());
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
            byte[] signature = OtrCryptoEngine.sign(mhash, AuthContext.this.getLocalLongTermKeyPair().getPrivate());
            SignatureX mysteriousX = new SignatureX(AuthContext.this.getLocalLongTermKeyPair().getPublic(), AuthContext.this.getLocalDHKeyPairID(), signature);
            try {
                byte[] xEncrypted = OtrCryptoEngine.aesEncrypt(AuthContext.this.getCp(), null, SerializationUtils.toByteArray(mysteriousX));
                byte[] tmp = SerializationUtils.writeData(xEncrypted);
                byte[] xEncryptedHash = OtrCryptoEngine.sha256Hmac160(tmp, AuthContext.this.getM2p());
                SignatureMessage signatureMessage = new SignatureMessage(AuthContext.this.getSession().getProtocolVersion(), xEncrypted, xEncryptedHash);
                signatureMessage.senderInstanceTag = AuthContext.this.getSession().getSenderInstanceTag().getValue();
                signatureMessage.receiverInstanceTag = AuthContext.this.getSession().getReceiverInstanceTag().getValue();
                return signatureMessage;
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }
    }
}

