/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.IOException;
import java.util.LinkedList;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrPolicy;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;

public class OtrFragmenter {
    private static final String OTRv1_NOT_SUPPORTED = "Fragmentation is not supported in OTRv1.";
    private static final int MAXIMUM_NUMBER_OF_FRAGMENTS = 65535;
    private static final String OTRv3_MESSAGE_FRAGMENT_FORMAT = "?OTR|%08x|%08x,%05d,%05d,%s,";
    private static final String OTRv2_MESSAGE_FRAGMENT_FORMAT = "?OTR,%d,%d,%s,";
    private final Session session;
    private final OtrEngineHost host;

    public OtrFragmenter(Session session, OtrEngineHost host) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.session = session;
        if (host == null) {
            throw new NullPointerException("host cannot be null");
        }
        this.host = host;
    }

    public OtrEngineHost getHost() {
        return this.host;
    }

    public int numberOfFragments(String message) throws IOException {
        SessionID sessionId = this.session.getSessionID();
        int fragmentSize = this.host.getMaxFragmentSize(sessionId);
        if (fragmentSize >= message.length()) {
            return 1;
        }
        return this.computeFragmentNumber(message, fragmentSize);
    }

    private int computeFragmentNumber(String message, int fragmentSize) throws IOException {
        int overhead = this.computeHeaderSize();
        int payloadSize = fragmentSize - overhead;
        if (payloadSize <= 0) {
            throw new IOException("Fragment size too small for storing content.");
        }
        int messages = message.length() / payloadSize;
        if (message.length() % payloadSize != 0) {
            ++messages;
        }
        return messages;
    }

    public String[] fragment(String message) throws IOException {
        SessionID sessionId = this.session.getSessionID();
        int fragmentSize = this.host.getMaxFragmentSize(sessionId);
        return this.fragment(message, fragmentSize);
    }

    private String[] fragment(String message, int fragmentSize) throws IOException {
        if (fragmentSize >= message.length()) {
            return new String[]{message};
        }
        int num = this.computeFragmentNumber(message, fragmentSize);
        if (num > 65535) {
            throw new IOException("Number of necessary fragments exceeds limit.");
        }
        int payloadSize = fragmentSize - this.computeHeaderSize();
        int previous = 0;
        LinkedList<String> fragments = new LinkedList<String>();
        while (previous < message.length()) {
            int end = Math.min(previous + payloadSize, message.length());
            String partialContent = message.substring(previous, end);
            fragments.add(this.createMessageFragment(fragments.size(), num, partialContent));
            previous = end;
        }
        return fragments.toArray(new String[fragments.size()]);
    }

    private String createMessageFragment(int count, int total, String partialContent) {
        if (this.getPolicy().getAllowV3()) {
            return this.createV3MessageFragment(count, total, partialContent);
        }
        return this.createV2MessageFragment(count, total, partialContent);
    }

    private String createV3MessageFragment(int count, int total, String partialContent) {
        String msg = String.format(OTRv3_MESSAGE_FRAGMENT_FORMAT, this.getSenderInstance(), this.getReceiverInstance(), count + 1, total, partialContent);
        return msg;
    }

    private String createV2MessageFragment(int count, int total, String partialContent) {
        String msg = String.format(OTRv2_MESSAGE_FRAGMENT_FORMAT, count + 1, total, partialContent);
        return msg;
    }

    private int computeHeaderSize() {
        if (this.getPolicy().getAllowV3()) {
            return OtrFragmenter.computeHeaderV3Size();
        }
        if (this.getPolicy().getAllowV2()) {
            return OtrFragmenter.computeHeaderV2Size();
        }
        throw new UnsupportedOperationException(OTRv1_NOT_SUPPORTED);
    }

    static int computeHeaderV3Size() {
        return 36;
    }

    static int computeHeaderV2Size() {
        return 18;
    }

    private OtrPolicy getPolicy() {
        return this.session.getSessionPolicy();
    }

    private int getSenderInstance() {
        return this.session.getSenderInstanceTag().getValue();
    }

    private int getReceiverInstance() {
        return this.session.getReceiverInstanceTag().getValue();
    }
}

