/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrEngineListener;
import net.java.otr4j.OtrException;
import net.java.otr4j.OtrPolicy;
import net.java.otr4j.crypto.OtrCryptoEngine;
import net.java.otr4j.io.OtrInputStream;
import net.java.otr4j.io.OtrOutputStream;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.io.messages.AbstractEncodedMessage;
import net.java.otr4j.io.messages.AbstractMessage;
import net.java.otr4j.io.messages.DHCommitMessage;
import net.java.otr4j.io.messages.DataMessage;
import net.java.otr4j.io.messages.ErrorMessage;
import net.java.otr4j.io.messages.MysteriousT;
import net.java.otr4j.io.messages.PlainTextMessage;
import net.java.otr4j.io.messages.QueryMessage;
import net.java.otr4j.session.AuthContext;
import net.java.otr4j.session.InstanceTag;
import net.java.otr4j.session.OfferStatus;
import net.java.otr4j.session.OtrAssembler;
import net.java.otr4j.session.OtrFragmenter;
import net.java.otr4j.session.SessionID;
import net.java.otr4j.session.SessionKeys;
import net.java.otr4j.session.SessionStatus;
import net.java.otr4j.session.SmpTlvHandler;
import net.java.otr4j.session.TLV;
import net.java.otr4j.session.UnknownInstanceException;

public class Session {
    private Map<InstanceTag, Session> slaveSessions;
    private volatile Session outgoingSession;
    private final boolean isMasterSession;
    private SessionID sessionID;
    private OtrEngineHost host;
    private SessionStatus sessionStatus;
    private AuthContext authContext;
    private SessionKeys[][] sessionKeys;
    private Vector<byte[]> oldMacKeys;
    private Logger logger;
    private SmpTlvHandler smpTlvHandler;
    private BigInteger ess;
    private OfferStatus offerStatus;
    private final InstanceTag senderTag;
    private InstanceTag receiverTag;
    private int protocolVersion;
    private OtrAssembler assembler;
    private final OtrFragmenter fragmenter;
    private PublicKey remotePublicKey;
    private List<OtrEngineListener> listeners = new Vector<OtrEngineListener>();

    public Session(SessionID sessionID, OtrEngineHost listener) {
        this.setSessionID(sessionID);
        this.setHost(listener);
        this.sessionStatus = SessionStatus.PLAINTEXT;
        this.offerStatus = OfferStatus.idle;
        this.senderTag = new InstanceTag();
        this.receiverTag = InstanceTag.ZERO_TAG;
        this.slaveSessions = new HashMap<InstanceTag, Session>();
        this.outgoingSession = this;
        this.isMasterSession = true;
        this.assembler = new OtrAssembler(this.getSenderInstanceTag());
        this.fragmenter = new OtrFragmenter(this.outgoingSession, listener);
    }

    private Session(SessionID sessionID, OtrEngineHost listener, InstanceTag senderTag, InstanceTag receiverTag) {
        this.setSessionID(sessionID);
        this.setHost(listener);
        this.sessionStatus = SessionStatus.PLAINTEXT;
        this.offerStatus = OfferStatus.idle;
        this.senderTag = senderTag;
        this.receiverTag = receiverTag;
        this.outgoingSession = this;
        this.isMasterSession = false;
        this.protocolVersion = 3;
        this.assembler = new OtrAssembler(this.getSenderInstanceTag());
        this.fragmenter = new OtrFragmenter(this.outgoingSession, listener);
    }

    public BigInteger getS() {
        return this.ess;
    }

    private SessionKeys getEncryptionSessionKeys() {
        this.logger.finest("Getting encryption keys");
        return this.getSessionKeysByIndex(0, 1);
    }

    private SessionKeys getMostRecentSessionKeys() {
        this.logger.finest("Getting most recent keys.");
        return this.getSessionKeysByIndex(1, 1);
    }

    private SessionKeys getSessionKeysByID(int localKeyID, int remoteKeyID) {
        this.logger.finest("Searching for session keys with (localKeyID, remoteKeyID) = (" + localKeyID + "," + remoteKeyID + ")");
        for (int i = 0; i < this.getSessionKeys().length; ++i) {
            for (int j = 0; j < this.getSessionKeys()[i].length; ++j) {
                SessionKeys current = this.getSessionKeysByIndex(i, j);
                if (current.getLocalKeyID() != localKeyID || current.getRemoteKeyID() != remoteKeyID) continue;
                this.logger.finest("Matching keys found.");
                return current;
            }
        }
        return null;
    }

    private SessionKeys getSessionKeysByIndex(int localKeyIndex, int remoteKeyIndex) {
        if (this.getSessionKeys()[localKeyIndex][remoteKeyIndex] == null) {
            this.getSessionKeys()[localKeyIndex][remoteKeyIndex] = new SessionKeys(localKeyIndex, remoteKeyIndex);
        }
        return this.getSessionKeys()[localKeyIndex][remoteKeyIndex];
    }

    private void rotateRemoteSessionKeys(DHPublicKey pubKey) throws OtrException {
        SessionKeys sess2;
        this.logger.finest("Rotating remote keys.");
        SessionKeys sess1 = this.getSessionKeysByIndex(1, 0);
        if (sess1.getIsUsedReceivingMACKey().booleanValue()) {
            this.logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess1.getReceivingMACKey());
        }
        if ((sess2 = this.getSessionKeysByIndex(0, 0)).getIsUsedReceivingMACKey().booleanValue()) {
            this.logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess2.getReceivingMACKey());
        }
        SessionKeys sess3 = this.getSessionKeysByIndex(1, 1);
        sess1.setRemoteDHPublicKey(sess3.getRemoteKey(), sess3.getRemoteKeyID());
        SessionKeys sess4 = this.getSessionKeysByIndex(0, 1);
        sess2.setRemoteDHPublicKey(sess4.getRemoteKey(), sess4.getRemoteKeyID());
        sess3.setRemoteDHPublicKey(pubKey, sess3.getRemoteKeyID() + 1);
        sess4.setRemoteDHPublicKey(pubKey, sess4.getRemoteKeyID() + 1);
    }

    private void rotateLocalSessionKeys() throws OtrException {
        SessionKeys sess2;
        this.logger.finest("Rotating local keys.");
        SessionKeys sess1 = this.getSessionKeysByIndex(0, 1);
        if (sess1.getIsUsedReceivingMACKey().booleanValue()) {
            this.logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess1.getReceivingMACKey());
        }
        if ((sess2 = this.getSessionKeysByIndex(0, 0)).getIsUsedReceivingMACKey().booleanValue()) {
            this.logger.finest("Detected used Receiving MAC key. Adding to old MAC keys to reveal it.");
            this.getOldMacKeys().add(sess2.getReceivingMACKey());
        }
        SessionKeys sess3 = this.getSessionKeysByIndex(1, 1);
        sess1.setLocalPair(sess3.getLocalPair(), sess3.getLocalKeyID());
        SessionKeys sess4 = this.getSessionKeysByIndex(1, 0);
        sess2.setLocalPair(sess4.getLocalPair(), sess4.getLocalKeyID());
        KeyPair newPair = OtrCryptoEngine.generateDHKeyPair();
        sess3.setLocalPair(newPair, sess3.getLocalKeyID() + 1);
        sess4.setLocalPair(newPair, sess4.getLocalKeyID() + 1);
    }

    private byte[] collectOldMacKeys() {
        this.logger.finest("Collecting old MAC keys to be revealed.");
        int len = 0;
        for (int i = 0; i < this.getOldMacKeys().size(); ++i) {
            len += this.getOldMacKeys().get(i).length;
        }
        ByteBuffer buff = ByteBuffer.allocate(len);
        for (int i = 0; i < this.getOldMacKeys().size(); ++i) {
            buff.put(this.getOldMacKeys().get(i));
        }
        this.getOldMacKeys().clear();
        return buff.array();
    }

    private void setSessionStatus(SessionStatus sessionStatus) throws OtrException {
        switch (sessionStatus) {
            case ENCRYPTED: {
                AuthContext auth = this.getAuthContext();
                this.ess = auth.getS();
                this.logger.finest("Setting most recent session keys from auth.");
                for (int i = 0; i < this.getSessionKeys()[0].length; ++i) {
                    SessionKeys current = this.getSessionKeysByIndex(0, i);
                    current.setLocalPair(auth.getLocalDHKeyPair(), 1);
                    current.setRemoteDHPublicKey(auth.getRemoteDHPublicKey(), 1);
                    current.setS(auth.getS());
                }
                KeyPair nextDH = OtrCryptoEngine.generateDHKeyPair();
                for (int i = 0; i < this.getSessionKeys()[1].length; ++i) {
                    SessionKeys current = this.getSessionKeysByIndex(1, i);
                    current.setRemoteDHPublicKey(auth.getRemoteDHPublicKey(), 1);
                    current.setLocalPair(nextDH, 2);
                }
                this.setRemotePublicKey(auth.getRemoteLongTermPublicKey());
                auth.reset();
                this.getSmpTlvHandler().reset();
                break;
            }
        }
        if (sessionStatus == this.sessionStatus) {
            return;
        }
        this.sessionStatus = sessionStatus;
        for (OtrEngineListener l : this.listeners) {
            l.sessionStatusChanged(this.getSessionID());
        }
    }

    public SessionStatus getSessionStatus() {
        if (this != this.outgoingSession && this.getProtocolVersion() == 3) {
            return this.outgoingSession.getSessionStatus();
        }
        return this.sessionStatus;
    }

    private void setSessionID(SessionID sessionID) {
        this.logger = Logger.getLogger(sessionID.getAccountID() + "-->" + sessionID.getUserID());
        this.sessionID = sessionID;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    private void setHost(OtrEngineHost host) {
        this.host = host;
    }

    OtrEngineHost getHost() {
        return this.host;
    }

    private SmpTlvHandler getSmpTlvHandler() {
        if (this.smpTlvHandler == null) {
            this.smpTlvHandler = new SmpTlvHandler(this);
        }
        return this.smpTlvHandler;
    }

    private SessionKeys[][] getSessionKeys() {
        if (this.sessionKeys == null) {
            this.sessionKeys = new SessionKeys[2][2];
        }
        return this.sessionKeys;
    }

    AuthContext getAuthContext() {
        if (this.authContext == null) {
            this.authContext = new AuthContext(this);
        }
        return this.authContext;
    }

    private Vector<byte[]> getOldMacKeys() {
        if (this.oldMacKeys == null) {
            this.oldMacKeys = new Vector();
        }
        return this.oldMacKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformReceiving(String msgText) throws OtrException {
        AbstractMessage m;
        OtrPolicy policy = this.getSessionPolicy();
        if (!(policy.getAllowV1() || policy.getAllowV2() || policy.getAllowV3())) {
            this.logger.finest("Policy does not allow neither V1 nor V2 & V3, ignoring message.");
            return msgText;
        }
        try {
            msgText = this.assembler.accumulate(msgText);
        }
        catch (UnknownInstanceException e) {
            this.logger.finest(e.getMessage());
            this.getHost().messageFromAnotherInstanceReceived(this.getSessionID());
            return null;
        }
        catch (ProtocolException e) {
            this.logger.warning("An invalid message fragment was discarded.");
            return null;
        }
        if (msgText == null) {
            return null;
        }
        try {
            m = SerializationUtils.toMessage(msgText);
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        if (m == null) {
            return msgText;
        }
        if (m.messageType != 258) {
            this.offerStatus = OfferStatus.accepted;
        } else if (this.offerStatus == OfferStatus.sent) {
            this.offerStatus = OfferStatus.rejected;
        }
        if (m instanceof AbstractEncodedMessage && this.isMasterSession) {
            AbstractEncodedMessage encodedM = (AbstractEncodedMessage)m;
            if (encodedM.protocolVersion == 3) {
                if (encodedM.receiverInstanceTag != this.getSenderInstanceTag().getValue() && (encodedM.messageType != 2 || encodedM.receiverInstanceTag != 0)) {
                    this.logger.finest("Received an encoded message with receiver instance tag that is different from ours, ignore this message");
                    this.getHost().messageFromAnotherInstanceReceived(this.getSessionID());
                    return null;
                }
                if (encodedM.senderInstanceTag != this.getReceiverInstanceTag().getValue() && this.getReceiverInstanceTag().getValue() != 0) {
                    this.logger.finest("Received an encoded message from a different instance. Our buddymay be logged from multiple locations.");
                    InstanceTag newReceiverTag = new InstanceTag(encodedM.senderInstanceTag);
                    Map<InstanceTag, Session> map = this.slaveSessions;
                    synchronized (map) {
                        if (!this.slaveSessions.containsKey(newReceiverTag)) {
                            Session session = new Session(this.sessionID, this.getHost(), this.getSenderInstanceTag(), newReceiverTag);
                            if (encodedM.messageType == 10) {
                                session.getAuthContext().r = this.getAuthContext().r;
                                session.getAuthContext().localDHKeyPair = this.getAuthContext().localDHKeyPair;
                                session.getAuthContext().localDHPublicKeyBytes = this.getAuthContext().localDHPublicKeyBytes;
                                session.getAuthContext().localDHPublicKeyEncrypted = this.getAuthContext().localDHPublicKeyEncrypted;
                                session.getAuthContext().localDHPublicKeyHash = this.getAuthContext().localDHPublicKeyHash;
                            }
                            session.addOtrEngineListener(new OtrEngineListener(){

                                @Override
                                public void sessionStatusChanged(SessionID sessionID) {
                                    for (OtrEngineListener l : Session.this.listeners) {
                                        l.sessionStatusChanged(sessionID);
                                    }
                                }

                                @Override
                                public void multipleInstancesDetected(SessionID sessionID) {
                                }

                                @Override
                                public void outgoingSessionChanged(SessionID sessionID) {
                                }
                            });
                            this.slaveSessions.put(newReceiverTag, session);
                            this.getHost().multipleInstancesDetected(this.sessionID);
                            for (OtrEngineListener l : this.listeners) {
                                l.multipleInstancesDetected(this.sessionID);
                            }
                        }
                    }
                    return this.slaveSessions.get(newReceiverTag).transformReceiving(msgText);
                }
            }
        }
        switch (m.messageType) {
            case 3: {
                return this.handleDataMessage((DataMessage)m);
            }
            case 255: {
                this.handleErrorMessage((ErrorMessage)m);
                return null;
            }
            case 258: {
                return this.handlePlainTextMessage((PlainTextMessage)m);
            }
            case 256: {
                this.handleQueryMessage((QueryMessage)m);
                return null;
            }
            case 2: 
            case 10: 
            case 17: 
            case 18: {
                AuthContext auth = this.getAuthContext();
                auth.handleReceivingMessage(m);
                if (auth.getIsSecure()) {
                    this.setSessionStatus(SessionStatus.ENCRYPTED);
                    this.logger.finest("Gone Secure.");
                }
                return null;
            }
        }
        throw new UnsupportedOperationException("Received an unknown message type.");
    }

    private void handleQueryMessage(QueryMessage queryMessage) throws OtrException {
        this.logger.finest(this.getSessionID().getAccountID() + " received a query message from " + this.getSessionID().getUserID() + " through " + this.getSessionID().getProtocolName() + ".");
        OtrPolicy policy = this.getSessionPolicy();
        if (queryMessage.versions.contains(3) && policy.getAllowV3()) {
            this.logger.finest("Query message with V3 support found.");
            DHCommitMessage dhCommit = this.getAuthContext().respondAuth(3);
            if (this.isMasterSession) {
                for (Session session : this.slaveSessions.values()) {
                    session.getAuthContext().reset();
                    session.getAuthContext().r = this.getAuthContext().r;
                    session.getAuthContext().localDHKeyPair = this.getAuthContext().localDHKeyPair;
                    session.getAuthContext().localDHPublicKeyBytes = this.getAuthContext().localDHPublicKeyBytes;
                    session.getAuthContext().localDHPublicKeyEncrypted = this.getAuthContext().localDHPublicKeyEncrypted;
                    session.getAuthContext().localDHPublicKeyHash = this.getAuthContext().localDHPublicKeyHash;
                }
            }
            this.injectMessage(dhCommit);
        } else if (queryMessage.versions.contains(2) && policy.getAllowV2()) {
            this.logger.finest("Query message with V2 support found.");
            DHCommitMessage dhCommit = this.getAuthContext().respondAuth(2);
            this.logger.finest("Sending D-H Commit Message");
            this.injectMessage(dhCommit);
        } else if (queryMessage.versions.contains(1) && policy.getAllowV1()) {
            this.logger.finest("Query message with V1 support found - ignoring.");
        }
    }

    private void handleErrorMessage(ErrorMessage errorMessage) throws OtrException {
        this.logger.finest(this.getSessionID().getAccountID() + " received an error message from " + this.getSessionID().getUserID() + " through " + this.getSessionID().getUserID() + ".");
        this.getHost().showError(this.getSessionID(), errorMessage.error);
        OtrPolicy policy = this.getSessionPolicy();
        if (policy.getErrorStartAKE() && this.getSessionStatus() == SessionStatus.ENCRYPTED) {
            this.logger.finest("Error message starts AKE.");
            Vector<Integer> versions = new Vector<Integer>();
            if (policy.getAllowV1()) {
                versions.add(1);
            }
            if (policy.getAllowV2()) {
                versions.add(2);
            }
            if (policy.getAllowV3()) {
                versions.add(3);
            }
            this.logger.finest("Sending Query");
            this.injectMessage(new QueryMessage(versions));
        }
    }

    private String handleDataMessage(DataMessage data) throws OtrException {
        this.logger.finest(this.getSessionID().getAccountID() + " received a data message from " + this.getSessionID().getUserID() + ".");
        switch (this.getSessionStatus()) {
            case ENCRYPTED: {
                byte[] serializedT;
                this.logger.finest("Message state is ENCRYPTED. Trying to decrypt message.");
                int senderKeyID = data.senderKeyID;
                int receipientKeyID = data.recipientKeyID;
                SessionKeys matchingKeys = this.getSessionKeysByID(receipientKeyID, senderKeyID);
                if (matchingKeys == null) {
                    this.logger.finest("No matching keys found.");
                    this.getHost().unreadableMessageReceived(this.getSessionID());
                    this.injectMessage(new ErrorMessage(255, this.getHost().getReplyForUnreadableMessage(this.getSessionID())));
                    return null;
                }
                this.logger.finest("Transforming T to byte[] to calculate it's HmacSHA1.");
                try {
                    serializedT = SerializationUtils.toByteArray(data.getT());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                byte[] computedMAC = OtrCryptoEngine.sha1Hmac(serializedT, matchingKeys.getReceivingMACKey(), 20);
                if (!Arrays.equals(computedMAC, data.mac)) {
                    this.logger.finest("MAC verification failed, ignoring message");
                    this.getHost().unreadableMessageReceived(this.getSessionID());
                    this.injectMessage(new ErrorMessage(255, this.getHost().getReplyForUnreadableMessage(this.getSessionID())));
                    return null;
                }
                this.logger.finest("Computed HmacSHA1 value matches sent one.");
                matchingKeys.setIsUsedReceivingMACKey(true);
                matchingKeys.setReceivingCtr(data.ctr);
                byte[] dmc = OtrCryptoEngine.aesDecrypt(matchingKeys.getReceivingAESKey(), matchingKeys.getReceivingCtr(), data.encryptedMessage);
                SessionKeys mostRecent = this.getMostRecentSessionKeys();
                if (mostRecent.getLocalKeyID() == receipientKeyID) {
                    this.rotateLocalSessionKeys();
                }
                if (mostRecent.getRemoteKeyID() == senderKeyID) {
                    this.rotateRemoteSessionKeys(data.nextDH);
                }
                int tlvIndex = dmc.length;
                for (int i = 0; i < dmc.length; ++i) {
                    if (dmc[i] != 0) continue;
                    tlvIndex = i;
                    break;
                }
                String decryptedMsgContent = new String(dmc, 0, tlvIndex, SerializationUtils.UTF8);
                Vector<TLV> tlvs = null;
                if (++tlvIndex < dmc.length) {
                    byte[] tlvsb = new byte[dmc.length - tlvIndex];
                    System.arraycopy(dmc, tlvIndex, tlvsb, 0, tlvsb.length);
                    tlvs = new Vector<TLV>();
                    ByteArrayInputStream tin = new ByteArrayInputStream(tlvsb);
                    while (tin.available() > 0) {
                        byte[] tdata;
                        int type;
                        OtrInputStream eois = new OtrInputStream(tin);
                        try {
                            type = eois.readShort();
                            tdata = eois.readTlvData();
                            eois.close();
                        }
                        catch (IOException e) {
                            throw new OtrException(e);
                        }
                        tlvs.add(new TLV(type, tdata));
                    }
                }
                if (tlvs != null && tlvs.size() > 0) {
                    block20: for (TLV tlv : tlvs) {
                        switch (tlv.getType()) {
                            case 0: {
                                continue block20;
                            }
                            case 1: {
                                this.setSessionStatus(SessionStatus.FINISHED);
                                continue block20;
                            }
                            case 7: {
                                this.getSmpTlvHandler().processTlvSMP1Q(tlv);
                                continue block20;
                            }
                            case 2: {
                                this.getSmpTlvHandler().processTlvSMP1(tlv);
                                continue block20;
                            }
                            case 3: {
                                this.getSmpTlvHandler().processTlvSMP2(tlv);
                                continue block20;
                            }
                            case 4: {
                                this.getSmpTlvHandler().processTlvSMP3(tlv);
                                continue block20;
                            }
                            case 5: {
                                this.getSmpTlvHandler().processTlvSMP4(tlv);
                                continue block20;
                            }
                            case 6: {
                                this.getSmpTlvHandler().processTlvSMP_ABORT(tlv);
                                continue block20;
                            }
                        }
                        this.logger.warning("Unsupported TLV #" + tlv.getType() + " received!");
                    }
                }
                return decryptedMsgContent;
            }
            case FINISHED: 
            case PLAINTEXT: {
                this.getHost().unreadableMessageReceived(this.getSessionID());
                this.injectMessage(new ErrorMessage(255, this.getHost().getReplyForUnreadableMessage(this.getSessionID())));
            }
        }
        return null;
    }

    public void injectMessage(AbstractMessage m) throws OtrException {
        String msg;
        try {
            msg = SerializationUtils.toString(m);
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        if (m instanceof QueryMessage) {
            String fallback = this.getHost().getFallbackMessage(this.getSessionID());
            if (fallback == null || fallback.equals("")) {
                fallback = "Your contact is requesting to start an encrypted chat. Please install an app that supports OTR: https://github.com/otr4j/otr4j/wiki/Apps";
            }
            msg = msg + fallback;
        }
        if (SerializationUtils.otrEncoded(msg)) {
            try {
                String[] fragments;
                for (String fragment : fragments = this.fragmenter.fragment(msg)) {
                    this.getHost().injectMessage(this.getSessionID(), fragment);
                }
            }
            catch (IOException e) {
                this.logger.warning("Failed to fragment message according to provided instructions.");
                throw new OtrException(e);
            }
        } else {
            this.getHost().injectMessage(this.getSessionID(), msg);
        }
    }

    private String handlePlainTextMessage(PlainTextMessage plainTextMessage) throws OtrException {
        this.logger.finest(this.getSessionID().getAccountID() + " received a plaintext message from " + this.getSessionID().getUserID() + " through " + this.getSessionID().getProtocolName() + ".");
        OtrPolicy policy = this.getSessionPolicy();
        List versions = plainTextMessage.versions;
        if (versions == null || versions.size() < 1) {
            this.logger.finest("Received plaintext message without the whitespace tag.");
            switch (this.getSessionStatus()) {
                case ENCRYPTED: 
                case FINISHED: {
                    this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                    return plainTextMessage.cleanText;
                }
                case PLAINTEXT: {
                    if (policy.getRequireEncryption()) {
                        this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                    }
                    return plainTextMessage.cleanText;
                }
            }
        } else {
            this.logger.finest("Received plaintext message with the whitespace tag.");
            switch (this.getSessionStatus()) {
                case ENCRYPTED: 
                case FINISHED: {
                    this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                }
                case PLAINTEXT: {
                    if (!policy.getRequireEncryption()) break;
                    this.getHost().unencryptedMessageReceived(this.sessionID, plainTextMessage.cleanText);
                }
            }
            if (policy.getWhitespaceStartAKE()) {
                this.logger.finest("WHITESPACE_START_AKE is set");
                if (plainTextMessage.versions.contains(3) && policy.getAllowV3()) {
                    this.logger.finest("V3 tag found.");
                    try {
                        DHCommitMessage dhCommit = this.getAuthContext().respondAuth(3);
                        if (this.isMasterSession) {
                            for (Session session : this.slaveSessions.values()) {
                                session.getAuthContext().reset();
                                session.getAuthContext().r = this.getAuthContext().r;
                                session.getAuthContext().localDHKeyPair = this.getAuthContext().localDHKeyPair;
                                session.getAuthContext().localDHPublicKeyBytes = this.getAuthContext().localDHPublicKeyBytes;
                                session.getAuthContext().localDHPublicKeyEncrypted = this.getAuthContext().localDHPublicKeyEncrypted;
                                session.getAuthContext().localDHPublicKeyHash = this.getAuthContext().localDHPublicKeyHash;
                            }
                        }
                        this.logger.finest("Sending D-H Commit Message");
                        this.injectMessage(dhCommit);
                    }
                    catch (OtrException dhCommit) {}
                } else if (plainTextMessage.versions.contains(2) && policy.getAllowV2()) {
                    this.logger.finest("V2 tag found.");
                    try {
                        DHCommitMessage dhCommit = this.getAuthContext().respondAuth(2);
                        this.logger.finest("Sending D-H Commit Message");
                        this.injectMessage(dhCommit);
                    }
                    catch (OtrException otrException) {}
                } else if (plainTextMessage.versions.contains(1) && policy.getAllowV1()) {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return plainTextMessage.cleanText;
    }

    public String[] transformSending(String msgText) throws OtrException {
        return this.transformSending(msgText, null);
    }

    public String[] transformSending(String msgText, List<TLV> tlvs) throws OtrException {
        if (this.isMasterSession && this.outgoingSession != this && this.getProtocolVersion() == 3) {
            return this.outgoingSession.transformSending(msgText, tlvs);
        }
        switch (this.getSessionStatus()) {
            case PLAINTEXT: {
                OtrPolicy otrPolicy = this.getSessionPolicy();
                if (otrPolicy.getRequireEncryption()) {
                    this.startSession();
                    this.getHost().requireEncryptedMessage(this.sessionID, msgText);
                    return null;
                }
                if (otrPolicy.getSendWhitespaceTag() && this.offerStatus != OfferStatus.rejected) {
                    this.offerStatus = OfferStatus.sent;
                    Vector<Integer> versions = new Vector<Integer>();
                    if (otrPolicy.getAllowV1()) {
                        versions.add(1);
                    }
                    if (otrPolicy.getAllowV2()) {
                        versions.add(2);
                    }
                    if (otrPolicy.getAllowV3()) {
                        versions.add(3);
                    }
                    if (versions.isEmpty()) {
                        versions = null;
                    }
                    PlainTextMessage abstractMessage = new PlainTextMessage(versions, msgText);
                    try {
                        return new String[]{SerializationUtils.toString(abstractMessage)};
                    }
                    catch (IOException e) {
                        throw new OtrException(e);
                    }
                }
                return new String[]{msgText};
            }
            case ENCRYPTED: {
                byte[] serializedT;
                this.logger.finest(this.getSessionID().getAccountID() + " sends an encrypted message to " + this.getSessionID().getUserID() + " through " + this.getSessionID().getProtocolName() + ".");
                SessionKeys encryptionKeys = this.getEncryptionSessionKeys();
                int senderKeyID = encryptionKeys.getLocalKeyID();
                int receipientKeyID = encryptionKeys.getRemoteKeyID();
                encryptionKeys.incrementSendingCtr();
                byte[] ctr = encryptionKeys.getSendingCtr();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (msgText != null && msgText.length() > 0) {
                    try {
                        out.write(SerializationUtils.convertTextToBytes(msgText));
                    }
                    catch (IOException e) {
                        throw new OtrException(e);
                    }
                }
                if (tlvs != null && tlvs.size() > 0) {
                    out.write(0);
                    OtrOutputStream eoos = new OtrOutputStream(out);
                    for (TLV tlv : tlvs) {
                        try {
                            eoos.writeShort(tlv.type);
                            eoos.writeTlvData(tlv.value);
                            eoos.close();
                        }
                        catch (IOException e) {
                            throw new OtrException(e);
                        }
                    }
                }
                byte[] data = out.toByteArray();
                this.logger.finest("Encrypting message with keyids (localKeyID, remoteKeyID) = (" + senderKeyID + ", " + receipientKeyID + ")");
                byte[] encryptedMsg = OtrCryptoEngine.aesEncrypt(encryptionKeys.getSendingAESKey(), ctr, data);
                SessionKeys mostRecentKeys = this.getMostRecentSessionKeys();
                DHPublicKey nextDH = (DHPublicKey)mostRecentKeys.getLocalPair().getPublic();
                MysteriousT t = new MysteriousT(this.protocolVersion, this.getSenderInstanceTag().getValue(), this.getReceiverInstanceTag().getValue(), 0, senderKeyID, receipientKeyID, nextDH, ctr, encryptedMsg);
                byte[] sendingMACKey = encryptionKeys.getSendingMACKey();
                this.logger.finest("Transforming T to byte[] to calculate it's HmacSHA1.");
                try {
                    serializedT = SerializationUtils.toByteArray(t);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                byte[] mac = OtrCryptoEngine.sha1Hmac(serializedT, sendingMACKey, 20);
                byte[] oldKeys = this.collectOldMacKeys();
                DataMessage m = new DataMessage(t, mac, oldKeys);
                m.senderInstanceTag = this.getSenderInstanceTag().getValue();
                m.receiverInstanceTag = this.getReceiverInstanceTag().getValue();
                try {
                    String completeMessage = SerializationUtils.toString(m);
                    return this.fragmenter.fragment(completeMessage);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
            }
            case FINISHED: {
                this.getHost().finishedSessionMessage(this.sessionID, msgText);
                return null;
            }
        }
        throw new OtrException("Unknown message state, not processing");
    }

    public void startSession() throws OtrException {
        if (this != this.outgoingSession && this.getProtocolVersion() == 3) {
            this.outgoingSession.startSession();
            return;
        }
        if (this.getSessionStatus() == SessionStatus.ENCRYPTED) {
            return;
        }
        if (!this.getSessionPolicy().getAllowV2() || !this.getSessionPolicy().getAllowV3()) {
            throw new UnsupportedOperationException();
        }
        this.getAuthContext().startAuth();
    }

    public void endSession() throws OtrException {
        if (this != this.outgoingSession && this.getProtocolVersion() == 3) {
            this.outgoingSession.endSession();
            return;
        }
        SessionStatus status = this.getSessionStatus();
        switch (status) {
            case ENCRYPTED: {
                String[] msg;
                Vector<TLV> tlvs = new Vector<TLV>();
                tlvs.add(new TLV(1, null));
                for (String part : msg = this.transformSending(null, tlvs)) {
                    this.getHost().injectMessage(this.getSessionID(), part);
                }
                this.setSessionStatus(SessionStatus.PLAINTEXT);
                break;
            }
            case FINISHED: {
                this.setSessionStatus(SessionStatus.PLAINTEXT);
                break;
            }
            case PLAINTEXT: {
                return;
            }
        }
    }

    public void refreshSession() throws OtrException {
        this.endSession();
        this.startSession();
    }

    private void setRemotePublicKey(PublicKey pubKey) {
        this.remotePublicKey = pubKey;
    }

    public PublicKey getRemotePublicKey() {
        if (this != this.outgoingSession && this.getProtocolVersion() == 3) {
            return this.outgoingSession.getRemotePublicKey();
        }
        return this.remotePublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public OtrPolicy getSessionPolicy() {
        return this.getHost().getSessionPolicy(this.getSessionID());
    }

    public KeyPair getLocalKeyPair() throws OtrException {
        return this.getHost().getLocalKeyPair(this.getSessionID());
    }

    public void initSmp(String question, String secret) throws OtrException {
        String[] msg;
        if (this != this.outgoingSession && this.getProtocolVersion() == 3) {
            this.outgoingSession.initSmp(question, secret);
            return;
        }
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.getSmpTlvHandler().initRespondSmp(question, secret, true);
        for (String part : msg = this.transformSending("", tlvs)) {
            this.getHost().injectMessage(this.getSessionID(), part);
        }
    }

    public void respondSmp(String question, String secret) throws OtrException {
        String[] msg;
        if (this != this.outgoingSession && this.getProtocolVersion() == 3) {
            this.outgoingSession.respondSmp(question, secret);
            return;
        }
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.getSmpTlvHandler().initRespondSmp(question, secret, false);
        for (String part : msg = this.transformSending("", tlvs)) {
            this.getHost().injectMessage(this.getSessionID(), part);
        }
    }

    public void abortSmp() throws OtrException {
        String[] msg;
        if (this != this.outgoingSession && this.getProtocolVersion() == 3) {
            this.outgoingSession.abortSmp();
            return;
        }
        if (this.getSessionStatus() != SessionStatus.ENCRYPTED) {
            return;
        }
        List<TLV> tlvs = this.getSmpTlvHandler().abortSmp();
        for (String part : msg = this.transformSending("", tlvs)) {
            this.getHost().injectMessage(this.getSessionID(), part);
        }
    }

    public boolean isSmpInProgress() {
        if (this != this.outgoingSession && this.getProtocolVersion() == 3) {
            return this.outgoingSession.isSmpInProgress();
        }
        return this.getSmpTlvHandler().isSmpInProgress();
    }

    public InstanceTag getSenderInstanceTag() {
        return this.senderTag;
    }

    public InstanceTag getReceiverInstanceTag() {
        return this.receiverTag;
    }

    public void setReceiverInstanceTag(InstanceTag receiverTag) {
        if (!this.isMasterSession) {
            return;
        }
        this.receiverTag = receiverTag;
    }

    public void setProtocolVersion(int protocolVersion) {
        if (!this.isMasterSession) {
            return;
        }
        this.protocolVersion = protocolVersion;
    }

    public int getProtocolVersion() {
        return this.isMasterSession ? this.protocolVersion : 3;
    }

    public List<Session> getInstances() {
        ArrayList<Session> result = new ArrayList<Session>();
        result.add(this);
        result.addAll(this.slaveSessions.values());
        return result;
    }

    public boolean setOutgoingInstance(InstanceTag tag) {
        if (!this.isMasterSession) {
            return false;
        }
        if (tag.equals(this.getReceiverInstanceTag())) {
            this.outgoingSession = this;
            for (OtrEngineListener l : this.listeners) {
                l.outgoingSessionChanged(this.sessionID);
            }
            return true;
        }
        Session newActiveSession = this.slaveSessions.get(tag);
        if (newActiveSession != null) {
            this.outgoingSession = newActiveSession;
            for (OtrEngineListener l : this.listeners) {
                l.outgoingSessionChanged(this.sessionID);
            }
            return true;
        }
        this.outgoingSession = this;
        return false;
    }

    public void respondSmp(InstanceTag receiverTag, String question, String secret) throws OtrException {
        if (receiverTag.equals(this.getReceiverInstanceTag())) {
            this.respondSmp(question, secret);
            return;
        }
        Session slave = this.slaveSessions.get(receiverTag);
        if (slave != null) {
            slave.respondSmp(question, secret);
        } else {
            this.respondSmp(question, secret);
        }
    }

    public SessionStatus getSessionStatus(InstanceTag tag) {
        if (tag.equals(this.getReceiverInstanceTag())) {
            return this.sessionStatus;
        }
        Session slave = this.slaveSessions.get(tag);
        return slave != null ? slave.getSessionStatus() : this.sessionStatus;
    }

    public PublicKey getRemotePublicKey(InstanceTag tag) {
        if (tag.equals(this.getReceiverInstanceTag())) {
            return this.remotePublicKey;
        }
        Session slave = this.slaveSessions.get(tag);
        return slave != null ? slave.getRemotePublicKey() : this.remotePublicKey;
    }

    public Session getOutgoingInstance() {
        return this.outgoingSession;
    }

    public static interface OTRv {
        public static final int ONE = 1;
        public static final int TWO = 2;
        public static final int THREE = 3;
        public static final Set<Integer> ALL = new HashSet<Integer>(Arrays.asList(1, 2, 3));
    }
}

