/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrException;
import net.java.otr4j.crypto.OtrCryptoEngine;
import net.java.otr4j.crypto.OtrCryptoException;
import net.java.otr4j.crypto.SM;
import net.java.otr4j.io.OtrOutputStream;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.TLV;

public class SmpTlvHandler {
    private SM.SMState smstate;
    private OtrEngineHost engineHost;
    private Session session;

    public SmpTlvHandler(Session session) {
        this.session = session;
        this.engineHost = session.getHost();
        this.reset();
    }

    public void reset() {
        this.smstate = new SM.SMState();
    }

    private static byte[] computeSessionId(BigInteger s) throws SM.SMException {
        MessageDigest sha256;
        byte[] sdata;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OtrOutputStream oos = new OtrOutputStream(out);
            oos.write(0);
            oos.writeBigInt(s);
            sdata = out.toByteArray();
            oos.close();
        }
        catch (IOException e1) {
            throw new SM.SMException(e1);
        }
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SM.SMException("cannot find SHA-256");
        }
        byte[] res = sha256.digest(sdata);
        byte[] secure_session_id = new byte[8];
        System.arraycopy(res, 0, secure_session_id, 0, 8);
        return secure_session_id;
    }

    public List<TLV> initRespondSmp(String question, String secret, boolean initiating) throws OtrException {
        byte[] smpmsg;
        MessageDigest sha256;
        byte[] sessionId;
        byte[] their_fp;
        if (!initiating && !this.smstate.asked) {
            throw new OtrException(new IllegalStateException("There is no question to be answered."));
        }
        byte[] our_fp = this.engineHost.getLocalFingerprintRaw(this.session.getSessionID());
        PublicKey remotePublicKey = this.session.getRemotePublicKey();
        try {
            their_fp = OtrCryptoEngine.getFingerprintRaw(remotePublicKey);
        }
        catch (OtrCryptoException e) {
            throw new OtrException(e);
        }
        try {
            sessionId = SmpTlvHandler.computeSessionId(this.session.getS());
        }
        catch (SM.SMException ex) {
            throw new OtrException(ex);
        }
        byte[] bytes = secret.getBytes(SerializationUtils.UTF8);
        int combined_buf_len = 41 + sessionId.length + bytes.length;
        byte[] combined_buf = new byte[combined_buf_len];
        combined_buf[0] = 1;
        if (initiating) {
            System.arraycopy(our_fp, 0, combined_buf, 1, 20);
            System.arraycopy(their_fp, 0, combined_buf, 21, 20);
        } else {
            System.arraycopy(their_fp, 0, combined_buf, 1, 20);
            System.arraycopy(our_fp, 0, combined_buf, 21, 20);
        }
        System.arraycopy(sessionId, 0, combined_buf, 41, sessionId.length);
        System.arraycopy(bytes, 0, combined_buf, 41 + sessionId.length, bytes.length);
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new OtrException(ex);
        }
        byte[] combined_secret = sha256.digest(combined_buf);
        try {
            smpmsg = initiating ? SM.step1(this.smstate, combined_secret) : SM.step2b(this.smstate, combined_secret);
        }
        catch (SM.SMException ex) {
            throw new OtrException(ex);
        }
        if (question != null && initiating) {
            bytes = question.getBytes(SerializationUtils.UTF8);
            byte[] qsmpmsg = new byte[bytes.length + 1 + smpmsg.length];
            System.arraycopy(bytes, 0, qsmpmsg, 0, bytes.length);
            System.arraycopy(smpmsg, 0, qsmpmsg, bytes.length + 1, smpmsg.length);
            smpmsg = qsmpmsg;
        }
        TLV sendtlv = new TLV(initiating ? (question != null ? 7 : 2) : 3, smpmsg);
        this.smstate.nextExpected = initiating ? 1 : 2;
        this.smstate.approved = initiating || question == null;
        return this.makeTlvList(sendtlv);
    }

    public List<TLV> abortSmp() throws OtrException {
        TLV sendtlv = new TLV(6, new byte[0]);
        this.smstate.nextExpected = 0;
        return this.makeTlvList(sendtlv);
    }

    public boolean isSmpInProgress() {
        return this.smstate.nextExpected > 0;
    }

    public String getFingerprint() {
        PublicKey pubKey = this.session.getRemotePublicKey();
        try {
            return OtrCryptoEngine.getFingerprint(pubKey);
        }
        catch (OtrCryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void processTlvSMP1Q(TLV tlv) throws OtrException {
        int tlvType = tlv.getType();
        if (this.smstate.nextExpected == 0) {
            int qlen;
            byte[] question = tlv.getValue();
            for (qlen = 0; qlen != question.length && question[qlen] != 0; ++qlen) {
            }
            qlen = qlen == question.length ? 0 : ++qlen;
            byte[] input = new byte[question.length - qlen];
            System.arraycopy(question, qlen, input, 0, question.length - qlen);
            try {
                SM.step2a(this.smstate, input, 1);
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (qlen != 0) {
                --qlen;
            }
            byte[] plainq = new byte[qlen];
            System.arraycopy(question, 0, plainq, 0, qlen);
            if (this.smstate.smProgState != -2) {
                this.smstate.asked = true;
                String questionUTF = null;
                try {
                    questionUTF = new String(plainq, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                this.engineHost.askForSecret(this.session.getSessionID(), this.session.getReceiverInstanceTag(), questionUTF);
            } else {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
                this.reset();
            }
        } else {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        }
    }

    public void processTlvSMP1(TLV tlv) throws OtrException {
        int tlvType = tlv.getType();
        if (this.smstate.nextExpected == 0) {
            try {
                SM.step2a(this.smstate, tlv.getValue(), 0);
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (this.smstate.smProgState != -2) {
                this.smstate.asked = true;
                this.engineHost.askForSecret(this.session.getSessionID(), this.session.getReceiverInstanceTag(), null);
            } else {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
                this.reset();
            }
        } else {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        }
    }

    public void processTlvSMP2(TLV tlv) throws OtrException {
        int tlvType = tlv.getType();
        if (this.smstate.nextExpected == 1) {
            byte[] nextmsg;
            try {
                nextmsg = SM.step3(this.smstate, tlv.getValue());
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (this.smstate.smProgState != -2) {
                String[] msg;
                TLV sendtlv = new TLV(4, nextmsg);
                this.smstate.nextExpected = 3;
                for (String part : msg = this.session.transformSending("", this.makeTlvList(sendtlv))) {
                    this.engineHost.injectMessage(this.session.getSessionID(), part);
                }
            } else {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
                this.reset();
            }
        } else {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        }
    }

    public void processTlvSMP3(TLV tlv) throws OtrException {
        int tlvType = tlv.getType();
        if (this.smstate.nextExpected == 2) {
            byte[] nextmsg;
            try {
                nextmsg = SM.step4(this.smstate, tlv.getValue());
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (this.smstate.smProgState == 1) {
                this.engineHost.verify(this.session.getSessionID(), this.getFingerprint(), this.smstate.approved);
            } else {
                this.engineHost.unverify(this.session.getSessionID(), this.getFingerprint());
            }
            if (this.smstate.smProgState != -2) {
                String[] msg;
                TLV sendtlv = new TLV(5, nextmsg);
                for (String part : msg = this.session.transformSending("", this.makeTlvList(sendtlv))) {
                    this.engineHost.injectMessage(this.session.getSessionID(), part);
                }
            } else {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
            }
            this.reset();
        } else {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        }
    }

    public void processTlvSMP4(TLV tlv) throws OtrException {
        int tlvType = tlv.getType();
        if (this.smstate.nextExpected == 3) {
            try {
                SM.step5(this.smstate, tlv.getValue());
            }
            catch (SM.SMException e) {
                throw new OtrException(e);
            }
            if (this.smstate.smProgState == 1) {
                this.engineHost.verify(this.session.getSessionID(), this.getFingerprint(), this.smstate.approved);
            } else {
                this.engineHost.unverify(this.session.getSessionID(), this.getFingerprint());
            }
            if (this.smstate.smProgState == -2) {
                this.engineHost.smpError(this.session.getSessionID(), tlvType, true);
            }
            this.reset();
        } else {
            this.engineHost.smpError(this.session.getSessionID(), tlvType, false);
        }
    }

    public void processTlvSMP_ABORT(TLV tlv) throws OtrException {
        this.engineHost.smpAborted(this.session.getSessionID());
        this.reset();
    }

    private List<TLV> makeTlvList(TLV sendtlv) {
        ArrayList<TLV> tlvs = new ArrayList<TLV>(1);
        tlvs.add(sendtlv);
        return tlvs;
    }
}

