/*
 * Decompiled with CFR 0.152.
 */
package de.duenndns.ssl;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import de.duenndns.ssl.MemorizingTrustManager;
import de.duenndns.ssl.R;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemorizingActivity
extends Activity
implements DialogInterface.OnClickListener,
DialogInterface.OnCancelListener {
    private static final Logger LOGGER = Logger.getLogger(MemorizingActivity.class.getName());
    int decisionId;
    AlertDialog dialog;

    public void onCreate(Bundle savedInstanceState) {
        LOGGER.log(Level.FINE, "onCreate");
        super.onCreate(savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        Intent i = this.getIntent();
        this.decisionId = i.getIntExtra("de.duenndns.ssl.DECISION.decisionId", 0);
        int titleId = i.getIntExtra("de.duenndns.ssl.DECISION.titleId", R.string.mtm_accept_cert);
        String cert = i.getStringExtra("de.duenndns.ssl.DECISION.cert");
        LOGGER.log(Level.FINE, "onResume with " + i.getExtras() + " decId=" + this.decisionId + " data: " + i.getData());
        this.dialog = new AlertDialog.Builder((Context)this).setTitle(titleId).setMessage((CharSequence)cert).setPositiveButton(R.string.mtm_decision_always, (DialogInterface.OnClickListener)this).setNeutralButton(R.string.mtm_decision_once, (DialogInterface.OnClickListener)this).setNegativeButton(R.string.mtm_decision_abort, (DialogInterface.OnClickListener)this).setOnCancelListener((DialogInterface.OnCancelListener)this).create();
        this.dialog.show();
    }

    protected void onPause() {
        if (this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
        super.onPause();
    }

    void sendDecision(int decision) {
        LOGGER.log(Level.FINE, "Sending decision: " + decision);
        MemorizingTrustManager.interactResult(this.decisionId, decision);
        this.finish();
    }

    public void onClick(DialogInterface dialog, int btnId) {
        int decision;
        dialog.dismiss();
        switch (btnId) {
            case -1: {
                decision = 3;
                break;
            }
            case -3: {
                decision = 2;
                break;
            }
            default: {
                decision = 1;
            }
        }
        this.sendDecision(decision);
    }

    public void onCancel(DialogInterface dialog) {
        this.sendDecision(1);
    }
}

