/*
 * Decompiled with CFR 0.152.
 */
package de.duenndns.ssl;

import android.app.Activity;
import android.app.Application;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.util.SparseArray;
import de.duenndns.ssl.MTMDecision;
import de.duenndns.ssl.MemorizingActivity;
import de.duenndns.ssl.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class MemorizingTrustManager
implements X509TrustManager {
    static final String DECISION_INTENT = "de.duenndns.ssl.DECISION";
    static final String DECISION_INTENT_ID = "de.duenndns.ssl.DECISION.decisionId";
    static final String DECISION_INTENT_CERT = "de.duenndns.ssl.DECISION.cert";
    static final String DECISION_INTENT_CHOICE = "de.duenndns.ssl.DECISION.decisionChoice";
    private static final Logger LOGGER = Logger.getLogger(MemorizingTrustManager.class.getName());
    static final String DECISION_TITLE_ID = "de.duenndns.ssl.DECISION.titleId";
    private static final int NOTIFICATION_ID = 100509;
    static String KEYSTORE_DIR = "KeyStore";
    static String KEYSTORE_FILE = "KeyStore.bks";
    Context master;
    Activity foregroundAct;
    NotificationManager notificationManager;
    private static int decisionId = 0;
    private static SparseArray<MTMDecision> openDecisions = new SparseArray();
    Handler masterHandler;
    private File keyStoreFile;
    private KeyStore appKeyStore;
    private X509TrustManager defaultTrustManager;
    private X509TrustManager appTrustManager;
    private boolean trustByDefault = false;

    public MemorizingTrustManager(Context m, X509TrustManager defaultTrustManager) {
        this.init(m);
        this.appTrustManager = this.getTrustManager(this.appKeyStore);
        this.defaultTrustManager = defaultTrustManager;
    }

    public MemorizingTrustManager(Context m) {
        this.init(m);
        this.appTrustManager = this.getTrustManager(this.appKeyStore);
        this.defaultTrustManager = this.getTrustManager(null);
    }

    void init(Context m) {
        Application app;
        this.master = m;
        this.masterHandler = new Handler(m.getMainLooper());
        this.notificationManager = (NotificationManager)this.master.getSystemService("notification");
        if (m instanceof Application) {
            app = (Application)m;
        } else if (m instanceof Service) {
            app = ((Service)m).getApplication();
        } else if (m instanceof Activity) {
            app = ((Activity)m).getApplication();
        } else {
            throw new ClassCastException("MemorizingTrustManager context must be either Activity or Service!");
        }
        File dir = app.getDir(KEYSTORE_DIR, 0);
        this.keyStoreFile = new File(dir + File.separator + KEYSTORE_FILE);
        this.appKeyStore = this.loadAppKeyStore();
    }

    public static X509TrustManager[] getInstanceList(Context c) {
        return new X509TrustManager[]{new MemorizingTrustManager(c)};
    }

    public void bindDisplayActivity(Activity act) {
        this.foregroundAct = act;
    }

    public void unbindDisplayActivity(Activity act) {
        if (this.foregroundAct == act) {
            this.foregroundAct = null;
        }
    }

    public static void setKeyStoreFile(String dirname, String filename) {
        KEYSTORE_DIR = dirname;
        KEYSTORE_FILE = filename;
    }

    public void setTrustByDefault(boolean trustByDefault) {
        this.trustByDefault = trustByDefault;
    }

    public Enumeration<String> getCertificates() {
        try {
            return this.appKeyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public Certificate getCertificate(String alias) {
        try {
            return this.appKeyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteCertificate(String alias) throws KeyStoreException {
        this.appKeyStore.deleteEntry(alias);
        this.keyStoreUpdated();
    }

    public HostnameVerifier wrapHostnameVerifier(HostnameVerifier defaultVerifier) {
        if (defaultVerifier == null) {
            throw new IllegalArgumentException("The default verifier may not be null");
        }
        return new MemorizingHostnameVerifier(defaultVerifier);
    }

    X509TrustManager getTrustManager(KeyStore ks) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init(ks);
            for (TrustManager t : tmf.getTrustManagers()) {
                if (!(t instanceof X509TrustManager)) continue;
                return (X509TrustManager)t;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "getTrustManager(" + ks + ")", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore loadAppKeyStore() {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            LOGGER.log(Level.SEVERE, "getAppKeyStore()", e);
            return null;
        }
        try {
            ks.load(null, null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.log(Level.SEVERE, "getAppKeyStore(" + this.keyStoreFile + ")", e);
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.keyStoreFile);
            ks.load(is, "MTM".toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.log(Level.INFO, "getAppKeyStore(" + this.keyStoreFile + ") - exception loading file key store");
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "getAppKeyStore(" + this.keyStoreFile + ") - exception closing file key store input stream");
                }
            }
        }
        return ks;
    }

    void storeCert(String alias, Certificate cert) {
        try {
            this.appKeyStore.setCertificateEntry(alias, cert);
        }
        catch (KeyStoreException e) {
            LOGGER.log(Level.SEVERE, "storeCert(" + cert + ")", e);
            return;
        }
        this.keyStoreUpdated();
    }

    void storeCert(X509Certificate cert) {
        this.storeCert(cert.getSubjectDN().toString(), cert);
    }

    void keyStoreUpdated() {
        this.appTrustManager = this.getTrustManager(this.appKeyStore);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.keyStoreFile);
            this.appKeyStore.store(fos, "MTM".toCharArray());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "storeCert(" + this.keyStoreFile + ")", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "storeCert(" + this.keyStoreFile + ")", e);
                }
            }
        }
    }

    private boolean isCertKnown(X509Certificate cert) {
        try {
            return this.appKeyStore.getCertificateAlias(cert) != null;
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    private boolean isExpiredException(Throwable e) {
        do {
            if (!(e instanceof CertificateExpiredException)) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    private boolean isPathException(Throwable e) {
        do {
            if (!(e instanceof CertPathValidatorException)) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    public void checkCertTrusted(X509Certificate[] chain, String authType, boolean isServer) throws CertificateException {
        LOGGER.log(Level.FINE, "checkCertTrusted(" + chain + ", " + authType + ", " + isServer + ")");
        try {
            LOGGER.log(Level.FINE, "checkCertTrusted: trying appTrustManager");
            if (isServer) {
                this.appTrustManager.checkServerTrusted(chain, authType);
            } else {
                this.appTrustManager.checkClientTrusted(chain, authType);
            }
        }
        catch (CertificateException ae) {
            LOGGER.log(Level.FINER, "checkCertTrusted: appTrustManager failed", ae);
            if (this.isExpiredException(ae)) {
                LOGGER.log(Level.INFO, "checkCertTrusted: accepting expired certificate from keystore");
                return;
            }
            if (this.isCertKnown(chain[0])) {
                LOGGER.log(Level.INFO, "checkCertTrusted: accepting cert already stored in keystore");
                return;
            }
            try {
                if (this.defaultTrustManager == null) {
                    throw ae;
                }
                LOGGER.log(Level.FINE, "checkCertTrusted: trying defaultTrustManager");
                if (isServer) {
                    this.defaultTrustManager.checkServerTrusted(chain, authType);
                } else {
                    this.defaultTrustManager.checkClientTrusted(chain, authType);
                }
            }
            catch (CertificateException e) {
                LOGGER.log(Level.FINER, "checkCertTrusted: defaultTrustManager failed", e);
                this.interactCert(chain, authType, e);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertTrusted(chain, authType, false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertTrusted(chain, authType, true);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        LOGGER.log(Level.FINE, "getAcceptedIssuers()");
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createDecisionId(MTMDecision d) {
        int myId;
        SparseArray<MTMDecision> sparseArray = openDecisions;
        synchronized (sparseArray) {
            myId = decisionId++;
            openDecisions.put(myId, (Object)d);
        }
        return myId;
    }

    private static String hexString(byte[] data) {
        StringBuffer si = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            si.append(String.format("%02x", data[i]));
            if (i >= data.length - 1) continue;
            si.append(":");
        }
        return si.toString();
    }

    private static String certHash(X509Certificate cert, String digest) {
        try {
            MessageDigest md = MessageDigest.getInstance(digest);
            md.update(cert.getEncoded());
            return MemorizingTrustManager.hexString(md.digest());
        }
        catch (CertificateEncodingException e) {
            return e.getMessage();
        }
        catch (NoSuchAlgorithmException e) {
            return e.getMessage();
        }
    }

    private void certDetails(StringBuffer si, X509Certificate c) {
        SimpleDateFormat validityDateFormater = new SimpleDateFormat("yyyy-MM-dd");
        si.append("\n");
        si.append(c.getSubjectDN().toString());
        si.append("\n");
        si.append(validityDateFormater.format(c.getNotBefore()));
        si.append(" - ");
        si.append(validityDateFormater.format(c.getNotAfter()));
        si.append("\nSHA-256: ");
        si.append(MemorizingTrustManager.certHash(c, "SHA-256"));
        si.append("\nSHA-1: ");
        si.append(MemorizingTrustManager.certHash(c, "SHA-1"));
        si.append("\nSigned by: ");
        si.append(c.getIssuerDN().toString());
        si.append("\n");
    }

    private String certChainMessage(X509Certificate[] chain, CertificateException cause) {
        Throwable e = cause;
        LOGGER.log(Level.FINE, "certChainMessage for " + e);
        StringBuffer si = new StringBuffer();
        if (this.isPathException(e)) {
            si.append(this.master.getString(R.string.mtm_trust_anchor));
        } else if (this.isExpiredException(e)) {
            si.append(this.master.getString(R.string.mtm_cert_expired));
        } else {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            si.append(e.getLocalizedMessage());
        }
        si.append("\n\n");
        si.append(this.master.getString(R.string.mtm_connect_anyway));
        si.append("\n\n");
        si.append(this.master.getString(R.string.mtm_cert_details));
        for (X509Certificate c : chain) {
            this.certDetails(si, c);
        }
        return si.toString();
    }

    private String hostNameMessage(X509Certificate cert, String hostname) {
        StringBuffer si = new StringBuffer();
        si.append(this.master.getString(R.string.mtm_hostname_mismatch, new Object[]{hostname}));
        si.append("\n\n");
        try {
            Collection<List<?>> sans = cert.getSubjectAlternativeNames();
            if (sans == null) {
                si.append(cert.getSubjectDN());
                si.append("\n");
            } else {
                for (List<?> altName : sans) {
                    Object name = altName.get(1);
                    if (!(name instanceof String)) continue;
                    si.append("[");
                    si.append((Integer)altName.get(0));
                    si.append("] ");
                    si.append(name);
                    si.append("\n");
                }
            }
        }
        catch (CertificateParsingException e) {
            e.printStackTrace();
            si.append("<Parsing error: ");
            si.append(e.getLocalizedMessage());
            si.append(">\n");
        }
        si.append("\n");
        si.append(this.master.getString(R.string.mtm_connect_anyway));
        si.append("\n\n");
        si.append(this.master.getString(R.string.mtm_cert_details));
        this.certDetails(si, cert);
        return si.toString();
    }

    void startActivityNotification(Intent intent, int decisionId, String certName) {
        Notification n = new Notification(17301551, (CharSequence)this.master.getString(R.string.mtm_notification), System.currentTimeMillis());
        PendingIntent call = PendingIntent.getActivity((Context)this.master, (int)0, (Intent)intent, (int)0);
        n.setLatestEventInfo(this.master.getApplicationContext(), (CharSequence)this.master.getString(R.string.mtm_notification), (CharSequence)certName, call);
        n.flags |= 0x10;
        this.notificationManager.notify(100509 + decisionId, n);
    }

    Context getUI() {
        return this.foregroundAct != null ? this.foregroundAct : this.master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int interact(final String message, final int titleId) {
        MTMDecision choice = new MTMDecision();
        final int myId = this.createDecisionId(choice);
        this.masterHandler.post(new Runnable(){

            @Override
            public void run() {
                Intent ni = new Intent(MemorizingTrustManager.this.master, MemorizingActivity.class);
                ni.setFlags(0x10000000);
                ni.setData(Uri.parse((String)(MemorizingTrustManager.class.getName() + "/" + myId)));
                ni.putExtra(MemorizingTrustManager.DECISION_INTENT_ID, myId);
                ni.putExtra(MemorizingTrustManager.DECISION_INTENT_CERT, message);
                ni.putExtra(MemorizingTrustManager.DECISION_TITLE_ID, titleId);
                try {
                    MemorizingTrustManager.this.getUI().startActivity(ni);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "startActivity(MemorizingActivity)", e);
                    MemorizingTrustManager.this.startActivityNotification(ni, myId, message);
                }
            }
        });
        LOGGER.log(Level.FINE, "openDecisions: " + openDecisions + ", waiting on " + myId);
        try {
            MTMDecision mTMDecision = choice;
            synchronized (mTMDecision) {
                choice.wait();
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINER, "InterruptedException", e);
        }
        LOGGER.log(Level.FINE, "finished wait on " + myId + ": " + choice.state);
        return choice.state;
    }

    void interactCert(X509Certificate[] chain, String authType, CertificateException cause) throws CertificateException {
        if (this.trustByDefault) {
            this.storeCert(chain[0]);
            return;
        }
        switch (this.interact(this.certChainMessage(chain, cause), R.string.mtm_accept_cert)) {
            case 3: {
                this.storeCert(chain[0]);
            }
            case 2: {
                break;
            }
            default: {
                throw cause;
            }
        }
    }

    boolean interactHostname(X509Certificate cert, String hostname) {
        if (this.trustByDefault) {
            this.storeCert(hostname, cert);
            return true;
        }
        switch (this.interact(this.hostNameMessage(cert, hostname), R.string.mtm_accept_servername)) {
            case 3: {
                this.storeCert(hostname, cert);
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void interactResult(int decisionId, int choice) {
        MTMDecision d;
        Object object = openDecisions;
        synchronized (object) {
            d = (MTMDecision)openDecisions.get(decisionId);
            openDecisions.remove(decisionId);
        }
        if (d == null) {
            LOGGER.log(Level.SEVERE, "interactResult: aborting due to stale decision reference!");
            return;
        }
        object = d;
        synchronized (object) {
            d.state = choice;
            d.notify();
        }
    }

    class MemorizingHostnameVerifier
    implements HostnameVerifier {
        private HostnameVerifier defaultVerifier;

        public MemorizingHostnameVerifier(HostnameVerifier wrapped) {
            this.defaultVerifier = wrapped;
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            LOGGER.log(Level.FINE, "hostname verifier for " + hostname + ", trying default verifier first");
            if (this.defaultVerifier.verify(hostname, session)) {
                LOGGER.log(Level.FINE, "default verifier accepted " + hostname);
                return true;
            }
            try {
                X509Certificate cert = (X509Certificate)session.getPeerCertificates()[0];
                if (cert.equals(MemorizingTrustManager.this.appKeyStore.getCertificate(hostname.toLowerCase(Locale.US)))) {
                    LOGGER.log(Level.FINE, "certificate for " + hostname + " is in our keystore. accepting.");
                    return true;
                }
                LOGGER.log(Level.FINE, "server " + hostname + " provided wrong certificate, asking user.");
                return MemorizingTrustManager.this.interactHostname(cert, hostname);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

